﻿/*global $, fsm, globals, gds$*/
/*jslint browser: true*/

var primaryFunction = (function () {
    var my = {},
        gdsAppName = 'gira-app',
        commandSend = false;

    my.primaryFunctionContent = undefined;

    /**
    * Registers and handles all events and timeouts which are used to open, close and trigger
    * the primary function.
    * 
    */
    $(function () {
        var overlayActionTimeout;
        var overlayCloseTimeout;

        $(document).bind("primaryFunctionStart", function () {


            if (!primaryFunction.isPrimaryFunctionActive())
                return;

            // Start primary function trigger timeout
            /*overlayActionTimeout = setTimeout(function () {
                $('#pf_detailId').trigger("callPrimaryFunction");
            }, globals.primaryFunction.actionTimer);*/

            // Open primary function overlay
            fsm.API.PrimaryFunction.Open();
            $('#pf_detailId').trigger("callPrimaryFunction");

            // Start primary function close timeout
            clearTimeout(overlayCloseTimeout);
            overlayCloseTimeout = setTimeout(function () {
                fsm.API.PrimaryFunction.Close();
            }, globals.primaryFunction.closeTimer);

            // Reset primary function close timeout
            $(document).on("touchstart mousedown", function () {
                clearTimeout(overlayCloseTimeout);
                overlayCloseTimeout = setTimeout(function () {
                    fsm.API.PrimaryFunction.Close();
                }, globals.primaryFunction.closeTimer);
            });

        });

        // Cancel primary function trigger timeout
        $(document).bind("primaryFunctionEnd", function () {
            clearTimeout(overlayActionTimeout);
        });
    });

    // send the trigger command only one time in 800ms
    function sendCommand(tag) {
        if (!commandSend) {
            commandSend = true;
            setTimeout(function () {
                ComClient.sendTagValue(tag, 1);
                commandSend = false;
            }, 800);
        }
    }

    my.eventsOnPrimFuncTrigger = function (id, tag) {
        var triggerJQuery = $(id).find('.primary-button');
        var triggerReflexion = $(triggerJQuery).find('.sprites');

        $(id).on('callPrimaryFunction', function () {
            sendCommand(tag);
        });

        registerEventsForSwipeableElement(triggerJQuery,
            function() {
                triggerJQuery.removeClass("primary-button");
                triggerJQuery.addClass("primary-button-down");
                triggerReflexion.hide();
            },
            function() {
                triggerJQuery.addClass("primary-button");
                triggerJQuery.removeClass("primary-button-down");
                triggerReflexion.show();
            },
            function() {
                sendCommand(tag);
            }
        );
    };

    /*
    * Saves a given primaryfunction via the GDS app value API.
    * @param {arg} the template filename shown in the primary function overlay (without extension)
    */
    my.savePrimaryFunction = function (arg) {
        my.primaryFunctionContent = arg;
        gds$.setAppValue(gdsAppName, "primaryfunction.json", arg);
        if (my.isPrimaryFunctionActive()) {
            fsm.API.PrimaryFunction.Enable();
        }
    };

    /*
    * Returns the locally cached primary function content (template filename without extension). 
    * If no cached content is found, the function tries to retrieve it from the GDS.
    * Please note: appData is loaded asynchronous so the return value might still be undefined or a old cached value if file access is slow
    */
    my.getPrimaryFunction = function() {
        if (!my.primaryFunctionContent) {
            loadPrimaryFunctionFromAppData();
        } 
        return my.primaryFunctionContent;
    };

    /*
    * Helper function to load the saved primary function from GDS appdata.
    */
    function loadPrimaryFunctionFromAppData() {
        gds$.getAppValue(gdsAppName, "primaryfunction.json", function(response) {
            my.primaryFunctionContent = response.value;
            if (my.isPrimaryFunctionActive()) {
                fsm.API.PrimaryFunction.Enable();
            }
        });
    }

    /*
    * Helper function to delete the GDS appdata for primary function.
    */
    function resetPrimaryFunction() {
        my.primaryFunctionContent = undefined;
        gds$.deleteAppValue(gdsAppName, "primaryfunction.json");
    }

    /*
    * helper Function to check if a primary function is set by the user
    */ 
    my.isPrimaryFunctionActive = function () {
        if (my.primaryFunctionContent) {
            return true;
        }
        return false;
    };

    my.eventsOnPrimFuncSceneTrigger = function(id, tag) {
        var triggerJQuery = $(id).find('.primary-button');
        var triggerReflexion = $(triggerJQuery).find('.sprites');

        $(id).on('callPrimaryFunction', function() {
            sendCommand(tag);
            $('#overlay').one('animationend webkitAnimationEnd', function() {
                changeSceneTriggerButtonState(id);
            });
        });

        registerEventsForSwipeableElement(triggerJQuery,
            function() {
                triggerJQuery.removeClass("primary-button");
                triggerJQuery.addClass("primary-button-down");
                triggerReflexion.hide();
            },
            function() {
                triggerJQuery.addClass("primary-button");
                triggerJQuery.removeClass("primary-button-down");
                triggerReflexion.show();
            },
            function() {
                if (!triggerJQuery.find('.trigger-text-off').is(':animated')) {
                    sendCommand(tag);
                    changeSceneTriggerButtonState(id);
                }
            }
        );
    };

    /**
     * Opens the specified overlay with the primary function animation.
     * 
     */
    function openPrimaryFunctionOverlay() {
        var swiper = NavbarController.getInstance()._swiper;
        if (swiper) {
            swiper.swipeTo(swiper.activeIndex);
        }
        var overlayContent = { filename: primaryFunction.getPrimaryFunction() + '.xhtml', returnValue: null };

        tsx.Overlay.initPrimaryFunction(overlayContent);
        my._primaryFunctionOverlayUID = overlayContent.returnValue;

        $('#overlay').data('caseSets', temporaryCaseSets);
        temporaryCaseSets = [];
        registerEventsForPressButton($('#overlay .pf_backBtn'), undefined, undefined, function () {
            fsm.API.PrimaryFunction.Close();
        });
        $('#overlay').one('animationend webkitAnimationEnd', function () {
            var caseSets = $('#overlay').data('caseSets');
            if (caseSets !== null && caseSets != undefined) ComClient.registerAll(caseSets);
        });
    }

    (function () {
        fsm.API.PrimaryFunction.Init(resetPrimaryFunction, openPrimaryFunctionOverlay, function () { tsx.Overlay.close(my._primaryFunctionOverlayUID, true); });
    })();

    tsxGdsUtility$.ready(function () {
        //initialize primary function from app data
        loadPrimaryFunctionFromAppData();
    });

    return my;
}());