/*global $, tsx, moment, fsm, generateUID*/
/*jslint browser: true*/

/**
 * The Class tsx.Overlay handles the Overlay Window
 * 
 */
tsx.Overlay = (function () {
    var overlay = {};
    
    var mTimeOutSeconds = 60000; //60 Sekunden
    var mTimeOut;
    var cancelPressed = false;
    var mUID = "";
    var mCallBackTimeout = undefined; // wifi settings
    overlay.tos; //time out seconds for external change (wifi settings overlay)
    var mCountdownInterval;



    /**
     * Initialize the Overlay Window for the Black Screen-fadeout
     *
     */
    overlay.initBlack = function () {
        load("black_transition.xhtml");
        $("#black_transition").css({ opacity: 1 });
    };

    /**
     * close the Black Overlay Screen
     *
     */
    overlay.closeBlack = function () {
        var blackTransition = $("#black_transition");
        // remove immediately if no animation would be performed
        if (blackTransition.css("opacity") == 0) {
            blackTransition.remove();
            return;
        }
        blackTransition.css({ opacity: 0 });
        blackTransition.one('webkitTransitionEnd otransitionend oTransitionEnd msTransitionEnd transitionend', function () {
            blackTransition.remove();

        });
    };

    /**
     * Initialize the Overlay Window for the Primaryfunction
     * with xhtmlFile to load the correct function and the Javascript Callbackfunction
     *
     * @param {string, string} jso {filename, returnValue}
     *                  Filename with extension
     *
     */
    overlay.initPrimaryFunction = function (jso) {
        if (jso) {
            load(jso.filename);
            mUID = generateUID();

            show(false);
            jso.returnValue = mUID;
        }
    };

    /**
     * Initialize the General Overlay Window
     * with messageOne for the header, messageTwo for the description, 
     * spinner, cancelButton and the Javascript Callbackfunction
     *
     * @param {string} messageOne 
     *       
     * @param {string} messageTwo 
     *     
     * @param {boolean} spinner 
     * 
     * @param {boolean} cancelButton 
     * 
     * @param {function} callbackFunc 
     * 
     * @param {string} jso {returnValue}
     * 
     */
    overlay.init = function (messageOne, messageTwo, hasSpinner, hasCancelButton, callbackFunc, jso, countdown) {
        var isOn = ($("#overlay").length === 1);
        if (!isOn) {
            load("overlay.xhtml");
            mUID = generateUID();
        }
        if (jso) {
            jso.returnValue = mUID;
        }
        mTimeOutSeconds = 60000;
        rewriteOverlay(messageOne, messageTwo, hasSpinner, hasCancelButton, callbackFunc, countdown);

        if (!isOn) {
            show(true);
        }
    };

    overlay.addCallbackTimeout = function (cb) {
        mCallBackTimeout = cb;
    };

    function startCountdown() {
        $("#overlay .headline .overlay-countdown-text").show();
        $("#overlay .headline .overlay-countdown").text(moment(mTimeOutSeconds).format("m:ss"));
        var startTime = moment();
        mCountdownInterval = setInterval(function () {
            var current = moment();
            var countdownTime = startTime.diff(current) + mTimeOutSeconds;
            if (countdownTime < 1000) clearInterval(mCountdownInterval);
            $("#overlay .headline .overlay-countdown").text(moment(countdownTime).format("m:ss"));
        }, 500);
    }

    function hideCountdown() {
        $("#overlay .headline .overlay-countdown-text").hide();
    }


    function rewriteOverlay(messageOne, messageTwo, hasSpinner, hasCancelButton, callbackFunc, countdown) {
        var $overlayContent = $("#overlay > #content"),
            I18nTexts = window.Gira.appLang.appI18nTexts;
        $overlayContent.find(".headline .main-text").text(messageOne);
        $overlayContent.find(".description-text").text(messageTwo);
        $overlayContent.find(".spinner").css("display", hasSpinner ? "block" : "none");
        $overlayContent.find(".cancelbutton").text(I18nTexts.wifiSettingsButtonCancel).css("display", hasCancelButton ? "block" : "none").on("click", function () {
            cancelPressed = true;
            fsm.API.Overlay.Close(mUID);
        });
        if (typeof callbackFunc == 'function') {
            callbackFunc();
            if (typeof tsx.Overlay.tos != 'undefined') {
                mTimeOutSeconds = tsx.Overlay.tos;
            }
        }
        if (countdown) {
            startCountdown();
        } else {
            hideCountdown();
        }
    }
    
    /**
     * shows the Overlays with animations
     */
    function show(isToBeClosedByTimeOut) {
        $("#overlay").addClass("animated primary-fadeIn-animation");
        var content = $("#overlay > #content");
        $(".pf_description-row, .cancelbutton, .headline, .description-text, .hr", content).addClass("animated primary-function-slideIn");
        $(".spinner, .pf_detail", content).addClass("animated overlay-function-scaleIn");

        $("#overlay").bind('animationend webkitAnimationEnd', function () {
            $("#overlay").unbind('animationend webkitAnimationEnd');
            $("#overlay > #content > .pf_description-row").removeClass("animated primary-function-slideIn");
            $("#overlay > #content > .cancelbutton").removeClass("animated primary-function-slideIn");
            $("#overlay > #content > .headline").removeClass("animated primary-function-slideIn");
            $("#overlay > #content > .description-text").removeClass("animated primary-function-slideIn");
            $("#overlay > #content > .hr").removeClass("animated primary-function-slideIn");
            $("#overlay > #content > .spinner").removeClass("animated overlay-function-scaleIn");
            $("#overlay").removeClass("animated primary-fadeIn-animation");
            $("#overlay > #content > .pf_detail").removeClass("animated overlay-function-scaleIn");
            $("#overlay > #content > .spinner").addClass("spinneranimation");
            if (isToBeClosedByTimeOut) {
                mTimeOut = setTimeout(function() {
                    fsm.API.Overlay.Close(mUID);
                }, mTimeOutSeconds);
            }
        });
    }

    /**
     * close the overlay
     *
     * @param {string} uid 
     *          uid to get rights to close the overlay
     */
    overlay.close = function (uid, hasToBeAnimated) {
        if (mUID === uid) {
            overlay.closeAll(hasToBeAnimated);
        }
    };

    overlay.closeAll = function (hasToBeAnimated) {
        if ($("#overlay").length > 0) {

            var caseSets = $("#overlay").data('caseSets');
            if (caseSets !== null && caseSets != undefined) ComClient.unregisterAll(caseSets);
            $("#overlay").addClass("animated  primary-function-fadeOut");
            $("#overlay > #content > .spinner").removeClass("spinneranimation");

            $("#overlay > #content > .pf_description-row").addClass("animated primary-function-slideOut");
            $("#overlay > #content > .pf_detail").addClass("animated primary-function-scaleOut");

            $("#overlay > #content > .headline").addClass("animated primary-function-slideOut");
            $("#overlay > #content > .cancelbutton").addClass("animated primary-function-slideOut");
            $("#overlay > #content > .description-text").addClass("animated primary-function-slideOut");
            $("#overlay > #content > .hr").addClass("animated primary-function-slideOut");
            $("#overlay > #content > .spinner").addClass("animated primary-function-scaleOut");

            clearTimeout(mTimeOut);
            $("#overlay").addClass("animated  primary-function-fadeOut");
            if (hasToBeAnimated) {
                $("#overlay").bind('animationend webkitAnimationEnd', function () {
                    destroy();
                });
            } else {
                destroy();
            }
        }
    };

    /**
     * destroys the overlay in the dom tree
     */
    function destroy() {
        clearInterval(mCountdownInterval);
        $("#overlay").remove();

        if( typeof mCallBackTimeout == 'function' ) {
                mCallBackTimeout(cancelPressed);
        }
        mCallBackTimeout = undefined;
    }

    /*
     * ajax call to load the overlay template
     */
    function load(xhtmlFile) {
        $.ajax({
            url: "templates/overlays/" + xhtmlFile,
            data: {},
            cache: false,
            async: false,
            success: function (data) {
                var $data = $(data);
                $("body").append($data);
                // force layout
                var x = $data[0].clientHeight;
            },
            dataType: 'html'
        });
    }

    return overlay;
}());

(function () {
    var openCallback = function (args) {
        tsx.Overlay.init(args.messageOne, args.messageTwo, args.hasSpinner, args.hasCancelButton, args.func, args.jso, args.countdown);
    };
    var closeCallback = function (args) { tsx.Overlay.close(args, true); };
    var openBlackCallback = function () { tsx.Overlay.initBlack(); };
    var closeBlackCallback = function () { tsx.Overlay.closeBlack(); };
    var closeAllCallback = function () { tsx.Overlay.closeAll(); };
    fsm.API.Overlay.Init(openCallback, closeCallback, openBlackCallback, closeBlackCallback, closeAllCallback);
})();
