/*global $, tsx, gds$, SettingsElements*/
/*jslint browser: true*/

/**
 * This modules handles wifi connection handling + dialogs.
 */
tsx.NetworkSettings = (function () {
    var module = {};

    /**
     * Intitializes the LAN formular with the curretn GDS config values
     */
    module.initLanSettings = function () {
        SettingsElements['LAN_IPV4'] = $("input[settingId='LAN_IPV4']").parents('.settings-row.inputField').attr("id");
        SettingsElements['LAN_IPV4_SUBNETMASK'] = $("input[settingId='LAN_IPV4_SUBNETMASK']").parents('.settings-row.inputField').attr("id");
        SettingsElements['LAN_IPV4_DNS'] = $("input[settingId='LAN_IPV4_DNS']").parents('.settings-row.inputField').attr("id");
        SettingsElements['LAN_IPV4_GATEWAY'] = $("input[settingId='LAN_IPV4_GATEWAY']").parents('.settings-row.inputField').attr("id");
        SettingsElements['MAC_ADDRESS'] = $("div[rowid='MAC_ADDRESS']").parents('.settings-row.inputField').attr("id");

        $('#' + SettingsElements['LAN_DHCP']).bind("change",
            function() {
                disableLanSettings($('#' + SettingsElements['LAN_DHCP']).prop('checked'));

                if ($('#' + SettingsElements['LAN_DHCP']).prop('checked')) {
                    $(menuId).find('div#ok').removeClass('disabled');
                } else {
                    var valid = checkAllIpAddressFieldsValidity();
                    if (!valid) {
                        $(menuId).find('div#ok').addClass('disabled');
                    } else {
                        $(menuId).find('div#ok').removeClass('disabled');
                    }
                }
            });

        var menuPage = $('#' + SettingsElements['LAN_IPV4']).parents('.menuPage').attr('id');
        $('#' + SettingsElements['LAN_IPV4'] + '> .input').bind('input', function () { onLanAddressFieldChange(); });
        $('#' + SettingsElements['LAN_IPV4_SUBNETMASK'] + '> .input').bind('input', function () { onLanAddressFieldChange(); });
        $('#' + SettingsElements['LAN_IPV4_DNS'] + '> .input').bind('input', function () { onLanAddressFieldChange(); });
        $('#' + SettingsElements['LAN_IPV4_GATEWAY'] + '> .input').bind('input', function () { onLanAddressFieldChange(); });

        gds$.updateDeviceConfiguration(false, function (config) {
            if (config != null) {
                var connectedNetwork = getConnectedNetwork(config),
                    macAddress = "";
                if (connectedNetwork === undefined) {
                    macAddress = getMacByNetworkType(config);
                } else {
                    macAddress = connectedNetwork['macAddress'];
                }
                $('#' + SettingsElements['MAC_ADDRESS'] + '> .disabled-input').text(macAddress);

                $('#' + SettingsElements['LAN_IPV4'] + '> .input').val(connectedNetwork['ipAddress']);
                $('#' + SettingsElements['LAN_IPV4_SUBNETMASK'] + '> .input').val(connectedNetwork['subnetMask']);
                $('#' + SettingsElements['LAN_IPV4_DNS'] + '> .input').val(connectedNetwork['domainNameServer1']);
                $('#' + SettingsElements['LAN_IPV4_GATEWAY'] + '> .input').val(connectedNetwork['defaultGateway']);

                var dhcpEnabled = connectedNetwork['mode'] == 'dhcp' ? true : false;
                changeToggleSwitchButtonState(SettingsElements['LAN_DHCP'], dhcpEnabled);
                disableLanSettings(dhcpEnabled);

                var valid = checkAllIpAddressFieldsValidity();
                if (!valid)
                    $(menuId).find('div#ok').addClass('disabled');
            } else {
                $(menuId).find('div#ok').addClass('disabled');
            }
        });

        // enabled/disabled the OK Button 
        var valid = checkAllIpAddressFieldsValidity();
        if (!valid)
            $(menuId).find('div#ok').addClass('disabled');
        else
            $(menuId).find('div#ok').removeClass('disabled');
    };

    /**
     * Submits LAN setting values to the GDS
     */
    module.setLanSettings = function() {
        gds$.updateDeviceConfiguration(false, function (deviceConfig) {
            var connectedNetwork = getConnectedNetwork(deviceConfig);
            if (connectedNetwork) {
                var networkPraefix = 'NetworkServices_' + connectedNetwork['identifier'];
                setNewNetworkData(networkPraefix);
            }
        });
    };

    /**
    * Check for valid IP addresses in all required fields
    */
    function checkAllIpAddressFieldsValidity() {
        var menuPage = $(menuId);
        var addressField = menuPage.find('#' + SettingsElements['LAN_IPV4'] + '> .input')[0];
        var subnetField = menuPage.find('#' + SettingsElements['LAN_IPV4_SUBNETMASK'] + '> .input')[0];
        var dnsaddrField = menuPage.find('#' + SettingsElements['LAN_IPV4_DNS'] + '> .input')[0];
        var gatewayField = menuPage.find('#' + SettingsElements['LAN_IPV4_GATEWAY'] + '> .input')[0];

        return addressField.validity.valid && subnetField.validity.valid && dnsaddrField.validity.valid && gatewayField.validity.valid;
    }

    /**
    * This function parses the GDS config and looks for the connected network; it returns the
    * network data array or undefined, if no connected network was found
    */
    function getConnectedNetwork(deviceConfig) {
        var networkList = deviceConfig['networkServices'],
            connectedNetwork = undefined;
        // check if received "network services" is  array, it could be empty string too in which case we get exception
         if (Object.prototype.toString.call(networkList) === "[object Array]") {
             networkList.forEach(function (network) {
                 if (network['connected'] === 'true') {
                     connectedNetwork = network;
                 }
             });
         }
        return connectedNetwork;
    }
    /**
     * This function parses the GDS config and looks for in network technologies element which type of network is active (powered)
     * based on that information it return macAddress1 or macAddress2
     */
    function getMacByNetworkType(config) {
        var networkType = _.find(config.networkTechnologies, function (tech) {
                return tech.powered === "true";
            }),
            macAddress = "";
        if (networkType !== undefined) {
            switch (networkType.identifier) {
                case "ethernet":
                    macAddress = config.hardware.macAddress1;
                    break;
                case "wifi":
                    macAddress = config.hardware.macAddress2;
                    break;
            }
        }
        return macAddress;
    }

    /**
    * Apply the new network settings to the GDS network configuration; networkPraefix m
    */
    function setNewNetworkData(networkPraefix) {
        var menuPage = $(".menuPage");
        if (networkPraefix) {
            var networkData = {};
            networkData[networkPraefix + '_Connected'] = 'true';
            networkData[networkPraefix + '_ConnectionError'] = 'false';
            networkData[networkPraefix + '_IpAddress'] = '';
            networkData[networkPraefix + '_SubnetMask'] = '';
            networkData[networkPraefix + '_DomainNameServer1'] = '';
            networkData[networkPraefix + '_DomainNameServer2'] = '';
            networkData[networkPraefix + '_DefaultGateway'] = '';
            if ($('#' + SettingsElements['LAN_DHCP'], menuPage).prop('checked')) {
                networkData[networkPraefix + '_Mode'] = 'dhcp';
            } else {
                networkData[networkPraefix + '_Mode'] = 'manual';
                networkData[networkPraefix + '_IpAddress'] = $('#' + SettingsElements['LAN_IPV4'] + '> .input', menuPage).val();
                networkData[networkPraefix + '_SubnetMask'] = $('#' + SettingsElements['LAN_IPV4_SUBNETMASK'] + '> .input', menuPage).val();
                networkData[networkPraefix + '_DomainNameServer1'] = $('#' + SettingsElements['LAN_IPV4_DNS'] + '> .input', menuPage).val();
                networkData[networkPraefix + '_DefaultGateway'] = $('#' + SettingsElements['LAN_IPV4_GATEWAY'] + '> .input', menuPage).val();
            }

            gds$.setDeviceConfigurationValue(true, networkData);
        }    
    }

    /**
     * Set LAN settings input elements and label disabled
     * 
     * @param boolean disable
     */
    function disableLanSettings(disable) {
        var menuPage = $(".menuPage");
        $('#' + SettingsElements['LAN_IPV4'] + '> .input', menuPage).prop('disabled', disable);
        $('#' + SettingsElements['LAN_IPV4_SUBNETMASK'] + '> .input', menuPage).prop('disabled', disable);
        $('#' + SettingsElements['LAN_IPV4_DNS'] + '> .input', menuPage).prop('disabled', disable);
        $('#' + SettingsElements['LAN_IPV4_GATEWAY'] + '> .input', menuPage).prop('disabled', disable);

        var addClass = disable === true ? 't3lsg inactive' : 't3lsg';
        var removeClass = disable === true ? 't3lsg' : 't3lsg inactive';

        $('#' + SettingsElements['LAN_IPV4'] + '> .settings-row-inputField-lable', menuPage).removeClass(removeClass).addClass(addClass);
        $('#' + SettingsElements['LAN_IPV4_SUBNETMASK'] + '> .settings-row-inputField-lable', menuPage).removeClass(removeClass).addClass(addClass);
        $('#' + SettingsElements['LAN_IPV4_DNS'] + '> .settings-row-inputField-lable', menuPage).removeClass(removeClass).addClass(addClass);
        $('#' + SettingsElements['LAN_IPV4_GATEWAY'] + '> .settings-row-inputField-lable', menuPage).removeClass(removeClass).addClass(addClass);
    }

    function onLanAddressFieldChange() {
        var valid = checkAllIpAddressFieldsValidity();
        if (!valid)
            $(menuId).find('div#ok').addClass('disabled');
        else
            $(menuId).find('div#ok').removeClass('disabled');
    }

    return module;
})();