/*global $, _findElement*/
/*jslint browser: true*/

/**
 * 
 */
function Favorites() {
    this._status = false;
    this.I18nTexts = window.Gira.appLang.appI18nTexts;
}


Favorites.prototype.getStatus = function () {
    return this._status;
};

Favorites.prototype.setStatus = function (status) {
    this._status = status;
};

Favorites.prototype.loadStatusForSystemMenu = function () {
    this.setSystemMenuText();
};

/**
 * Sets the status, menu text and status bar icon according
 * to the current configuration mode
 * 
 */
Favorites.prototype.toogleConfigurationMode = function () {
    this.toggleStatus();
    this.setSystemMenuText();
    this.setStatusBarIcon();
};

/**
 * Sets the menu text according to the current favorites 
 * configuration status 
 */
Favorites.prototype.setSystemMenuText = function () {
    var parent = _findElement(new Array("favorites", "text"));

    if (this.getStatus()) {
        parent.text(this.I18nTexts.finishFavConfig);
    } else {
        parent.text(this.I18nTexts.favConfig);
    }
};

/**
 * Sets the disabled and onclick attribute of the system menu according 
 * to the current connection status 
 */
Favorites.prototype.setSystemMenuActive = function () {
    var fav = document.getElementById("favorites");
    var parent = _findElement(new Array("favorites", "text"));
    /* global variable for connect/reconnect functionality - see Connecting.js */
    if (homeServerClient.getConnectionState() !== connectionStates.CONNECTED) {
        if (fav !== null) {
            fav.setAttribute("disabled", "true");
            fav.setAttribute("onclick", "");
        }
        parent.removeClass("active").addClass("inactive");
    } else {
        if (fav !== null) {
            fav.removeAttribute("disabled");
            fav.setAttribute("onclick", "favorites.toogleConfigurationMode();");
        }
        parent.removeClass("inactive").addClass("active");
    }
};

/**
 * Sets the status bar icon visibility according to the current favorites 
 * configuration status 
 */
Favorites.prototype.setStatusBarIcon = function () {
    var parent = _findElement(new Array("statusbar", "favorite-icon"));
    if (this.getStatus())
        parent.css("visibility", "visible");
    else
        parent.css("visibility", "hidden");
};

/**
 * Toggels the favorites configuration status 
 */
Favorites.prototype.toggleStatus = function () {
    if(this.getStatus())
    {
		this.setStatus(false);
    }
    else
    {
		this.setStatus(true);   	   
    }
};