/*jslint browser: true, todo: true*/
/*global ko, $, observable, _*/

(function (vm) {
    'use strict';
    var Urns = window.Gira.DCS.Urns,
        makeEmptyButtonModel = function () {
            return {
                inactive: true,
                iconCss: 'dcs-button-empty dcs-button-normal',
                smallIconCss: '',
                label1: ko.observable(""),
                label2: ko.observable(""),
                touchStart: function () { return undefined; },
                touchEnd: function () { return undefined; },
                touchCancel: function () { return undefined; }
            };
        };

    function ButtonViewmodel(options) {
        var states = options.states,
            connection = options.connection,
            name = options.connection,
            currentIcon = _.find(_.keys(states), function (key) {
                return states[key].default;
            }),
            defaultState = states[currentIcon],
            self = this,
            messages = options.messages,
            urn = "",
            oldIcon = null,
            labelHandledIcon = null;

        self.iconCss = ko.observable(defaultState ? defaultState.icon : "dcs-button-empty dcs-button-normal");
        self.smallIconCss = ko.observable("");

        self.inactive = ko.observable('inactive');
        self.label1 = ko.observable(defaultState ? defaultState.label.line1 : "");
        self.label2 = ko.observable(defaultState ? defaultState.label.line2 : "");
        self.urn = urn;
        self.name = name;

        function isInactive() {
            return self.inactive() === 'inactive';
        }

        function setIcon(icon, oldIcon) {
            var state = states[icon];
            if (state) {
                self.iconCss(state.icon);
                self.smallIconCss(state.smallIcon);

                if (state.label.line1 !== '') {
                    self.label1(state.label.line1);
                    self.label2('');
                    labelHandledIcon = icon;
                }
                if (state.label.line2 !== '') {
                    self.label2(state.label.line2);
                }
                //case when new icon does not overwrite old text form previous state
                if (oldIcon !== icon && labelHandledIcon === oldIcon) {
                    self.label1('');
                    self.label2('');
                }
            } else {
                self.iconCss("dcs-button-empty dcs-button-normal");
            }
        }

        self.sendMessage = function (message) {
            // ignore the user if the button is inactive
            if (isInactive()) {
                return;
            }
            connection.sendMessage(message);
        };

        self.applyData = function (data) {
            if (!Urns.isForUrn(self.urn, data.urn)) {
                return;
            }
            if (Urns.isState(data.urn)) {
                if (data.value === '0') {
                    self.inactive('inactive');
                } else if (data.value === '1') {
                    self.inactive('');
                }
            } else if (Urns.isIcon(data.urn)) {
                setIcon(data.value, data.oldValue);
                currentIcon = data.value;
                oldIcon = data.oldValue;
            } else if (Urns.isLabel(data.urn)) {
                self.label1(data.value);
                self.label2('');
                labelHandledIcon = null;
                if (data.value === '') { // the state machine sends superfluous empty labels - we have to make sure
                    setIcon(currentIcon, oldIcon); // that we apply the labels according to the icon again
                }
            }
        };

        self.touchStart = function () {
            self.sendMessage(messages.pressed());
        };

        self.touchEnd = function () {
            self.sendMessage(messages.released());
        };

        self.touchCancel = function () {
            self.sendMessage(messages.canceled());
        };
    }

    ko.bindingHandlers.dcsButton = {
        init: function (element, valueAccessor) {
            var handler = valueAccessor(),
                touchStartHandler = handler.buttonPress,
                touchEndHandler = handler.buttonRelease,
                element$ = $(element),
                onButtonClicked = function (event) {
                    if (event.shiftKey) {
                        touchEndHandler();
                    } else {
                        touchStartHandler();
                    }
                };
            if (!(document.documentElement.hasOwnProperty("ontouchstart"))) {
                element$.on('click', function (e) {
                    onButtonClicked(e);
                });
            }
        }
    };

    vm.ButtonViewmodel = ButtonViewmodel;
    vm.ButtonViewmodel.makeEmptyModel = makeEmptyButtonModel;

}(window.Gira.DCS.Viewmodels));
//# sourceURL= dcs.viewmodels.buttonViewmodel.js