/*jslint browser: true*/
/*global ko, $, tsx*/

(function (ns) {
    "use strict";
    function DcsConnectionInfo(saveCallbackFunc, cancelCallbackFunc, triggerReconnectCallback, configuration) {
        var config = configuration,
            saveCallback = saveCallbackFunc,
            cancelCallback = cancelCallbackFunc,
            reconnectCallback = triggerReconnectCallback,
            /* the regex has been copied from the settingsmenu.xsl for consistency */
            IpRegex = /\b((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])\.){3}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])\b/,
            isNotEmpty = function (value) {
                return value !== undefined && value !== null && value !== "";
            },
            isValidIp = function (ip) {
                return isNotEmpty(ip) && IpRegex.exec(ip) !== null;
            },
            ipAddress = ko.observable(""),
            userName = ko.observable(""),
            password = ko.observable(""),
            isEnabled = ko.observable(true),
            model = {
                ipAddress: ipAddress,
                userName: userName,
                password: password,
                isIpValid: ko.computed(function () {
                    return isValidIp(ipAddress());
                }),
                isValid: ko.computed(function () {
                    return isValidIp(ipAddress()) && isNotEmpty(userName()) && isNotEmpty(password());
                }),
                isUsernameValid: ko.computed(function () {
                    return isNotEmpty(userName());
                }),
                isPasswordValid: ko.computed(function () {
                    return isNotEmpty(password());
                }),
                ipHint: ko.computed(function () {
                    return config.ipInvalidFormatMsg;
                }),
                usernameHint: ko.computed(function () {
                    return config.usernameEmptyMsg;
                }),
                passwordHint: ko.computed(function () {
                    return config.passwordEmptyMsg;
                })
            };

        return {
            model: model,

            init: function (configObj) {
                this.model.ipAddress(configObj.ip);
                this.model.userName(configObj.username);
                this.model.password(configObj.password);
            },
            ok: function () {
                reconnectCallback({ipAddress: ipAddress(), userName: userName(), password: password()});
                saveCallback([], true);
            },
            cancel: function () {
                cancelCallback();
            },
            getPersistedData: function () {
                return { ip: this.model.ipAddress(), username: this.model.userName(), password: this.model.password() };
            },
            isValid: model.isValid,
            isEnabled: isEnabled,
            label: config.label
        };
    }

    ns.DcsConnectionInfo = DcsConnectionInfo;
}(window.Gira.DCS));

//# sourceURL=dcs.settings.dcsConnectionInfo.js