/*jslint  browser: true*/
/*global navigator, $, index, console, _*/

(function (ns) {
    'use strict';
    var media = ns,
        Log = window.Gira.Log,
        vgaConstraints = { video : true},
        navigator,
        webkitUrl,
        localMediaStreamObj = null,
        objectUrl = null,
        videoStartedAction,
        streamRunning = function () {
            return (localMediaStreamObj !== null && !localMediaStreamObj.ended);
        },
        getActiveCameraNode = function () {
            return $('.videoCamera');
        },
        removeVideoStreamNodes = function (stopStream) {
            var activeVideoNodes = getActiveCameraNode();
            if (activeVideoNodes && activeVideoNodes.length > 0) {
                _.each(activeVideoNodes, function (videoNode) {
                    if (stopStream) {
                        videoNode.pause();
                        localMediaStreamObj.stop();
                    }
                    videoNode.src = "";
                    videoNode.remove();
                });
            }
        },
        appendVideoTagWithSource = function () {
            var videoStream = $("<video autoplay loop class='videoCamera dcs-videostream'></video>"),
                activeVideoParent = $('.swiper-slide-active').find('.tks-display-video-stream');
            //show stream on client only when stream is loaded
            videoStream[0].onloadedmetadata = function () {
                if (streamRunning() && (typeof videoStartedAction === "function")) {
                    videoStartedAction();
                }
            };
            videoStream.attr('src', objectUrl);
            activeVideoParent.append(videoStream);
        },
        startVideo = function (localMediaStream) {
            localMediaStreamObj = localMediaStream;
            objectUrl = webkitUrl.createObjectURL(localMediaStream);
            removeVideoStreamNodes();
            appendVideoTagWithSource();
        },
        getLocalMediaStream = function () {
            navigator.webkitGetUserMedia(vgaConstraints, startVideo, function (e) {
                Log.error('error while opening user media:' + JSON.stringify(e));
            });
        };

    media.init = function (theNavigator, theWebkitUrl) {
        navigator = theNavigator;
        webkitUrl = theWebkitUrl;
        media.Video = {
            startVideoStream: function (showRunningStream) {
                if (showRunningStream && streamRunning()) {
                    appendVideoTagWithSource();
                } else {
                    localMediaStreamObj = null;
                    getLocalMediaStream();
                }
            },
            stopVideoStream: function () {
                removeVideoStreamNodes(true);
            },
            onVideoStartedAction : function (fnct) {
                videoStartedAction = fnct;
            }
        };
    };
}(window.Gira.DCS.Mediastream));
//# sourceURL=dcs.mediastream.js
