/*jslint browser: true*/
/*global console, Gira*/
(function (ns) {
    'use strict';
    var log = window.Gira.Log,
        Messages = window.Gira.DCS.Messages,
        toCanonical = Messages.toCanonical;

    // Listener for receiving messages from proxy.
    // Concrete instance of listener must to be registered with "registerListener" function.
    function DcsToGdsConnectionListener(viewModel) {
        var self = this;

        self.onOpen = function () {
            if (viewModel.onOpen) {
                viewModel.onOpen();
            }
        };

        self.onClose = function () {
            log.info("CLOSE CONNECTION");
            if (viewModel.onClose) {
                viewModel.onClose();
            }
        };

        self.onError = function () {
            return undefined;
        };

        self.onMessage = function (obj) {
            viewModel.applyData(toCanonical(obj));
        };
    }

    ns.DcsToGdsConnectionListener = DcsToGdsConnectionListener;

}(window.Gira.DCS));