/*jslint browser: true*/
(function (ns) {
    "use strict";
    var errorHandler,
        DCS = window.Gira.DCS,
        Urns = DCS.Urns,
        Globals = DCS.Globals,
        Messages = DCS.Messages,
        config,
        getMessageFromState = function (state) {
            switch (state) {
            case "3":
                return config.wrongCredentialsMsg;
            case "4":
                return config.timeoutMsg;
            case "5":
                return config.licenseNumberExceededMsg;
            case "6":
                return config.internalErrorMsg;
            default:
                return undefined;
            }
        },
        canCleanConnectionError = function (connState) {
            switch (connState) {
            case "3": // registered ( dcs ip gateway successfully registered )
                return true;
            default:
                return false;
            }
        },
        clearErrors = function () {
            errorHandler.CloseError(Globals.ApplicationName);
        },
        setError = function (message) {
            errorHandler.OpenError(Globals.ApplicationName, message);
        };
    ns.ConnectionState = {
        applyData: function (data) {
            var message;
            if (data.urn === "") {
                return;
            }
            if (Urns.isForUrn(data.urn, Urns.disconnectReason)) {
                message = getMessageFromState(data.value);
                if (message) {
                    setError(message);
                }
                return;
            }
            if (Urns.isForUrn(data.urn, Urns.connectionState)) {
                if (data.value === "5") {
                    setError(config.connectionLostErrorMsg);
                }
                if (canCleanConnectionError(data.value)) {
                    clearErrors();
                }
            }
        },
        init: function (globalErrorHandler, configuration) {
            errorHandler = globalErrorHandler;
            config = configuration;
        },
        onConnected: function (connection) {
            connection.sendMessage(Messages.getValue(Urns.disconnectReason));
            connection.sendMessage(Messages.getValue(Urns.connectionState));
        }
    };
}(window.Gira.DCS));
//# sourceURL=dcs.connectionState.js