﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:import href="../xsltemplates.xsl"/>
  <xsl:import href="tile_structure.xsl"/>
  <xsl:output indent="yes" />
  <xsl:output method="html"/>
    
  <xsl:template match="/">
    <!-- set tileId variable -->
    <xsl:variable name="tileId">
      <xsl:call-template name="tileId"/>
    </xsl:variable>
    <div class="tile tile-small">
      <xsl:attribute name="id">
        <xsl:copy-of select="$tileId" />
      </xsl:attribute>
      <xsl:choose>
        <xsl:when test="Channel/@TypeURN = 'de.gira.schema.channels.BlindAbsolute'">
          <xsl:attribute name="data-position-id">
            <xsl:value-of select="Channel/DataPoints/DataPoint[@TypeURN='de.gira.schema.datapoints.Percent' and @Name='HeightPosition']/@Id" />
          </xsl:attribute>
          <xsl:attribute name="data-position-state-id">
            <xsl:value-of select="Channel/DataPoints/DataPoint[@TypeURN='de.gira.schema.datapoints.Percent' and @Name='HeightPositionState']/@Id" />
          </xsl:attribute>
          <xsl:attribute name="data-movement-id">
            <xsl:value-of select="Channel/DataPoints/DataPoint[@TypeURN='de.gira.schema.datapoints.Movement']/@Id" />
          </xsl:attribute>
        </xsl:when>
        <xsl:when test="Channel/@TypeURN = 'de.gira.schema.channels.ShutterAbsolute'">
          <xsl:attribute name="data-position-id">
            <xsl:value-of select="Channel/DataPoints/DataPoint[@TypeURN='de.gira.schema.datapoints.Percent' and @Name='Position']/@Id" />
          </xsl:attribute>
          <xsl:attribute name="data-position-state-id">
            <xsl:value-of select="Channel/DataPoints/DataPoint[@TypeURN='de.gira.schema.datapoints.Percent' and @Name='PositionState']/@Id" />
          </xsl:attribute>
          <xsl:attribute name="data-movement-id">
            <xsl:value-of select="Channel/DataPoints/DataPoint[@TypeURN='de.gira.schema.datapoints.Movement']/@Id" />
          </xsl:attribute>
        </xsl:when>
      </xsl:choose>
      <xsl:attribute name="data-step-size">
        <xsl:value-of select="Channel/UpdateOnChange/@Value"/>
      </xsl:attribute>
      <xsl:attribute name="data-stop-id">
        <xsl:value-of select="Channel/DataPoints/DataPoint[@TypeURN='de.gira.schema.datapoints.StepUpDown' and @Name='Stop']/@Id" />
      </xsl:attribute>
      <xsl:attribute name="data-channel-index">
        <xsl:value-of select="Channel/@Index"/>
      </xsl:attribute>
      <xsl:attribute name="data-container-index">
        <xsl:value-of select="Channel/@ContainerIndex"/>
      </xsl:attribute>
      <xsl:attribute name="data-status-feedback">
        <xsl:value-of select="Channel/StatusFeedback/@Enable"/>
      </xsl:attribute>      

      <!-- generate tile structure-->
      <xsl:call-template name="tileContent">
        <xsl:with-param name="statusText">
          <xsl:if test="Channel/StatusValueHeightPosition/@Enable = 'true' or Channel/StatusValuePosition/@Enable = 'true'">
            <div class="tile-status-text t2gg">- %</div>
          </xsl:if>
        </xsl:with-param>
        <xsl:with-param name="controlElements">
          <xsl:call-template name="tileUpDownButtons">
            <xsl:with-param name="Index" select="Channel/@Index" />
          </xsl:call-template>
        </xsl:with-param>
        <xsl:with-param name="tileHeader"></xsl:with-param>
      </xsl:call-template>
      <script type="text/javascript">
        (function(){
        var tileId = '<xsl:value-of select="$tileId"/>';
        var dataset = document.getElementById(tileId).dataset;
        var suffix =  '-' + dataset.containerIndex + '-' + dataset.channelIndex;
        var arrowDownId = 'arrowdown' + suffix;
        var arrowUpId = 'arrowup' + suffix;
        var statusFeedback = dataset.statusFeedback;
        var step = parseInt(dataset.stepSize);

        eventsOnTile(tileId);
        $('#'+tileId).data(tileId, new BlindAbsoluteTile(tileId, arrowDownId, arrowUpId, dataset.positionId, dataset.positionStateId, dataset.movementId, dataset.stopId, step, statusFeedback));

        <!-- ######################### set tile click action ######################### -->
        $('#' + tileId).on('tileAction',function(){
        NavbarController.getInstance().openDetailElement(this);
        });
        })();
      </script>
    </div>
  </xsl:template>
</xsl:stylesheet>
