<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output indent="yes" />
  <xsl:output method="html"/>
  <xsl:template match="/">


    #switch {
    position: relative;
    width: 444px;
    height: 470px;
    z-index: 1;
    background: #F5F5F5;
    }

    .switch-container {
    position: absolute;
    left: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-switch-container']/left" />px;
    top: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-switch-container']/top" />px;
    z-index: 1;
    }

    .switch-container .switch-button {
    position: absolute;
    left: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-switch-button']/left" />px;
    top: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-switch-button']/top" />px;
    z-index: 3;
    }

    .switch-container .switch-button-vertical {
    position: absolute;
    width: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-switch-button']/width" />px;
    left: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-switch-button']/left" />px;
    top: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-switch-button']/top" />px;
    z-index: 3;
    }

    .switch-container .switch-button-top {
    border-top-left-radius: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-switch-button-top']/left-radius" />px;
    border-top-right-radius: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-switch-button-top']/right-radius" />px;
    z-index: 3;
    }

    .switch-container .switch-button-bottom {
    border-bottom-left-radius: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-switch-button-bottom']/left-radius" />px;
    border-bottom-right-radius: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-switch-button-bottom']/right-radius" />px;
    z-index: 3;
    }

    .switch-container .switch-button-left {
    border-top-left-radius: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-switch-button-bottom']/left-radius" />px;
	  border-bottom-left-radius: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-switch-button-bottom']/left-radius" />px;
    z-index: 3;
    }

    .switch-container .switch-button-right {   
	  border-top-right-radius: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-switch-button-bottom']/right-radius" />px;
	  border-bottom-right-radius: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-switch-button-bottom']/right-radius" />px;
    z-index: 3;
    }

    .switch-container .shadow {
    -webkit-filter: drop-shadow(0px 2px 2px rgba(0,0,0, 0.2));
    }

    .switch-container .switch-ring {
    pointer-events: none;
    position: absolute;
    z-index: 2;
    }

    .switch-container .switch-ring.ring2 {
    opacity: 0;
    }

    .switch-container .switch-text-on {
    width: <xsl:value-of select="/metrics/slider/metric[@key = 'label.button-on']/width" />px;
    height: <xsl:value-of select="/metrics/slider/metric[@key = 'label.button-on']/height" />px;
    top: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-switch-text-on']/top" />px;
    left: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-switch-text-on']/left" />px;
    position: absolute;
    display: block;
    z-index: 5;
    }

    .switch-container .switch-text-off {
    width: <xsl:value-of select="/metrics/slider/metric[@key = 'label.button-off']/width" />px;
    height: <xsl:value-of select="/metrics/slider/metric[@key = 'label.button-off']/height" />px;
    top: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-switch-text-off']/top" />px;
    left: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-switch-text-off']/left" />px;
    position: absolute;
    display: block;
    z-index: 5;
    }

    .switch-container .switch-text-down {
    width: <xsl:value-of select="/metrics/detail/metric[@key = 'switch-2v-arrow']/width" />px;
    height: <xsl:value-of select="/metrics/detail/metric[@key = 'switch-2v-arrow']/height" />px;
    top: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-switch-text-down']/top" />px;
    left: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-switch-text-down']/left" />px;
    position: absolute;
    display: block;
    z-index: 5;
    }

    .switch-container .switch-text-up {
    width: <xsl:value-of select="/metrics/detail/metric[@key = 'switch-2v-arrow']/width" />px;
    height: <xsl:value-of select="/metrics/detail/metric[@key = 'switch-2v-arrow']/height" />px;
    top: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-switch-text-up']/top" />px;
    left: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-switch-text-up']/left" />px;
    position: absolute;
    display: block;
    z-index: 5;
    }

  </xsl:template>
</xsl:stylesheet>