﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:import href="xsltemplates.xsl"/>
  <xsl:output indent="yes" />
  <xsl:output method="html"/>
  <xsl:template match="/">
    <div id="rtc-modes-coverflip" class="coverflip-side back">
      <div id="rtc-modes">
        <xsl:variable name="extensionMode">
          <xsl:choose>
            <xsl:when test="Channel/ExtensionMode/@Enable">
              <xsl:value-of select="Channel/ExtensionMode/@Enable" />
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="'true'" />
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        
        <xsl:attribute name="data-step-size">
          <xsl:value-of select="Channel/SetPointTemperatureShift/@StepWide"/>
        </xsl:attribute>
        <div class="header">
          <div class="t3sg switch_mode">{{rtcModesSwitchMode}}</div>
          <xsl:if test="Channel/SetPointTemperatureChange/@Enable='true' and $extensionMode!='true'">
            <div class="t3sg edit_mode" style="display: none;">{{rtcModesEditMode}}</div>
          </xsl:if>
        </div>
        <div class="buttons">
          <xsl:if test="Channel/SetPointTemperatureChange/@Enable='true' and $extensionMode!='true'">
            <div class="btn btnEdit cssButton158 left">{{rtcModesButtonEdit}}</div>
            <div class="btn btnOk cssButton158 right" style="display: none;">{{rtcModesButtonOk}}</div>
          </xsl:if>
          <div data-dismiss="modes" class="btn btnEnd right cssButton158">{{rtcModesButtonEnd}}</div>
        </div>
        <div class="white-timer-divider"></div>
        <ul>
          <xsl:call-template name="rtc_mode">
            <xsl:with-param name="rtcModeId">rtr-comfort</xsl:with-param>
            <xsl:with-param name="rtcModeIcon">gc4_icon_comfort_list</xsl:with-param>
            <xsl:with-param name="rtcModeLabel">{{rtcModesModeLabelComfort}}</xsl:with-param>
            <xsl:with-param name="extensionMode" select="$extensionMode" />
          </xsl:call-template>
          <xsl:call-template name="rtc_mode">
            <xsl:with-param name="rtcModeId">rtr-standby</xsl:with-param>
            <xsl:with-param name="rtcModeIcon">gc4_icon_standby_list</xsl:with-param>
            <xsl:with-param name="rtcModeLabel">{{rtcModesModeLabelStandby}}</xsl:with-param>
            <xsl:with-param name="extensionMode" select="$extensionMode" />
          </xsl:call-template>
          <xsl:call-template name="rtc_mode">
            <xsl:with-param name="rtcModeId">rtr-economy</xsl:with-param>
            <xsl:with-param name="rtcModeIcon">gc4_icon_night_list</xsl:with-param>
            <xsl:with-param name="rtcModeLabel">{{rtcModesModeLabelNight}}</xsl:with-param>
            <xsl:with-param name="extensionMode" select="$extensionMode" />
          </xsl:call-template>
          <xsl:call-template name="rtc_mode">
            <xsl:with-param name="rtcModeId">rtr-thermalprotection</xsl:with-param>
            <xsl:with-param name="rtcModeIcon">gc4_icon_frost_list</xsl:with-param>
            <xsl:with-param name="rtcModeLabel">{{rtcModesModeLabelFrost}}</xsl:with-param>
            <xsl:with-param name="extensionMode" select="$extensionMode" />
          </xsl:call-template>
        </ul>
      </div>
      <xsl:if test="Channel/SetPointTemperatureChange/@Enable='true'">
        <div id="rtc-mode-edit-view">
          <div class="header">
            <div class="t3sg">
              {{rtcModesEditViewEditModes}}<xsl:text disable-output-escaping="yes"><![CDATA[&nbsp;]]></xsl:text>
            </div>
            <xsl:if test="Channel/SetPointTemperatureChange/@ChangeComfortSetpointTemperature='true'">
              <div id="rtr-comfort-edit" class="t3lsg" style="display: none;">{{rtcModesEditViewComfort}}</div>
            </xsl:if>
            <xsl:if test="Channel/SetPointTemperatureChange/@ChangeStandbySetpointTemperature='true'">
              <div id="rtr-standby-edit" class="t3lsg" style="display: none;">{{rtcModesEditViewStandby}}</div>
            </xsl:if>
            <xsl:if test="Channel/SetPointTemperatureChange/@ChangeEconomySetpointTemperature='true'">
              <div id="rtr-economy-edit" class="t3lsg" style="display: none;">{{rtcModesEditViewNight}}</div>
            </xsl:if>
          </div>
          <div class="buttons">
            <div class="btn btnEditCancel cssButton158 left">{{rtcModesEditViewButtonEditCancel}}</div>
            <div class="btn btnEditSave cssButton158 right">{{rtcModesEditViewButtonEditSave}}</div>
          </div>
          <div class="white-timer-divider"></div>
          <div class="white-timer-divider"></div>
          <div class="rtcModeEdit">
            <div class="swiper-wrapper noSwipingH">
              <div class="swiper-slide">
                <xsl:if test="Channel/ControllerMode/@Mode='HeatingAndCooling' or Channel/ControllerMode/@Mode='Heating'">
                  <xsl:call-template name="rtc_mode_edit_temperarure">
                    <xsl:with-param name="hotCold">{{rtcModesEditViewModeEditHot}}</xsl:with-param>
                    <xsl:with-param name="icon">gc4_icon_heating_list</xsl:with-param>
                    <xsl:with-param name="label">{{rtcModesEditViewModeEditLabelHot}}</xsl:with-param>
                  </xsl:call-template>
                </xsl:if>
                <xsl:if test="Channel/ControllerMode/@Mode='HeatingAndCooling'">
                  <div class="rtc-temp-double-line"></div>
                </xsl:if>
                <xsl:if test="Channel/ControllerMode/@Mode='HeatingAndCooling' or Channel/ControllerMode/@Mode='Cooling'">
                  <xsl:call-template name="rtc_mode_edit_temperarure">
                    <xsl:with-param name="hotCold">{{rtcModesEditViewModeEditCold}}</xsl:with-param>
                    <xsl:with-param name="icon">gc4_icon_cooling_list</xsl:with-param>
                    <xsl:with-param name="label">{{rtcModesEditViewModeEditLabelCold}}</xsl:with-param>
                  </xsl:call-template>
                </xsl:if>
                <div class="blindpuffer"></div>
              </div>
            </div>
          </div>
          <div class="rtc-edit-scrollbar"></div>
        </div>
        <script type="text/javascript">
          createMenuSwiperV("#rtc-mode-edit-view .rtcModeEdit", "#rtc-mode-edit-view .rtc-edit-scrollbar", "#rtc-mode-edit-view",'.rtcModeEdit .edit-row');
        </script>
      </xsl:if>
    </div>
  </xsl:template>
</xsl:stylesheet>