﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:template match="/">
    #popup {
    width: <xsl:value-of select="/metrics/popup/metric[@key = 'popup']/width" />px;
    height: <xsl:value-of select="/metrics/popup/metric[@key = 'popup']/height" />px;
    top: <xsl:value-of select="/metrics/popup/metric[@key = 'popup']/top" />px;
    left: <xsl:value-of select="/metrics/popup/metric[@key = 'popup']/left" />px;
    position: absolute;
    z-index: 99999;
    }

    @-webkit-keyframes popupbackgroundfadeinout {
    0%   { opacity: 0; }
    25%  { opacity: 0.125; }
    50%  { opacity: 0.25; }
    75%  { opacity: 0.375; }
    100% { opacity: 0.5; }
    }
    @-moz-keyframes popupbackgroundfadeinout {
    0%   { opacity: 0; }
    25%  { opacity: 0.125; }
    50%  { opacity: 0.25; }
    75%  { opacity: 0.375; }
    100% { opacity: 0.5; }
    }
    @-o-keyframes popupbackgroundfadeinout {
    0%   { opacity: 0; }
    25%  { opacity: 0.125; }
    50%  { opacity: 0.25; }
    75%  { opacity: 0.375; }
    100% { opacity: 0.5; }
    }
    @keyframes popupbackgroundfadeinout {
    0%   { opacity: 0; }
    25%  { opacity: 0.125; }
    50%  { opacity: 0.25; }
    75%  { opacity: 0.375; }
    100% { opacity: 0.5; }
    }

    #popup .popup-background.animation{
    background-color:#000000;
    width: <xsl:value-of select="/metrics/popup/metric[@key = 'popup']/width" />px;
    height: <xsl:value-of select="/metrics/popup/metric[@key = 'popup']/height" />px;
    opacity: 0.5;
    -webkit-animation-name: popupbackgroundfadeinout;
    -webkit-animation-duration: 1s;
    -webkit-animation-timing-function: ease;
    }
    #popup .popup-background.animation-reverse{
    background-color:#000000;
    width: <xsl:value-of select="/metrics/popup/metric[@key = 'popup']/width" />px;
    height: <xsl:value-of select="/metrics/popup/metric[@key = 'popup']/height" />px;
    opacity: 0;
    -webkit-transition:opacity 1000ms ease-out;
    -moz-transition:opacity 1000ms ease-out;
    -o-transition:opacity 1000ms ease-out;
    transition:opacity 1000ms ease-out;
    }

    #popup .popup-foreground {
    background-color:#FFFFFF;
    width: <xsl:value-of select="/metrics/popup/metric[@key = 'popup-foreground']/width" />px;
    height: <xsl:value-of select="/metrics/popup/metric[@key = 'popup-foreground']/height" />px;
    bottom: <xsl:value-of select="/metrics/popup/metric[@key = 'popup-foreground']/bottom" />px;
    position: absolute;
    }

    #popup .popup-foreground .shadow {
    width: <xsl:value-of select="/metrics/popup/metric[@key = 'popup-shadow']/width" />px;
    height: <xsl:value-of select="/metrics/popup/metric[@key = 'popup-shadow']/height" />px;
    margin-top: <xsl:value-of select="/metrics/popup/metric[@key = 'popup-shadow']/margin-top" />px;
    background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,rgba(255,255,255,0)), color-stop(75%,rgba(60,60,60,0.35)));
    }

    #popup .popup-foreground .buttons {
    border-bottom: 1px solid #c8c8c8;
    width: <xsl:value-of select="/metrics/popup/metric[@key = 'popup-devider']/width" />px;
    height: <xsl:value-of select="/metrics/popup/metric[@key = 'popup-devider']/height" />px;
    }

    #popup .popup-foreground .buttons .right {
    left: <xsl:value-of select="/metrics/popup/metric[@key = 'popup-buttons-right']/left" />px;
    }

    #popup .popup-foreground .message-box {
    margin-left: <xsl:value-of select="/metrics/popup/metric[@key = 'popup-message-box']/margin-left" />px;
    margin-right: <xsl:value-of select="/metrics/popup/metric[@key = 'popup-message-box']/margin-right" />px;
    height: <xsl:value-of select="/metrics/popup/metric[@key = 'popup-message-box']/height" />px;
    }

    #popup .popup-foreground .message-box .message {
    display: block !important;
    }

    #popup .popup-foreground .message-box .message .text {
    float: left;
    line-height: <xsl:value-of select="/metrics/popup/metric[@key = 'popup-message-box-text']/line-height" />px;
    width: <xsl:value-of select="/metrics/popup/metric[@key = 'popup-message-box-text']/width" />px;
    margin-top: <xsl:value-of select="/metrics/popup/metric[@key = 'popup-message-box-text']/margin-top" />px;
    margin-bottom: <xsl:value-of select="/metrics/popup/metric[@key = 'popup-message-box-text']/margin-bottom" />px;
    overflow: hidden;
    }

    #popup .popup-foreground .message-box .message .icon {
    float: left;
    width: <xsl:value-of select="/metrics/popup/metric[@key = 'popup-message-box-icon']/width" />px;
    height: <xsl:value-of select="/metrics/popup/metric[@key = 'popup-message-box-icon']/height" />px;
    margin-top: <xsl:value-of select="/metrics/popup/metric[@key = 'popup-message-box-icon']/margin-top" />px;
    margin-left: <xsl:value-of select="/metrics/popup/metric[@key = 'popup-message-box-icon']/margin-left" />px;
    }

    #popup .popup-foreground .message-box .message .radio{
    }

    #popup .popup-foreground .message-box .float-breaker {
    clear: left;
    }

    #popup .popup-foreground .message-box .popup-double-line {
    height: <xsl:value-of select="/metrics/popup/metric[@key = 'popup-double-line']/height" />px;
    background: url(../img/4x2_repeating_gc4_grid_line.png) repeat-x top;
    display: flex;
    width: <xsl:value-of select="/metrics/popup/metric[@key = 'popup-double-line']/width" />px;
    }

    #popup .popup-foreground .popup-scrollbar {
    position: absolute;
    top: <xsl:value-of select="/metrics/popup/metric[@key = 'popup-scrollbar']/top" />px;
    height: <xsl:value-of select="/metrics/popup/metric[@key = 'popup-scrollbar']/height" />px;
    width: <xsl:value-of select="/metrics/popup/metric[@key = 'popup-scrollbar']/width" />px;
    right: <xsl:value-of select="/metrics/popup/metric[@key = 'popup-scrollbar']/right" />px;
    -ms-touch-action: none;
    background-color: #FFFFFF;
    display: block !important;
  }

  #popup::-webkit-scrollbar {
  width: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view.scrollbar']/width" />px;
    -webkit-appearance: none;
    }

    #popup::-webkit-scrollbar-track {

    }

    #popup::-webkit-scrollbar-thumb {
    background: #C2C2C2;
    height: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view.scrollbar.thumb']/height" />px;
    }

    #popup::-webkit-scrollbar-thumb:window-inactive {
    background: #C2C2C2;
    }

    #popup .popup-foreground .popup-swiper-container {
    width: <xsl:value-of select="/metrics/popup/metric[@key = 'popup-scrollcontainer']/width" />px;
    height: <xsl:value-of select="/metrics/popup/metric[@key = 'popup-scrollcontainer']/height" />px;
    overflow: hidden;
    }
  </xsl:template>
</xsl:stylesheet>
