<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:output indent="yes" />
    <xsl:output method="html"/>
    <xsl:template match="/">
        
.onoffswitch {
    position: relative;
    width: <xsl:value-of select="/metrics/slider/metric[@key = 'slider']/width + 2 * /metrics/slider/metric[@key = 'slider']/clickSensitivity"/>px;
    -webkit-user-select:none; -moz-user-select:none; -ms-user-select: none;
}
.onoffswitch-mask {
    position: absolute;
    width: <xsl:value-of select="/metrics/slider/metric[@key = 'slider']/width"/>px;
    height: <xsl:value-of select="/metrics/slider/metric[@key = 'slider']/height"/>px;
    margin: <xsl:value-of select="/metrics/slider/metric[@key = 'slider']/clickSensitivity"/>px;    
    z-index: <xsl:value-of select="/metrics/slider/metric[@key = 'slider']/z-index"/>;
    border-radius: <xsl:value-of select="/metrics/slider/metric[@key = 'slider']/height"/>px;
    box-shadow: 0px 1px 0px rgb(255,255,255), inset 0px 1px 0px rgba(0,0,0,0.35);
    top: 0;
    left: 0;
}
.onoffswitch-mask-down {
    box-shadow: none !important;
}
.onoffswitch-mask, .onoffswitch-switch, .onoffswitch-switch-down {
    -webkit-touch-callout: none;
    -webkit-user-select: none;
    -webkit-user-drag: none;
    -khtml-user-select: none;
    -moz-user-select: none;
    -ms-user-select: none;
    user-select: none;
    pointer-events: none;
}

.onoffswitch-checkbox {
    display: none;
}

.onoffswitch-checkbox:checked + .onoffswitch-label .onoffswitch-inner {
    margin-left: <xsl:value-of select="/metrics/slider/metric[@key = 'slider']/margin-left"/>;
    }

    .onoffswitch-checkbox:checked + .onoffswitch-label .onoffswitch-switch {
    right: <xsl:value-of select="/metrics/slider/metric[@key = 'slider']/clickSensitivity - /metrics/slider/metric[@key = 'slider.button']/buttonOverlap"/>px;
}

.onoffswitch-checkbox:checked + .onoffswitch-label .onoffswitch-switch-down {
    right: <xsl:value-of select="/metrics/slider/metric[@key = 'slider']/clickSensitivity - /metrics/slider/metric[@key = 'slider.button']/buttonOverlap"/>px;
}

.onoffswitch-label {
    display: block;
    cursor: pointer;
    border-radius: <xsl:value-of select="/metrics/slider/metric[@key = 'slider']/height + 2 * /metrics/slider/metric[@key = 'slider']/clickSensitivity"/>px;
    padding: <xsl:value-of select="/metrics/slider/metric[@key = 'slider']/clickSensitivity"/>px;
    width: <xsl:value-of select="/metrics/slider/metric[@key = 'slider']/width"/>px;
    height: <xsl:value-of select="/metrics/slider/metric[@key = 'slider']/height"/>px;
    position: relative;
    pointer-events: none;
}

.onoffswitch-inner-wrapper {
    width: <xsl:value-of select="/metrics/slider/metric[@key = 'slider']/width"/>px;
    height: <xsl:value-of select="/metrics/slider/metric[@key = 'slider.button']/height"/>px;
    overflow: hidden;
    border-radius: <xsl:value-of select="/metrics/slider/metric[@key = 'slider']/height"/>px;
    z-index: <xsl:value-of select="/metrics/slider/metric[@key = 'slider']/z-index"/>;
    position: relative;
    }

    .onoffswitch-inner {
    width: <xsl:value-of select="/metrics/slider/metric[@key = 'slider.background']/width"/>px;
    height:<xsl:value-of select="/metrics/slider/metric[@key = 'slider.background']/height"/>px; 
    margin-left: -<xsl:value-of select="/metrics/slider/metric[@key = 'slider']/height"/>px;
    -moz-transition: margin 0.3s ease-in 0s; -webkit-transition: margin 0.3s ease-in 0s;
    -o-transition: margin 0.3s ease-in 0s; transition: margin 0.3s ease-in 0s;
    z-index: <xsl:value-of select="/metrics/slider/metric[@key = 'slider']/z-index"/>;
}

.onoffswitch.transitions-disabled .onoffswitch-inner{
		-webkit-transition-duration: 0s !important;
}


.onoffswitch-inner:before, .onoffswitch-inner:after {
    z-index: <xsl:value-of select="/metrics/slider/metric[@key = 'slider']/z-index"/>;;
}

.onoffswitch-inner:before {
}

.onoffswitch-inner:after {
}

.slider-background-left, .slider-background-right{
    width:<xsl:value-of select="/metrics/slider/metric[@key = 'slider.background']/elementWidth"/>px;
    height:<xsl:value-of select="/metrics/slider/metric[@key = 'slider.background']/height"/>px;
    float:left;
    overflow: visible;
    position: relative;
}

.slider-background-left{
    border-right-style:solid;
    border-right-width:<xsl:value-of select="/metrics/slider/metric[@key = 'slider.background']/dividerWidth"/>px;
    border-color:white;
}

.onoffswitch-inner-bg{
    position: relative;
    -webkit-filter: drop-shadow(0px 0px 1px rgba(0,0,0, 0.5));
    text-color: white;
}

.slider-on-icon {
    width: <xsl:value-of select="/metrics/slider/metric[@key = 'slider.icon.on']/width"/>px;
    height: <xsl:value-of select="/metrics/slider/metric[@key = 'slider.icon.on']/height"/>px;
    background-color: rgb(255,255,255);
    position: absolute;
    top: <xsl:value-of select="/metrics/slider/metric[@key = 'slider.icon.on']/top"/>px;
    left: <xsl:value-of select="/metrics/slider/metric[@key = 'slider.icon.on']/left"/>px;
}


.slider-off-icon {
    width: <xsl:value-of select="/metrics/slider/metric[@key = 'slider.icon.off']/width"/>px;
    height: <xsl:value-of select="/metrics/slider/metric[@key = 'slider.icon.off']/height"/>px;
    background: transparent;
    border: <xsl:value-of select="/metrics/slider/metric[@key = 'slider.icon.off']/border"/>px solid #fff;
    border-radius: <xsl:value-of select="/metrics/slider/metric[@key = 'slider.icon.off']/radius"/>px;
    position: absolute;
    top: <xsl:value-of select="/metrics/slider/metric[@key = 'slider.icon.off']/top"/>px;
    right: <xsl:value-of select="/metrics/slider/metric[@key = 'slider.icon.off']/right"/>px;
    -webkit-box-shadow: 0px -1px 0px rgba(0,0,0,0.35), inset 0px -0.5px 0px rgba(0,0,0,0.35) !important; 
}


.slider-background-right{
    text-align: right;
}

.onoffswitch-switch {    
    top: <xsl:value-of select="/metrics/slider/metric[@key = 'slider']/clickSensitivity"/>px; 
    right: <xsl:value-of select="/metrics/slider/metric[@key = 'slider']/width - /metrics/slider/metric[@key = 'slider.button']/width + /metrics/slider/metric[@key = 'slider']/clickSensitivity + /metrics/slider/metric[@key = 'slider.button']/buttonOverlap"/>px;
      -moz-transition: right 0.3s ease-in 0s; -webkit-transition: right 0.3s ease-in 0s;
      -o-transition: right 0.3s ease-in 0s; transition: right 0.3s ease-in 0s;
      }

      .onoffswitch.transitions-disabled .onoffswitch-switch{
      -webkit-transition-duration: 0s !important;
      }

      .onoffswitch-icon-shadow-1 {
      /* == Chromium 37 */
      -webkit-box-shadow: 0px 0px 1px rgba(0,0,0,0.5);
      /* > Chromium 37 -webkit-filter: drop-shadow(0px 0px 1px rgba(0,0,0, 0.5));*/
      }

      .onoffswitch-icon-shadow-0 {
      /* == Chromium 37 */
      -webkit-box-shadow: 0px -1px 0px rgba(0,0,0,0.35);
      /* > Chromium 37 -webkit-filter: drop-shadow(0px -1px 0px rgba(0,0,0,0.35));*/
      }

      .onoffswitch .toggleslider-inactiveoverlay{
      width: 100%;
      height: 100%;
      top: 0;
      background-color:rgb(245,245,245);
      opacity: 0;
      -webkit-transition: opacity 300ms ease-in-out;
      -moz-transition: opacity 300ms ease-in-out;
      -o-transition: opacity 300ms ease-in-out;
      transition: opacity 300ms ease-in-out;
      position: absolute;
      pointer-events: none;
      z-index: 1000;
      }

      .onoffswitch.inactive .toggleslider-inactiveoverlay{
      opacity: 0.75 !important;
      pointer-events: auto;
      }

    </xsl:template>
</xsl:stylesheet>