/*global ko, $*/
/*jslint browser: true*/
(function () {
    "use strict";
    window.WizardTranslate = function Translate() {
        var language = ko.observable(),
            texts = {},
            i18n = function i18n(key) {
                return ko.computed(function () {
                    if (language() !== undefined) {
                        return texts[key];
                    }
                    return "";
                }, key);
            },
            loadLanguage = function loadLanguage(lang, callback) {
                $.ajax({
                    url: "lang/" + lang + "/firstInstalationWizard.json",
                    cache: false,
                    async: false
                }).success(function (data) {
                    texts = JSON.parse(data);
                    language(lang);
                    if (callback) {
                        callback();
                    }
                }).error(function () {
                    if (callback) {
                        callback();
                    }
                });
            },
            init = function init(lang, callback) {
                loadLanguage(lang, callback);
            },
            changeLanguage = function changeLanguage(lang, callback) {
                loadLanguage(lang, callback);
            };

        return {
            init: init,
            language: language,
            i18n: i18n,
            changeLanguage: changeLanguage
        };
    };
}());
