/*jslint browser: true*/
/*global console, Gira, toGMTString*/

(function (ns) {
    'use strict';

    if (ns.Log !== undefined) {
        return;
    }

    var enabled = true,
        Destination = {
            Console: 0,
            GdsApi: 1
        },
        Level = {
            Off: 0,
            InternalError: 1,
            Error: 2,
            Warning: 3,
            Info: 4,
            Verbose: 5
        },
        logLevel = Level.Error,
        logDestination = Destination.GdsApi,
        gdsConnection = null,
        logLevelText = ["OFF", "INTERNALERROR", "ERROR", "WARNING", "INFO", "VERBOSE" ],
        gdsLogLevel = ["", "error", "error", "warn", "info", "verbose" ];
    function getLogLevelTextFromEnum(level) {
        return logLevelText[level];
    }
    function getGdsLogLevelFromEnum(level) {
        return gdsLogLevel[level];
    }
    function logToConsole(level, message) {
        console.log("[" + (new Date()).toGMTString() + " - " + getLogLevelTextFromEnum(level) + "]: " +  message);
    }
    function logToGdsApi(level, message) {
        if (gdsConnection && (level === Level.Error || level === Level.InternalError)) {
            try {
                var request = {
                    request: {
                        command: "WriteLogEntry",
                        context: "Gira.G1::Logging",
                        filename: "Gira-G1",
                        level: getGdsLogLevelFromEnum(level),
                        message: message,
                        pretty: "true"
                    }
                };

                gdsConnection.rawSend(JSON.stringify(request));
            } catch (ignore) {
            }
        }
    }
    function prepareStack(e) {
        try {
            if (e.stack) {
                return e.stack;
            }
            return e.message || e;
        } catch (ex) {
            return e;
        }
    }
    ns.Log = {
        Destination: Destination,
        Level: Level,
        enable: function (enable) {
            enabled = enable;
            return this;
        },
        setLevel: function (level) {
            //if (logDestination === Destination.GdsApi && level > Level.Error) {
            //    throw new Error("For Destination 'GdsApi' allowed are only Level 'internalError'.");
            //}
            logLevel = level;
            return this;
        },
        setDestination: function (destination) {
            logDestination = destination;
            // Calling the GDS logging method allowed are only for internal errors.
            if (logDestination === Destination.GdsApi && logLevel > Level.Error) {
                logLevel = Level.Error;
            }
            return this;
        },
        setGdsConnection: function (connection) {
            gdsConnection = connection;
        },
        write: function (level, message) {
            try {
                if (enabled && logLevel >= level) {
                    if (logDestination === this.Destination.GdsApi) {
                        logToGdsApi(level, message);
                    }
                    logToConsole(level, message);
                }
            } catch (ex) {
                console.log("Logging error: " + ex);
            }
            return this;
        },
        info: function (message) {
            this.write(this.Level.Info, message);
            return this;
        },
        error: function (message) {
            this.write(this.Level.Error, message);
            return this;
        },
        exception: function (ex) {
            var message = "Error Stack: " + prepareStack(ex);
            this.write(this.Level.Error, message);
            return this;
        },
        internalException: function (ex) {
            var message = "Error Stack: " + prepareStack(ex);
            this.write(this.Level.InternalError, message);
            return this;
        },
        warning: function (message) {
            this.write(this.Level.Warning, message);
            return this;
        },
        verbose: function (message) {
            this.write(this.Level.Verbose, message);
            return this;
        }
    };
}(window.Gira));

//# sourceURL=gira.log.js