/*global ko, $, eventsOnSettingsEntry, openSettingsElement, openSettingsLastElement, NavbarController, registerEventsForPressButton, _*/
/*jslint browser: true*/

(function () {
    "use strict";
    if (ko.bindingHandlers.giraInputTextBinding) {
        return;
    }
    var Log = window.Gira.Log,
        Globals = window.Gira.Globals,
        catchAll = function (action) {
            try {
                action();
            } catch (e) {
                Log.exception(e);
            }
        },
        findMenuId = function (element) {
            var parentWithMenu = $(element).closest(".menuPage"),
                menuId = parentWithMenu.attr('id');
            return menuId;
        },
        findMenuIdByAttribute = function (element) {
            var parentWithMenu = $(element).closest("[menu]"),
                menuId = parentWithMenu.attr('menu');
            return menuId;
        };

    ko.bindingHandlers.giraInputTextBinding = {
        init: function (element, valueAccessor) {
            catchAll(function () {
                var boundProperty = valueAccessor;
                element.oninput = function () {
                    catchAll(function () {
                        var value = boundProperty();
                        value($(element).val());
                    });
                };
            });
        }
    };

    ko.bindingHandlers.giraButtonBinding = {
        init: function (element, valueAccessor) {
            catchAll(function () {
                var btn = $(element),
                    btnFunc = ko.unwrap(valueAccessor)();
                registerEventsForPressButton(btn,
                    function () { if (!btn.hasClass('disabled')) {btn.addClass('down'); } },
                    function () {btn.removeClass('down'); },
                    function () {
                        if (!btn.hasClass('disabled')) {
                            catchAll(function () {
                                btnFunc();
                            });
                        }
                    });
            });
        }
    };

    ko.bindingHandlers.giraRadioButtonBinding = {
        init: function (element, valueAccessor) {
            catchAll(function () {
                var boundProperty = valueAccessor,
                    domElement = element,
                    settingsRow = $(element).closest(".settings-row");

                eventsOnSettingsEntry(settingsRow.attr("id"));

                settingsRow.on("settingsEntryAction", function () {
                    catchAll(function () {
                        var value = boundProperty();
                        value($(domElement).val());
                    });
                });
            });
        }
    };

    ko.bindingHandlers.giraClearInputIconBinding = {
        init: function (element, valueAccessor) {
            catchAll(function () {
                var input = $(element).prev(),
                    icon = $(element),
                    value = valueAccessor(),
                    subscription,
                    showHideIcon = function () {
                        if (value() && value().length > 0) {
                            icon.show();
                        } else {
                            icon.hide();
                        }
                    };
                subscription = value.subscribe(function () {
                    catchAll(function () {
                        showHideIcon();
                    });
                });
                icon.on("touchend mousedown", function (event) {
                    catchAll(function () {
                        event.preventDefault();
                        value('');
                        icon.hide();
                    });
                });
                input.focus(function () {
                    catchAll(function () {
                        showHideIcon();
                    });
                });
                input.focusout(function () {
                    catchAll(function () {
                        setTimeout(function () {
                            icon.hide();
                        }, 100);
                    });
                });
                ko.utils.domNodeDisposal.addDisposeCallback(element, function () {
                    catchAll(function () {
                        subscription.dispose();
                    });
                });
            });
        }
    };

    /*jslint unparam:true*/
    ko.bindingHandlers.giraSettingsOpenSubMenu = {
        init: function (element, valueAccessor, allBindings, viewModel) {
            var model = viewModel,
                domElement = element;
            catchAll(function () {
                var setSelectedModel = valueAccessor,
                    id = Globals.createGUID();
                domElement.id = id;
                eventsOnSettingsEntry(id);
                $(domElement).on('settingsEntryAction', function () {
                    catchAll(function () {
                        var value = setSelectedModel(),
                            parentWithMenu = $(domElement).closest("[menu]");
                        value(model);
                        openSettingsElement(parentWithMenu.attr('menu'), parentWithMenu.attr('submenu'));
                    });
                });
            });
            ko.utils.domNodeDisposal.addDisposeCallback(element, function () {
                catchAll(function () {
                    $(domElement).off('settingsEntryAction');
                });
            });
        }
    };

    ko.bindingHandlers.giraOkButtonBinding = {
        init: function (element, valueAccessor) {
            catchAll(function () {
                var okBtn = $(element),
                    okFunc = ko.unwrap(valueAccessor)();
                registerEventsForPressButton(okBtn,
                    function () { if (!okBtn.hasClass('disabled')) {okBtn.addClass('down'); } },
                    function () {okBtn.removeClass('down'); },
                    function () {
                        if (!okBtn.hasClass('disabled')) {
                            catchAll(function () {
                                var navigate = NavbarController.getInstance(),
                                    okResult;
                                okResult = okFunc();
                                if (typeof okResult === "function") {
                                    okResult(function () { navigate.back(); });
                                } else {
                                    if (typeof okResult === "number") {
                                        ko.bindingHandlers.giraCaptureNavigate.navigateBack(element, okResult);
                                    } else {
                                        navigate.back();
                                    }
                                }
                            });
                        }
                    });
            });
        }
    };

    /*
     This is a hack for navigating multiple steps in the menu.
     It uses the internals of the navigation controller - it is agreed with Noser that we should do it this way
    */
    ko.bindingHandlers.giraCaptureNavigate = {
        init: function (element) {
            catchAll(function () {
                ko.bindingHandlers.giraCaptureNavigate.capturedMenu = findMenuIdByAttribute(element);
            });
        },
        navigateBack: function (element, steps) {
            catchAll(function () {
                var navigate = NavbarController.getInstance();
                _.times(steps, function () { navigate._history.pop(); });
                openSettingsLastElement(findMenuId(element), ko.bindingHandlers.giraCaptureNavigate.capturedMenu);
            });
        }
    };

    ko.bindingHandlers.giraCancelButtonBinding = {
        init: function (element, valueAccessor) {
            catchAll(function () {
                var cancelBtn = $(element),
                    cancelFunc = ko.unwrap(valueAccessor)();
                registerEventsForPressButton(cancelBtn,
                    function () { cancelBtn.addClass('down'); },
                    function () { cancelBtn.removeClass('down'); },
                    function () {
                        catchAll(function () {
                            cancelFunc();
                            NavbarController.getInstance().back();
                        });
                    });
            });
        }
    };

    ko.bindingHandlers.giraResizeWhenVisibilityChanged = {
        update: function (element, valueAccessor) {
            catchAll(function () {
                var value = valueAccessor ? valueAccessor() : ko.observable(true),
                // we have to read the value so that ko calls the update function
                    valueUnwrapped = ko.unwrap(value),
                    menuElement = $(element).closest('.menuPage');
                setTimeout(function () {
                    catchAll(function () {
                        var swiper = menuElement.data("settings-swiper");
                        if (swiper) {
                            swiper.resizeFix(true);
                        }
                    });
                }, 100);
                return valueUnwrapped; // only returned so that jslint does not complain about unused variable
            });
        }
    };

    /*jslint unparam:true*/
    ko.bindingHandlers.giraRenderBeforeSlider = {
        init: function (element, valueAccessor, allBindings, viewModel) {
            catchAll(function () {
                var descriptionRow = $(element).closest('.settings-swiper-container'),
                    containerDiv = $('<div></div>'),
                    templateId = ko.unwrap(valueAccessor)();
                descriptionRow.before(containerDiv);
                ko.renderTemplate(templateId, viewModel, {}, containerDiv[0], "replaceNode");
            });
        }
    };
    /*jslint unparam:false*/

    ko.bindingHandlers.giraSettingsTitle = {
        init: function (element, valueAccessor) {
            catchAll(function () {
                var settingsContainer = $(element).closest('.settings-container'),
                    descriptionRow = settingsContainer.find('.settings-description-row'),
                    settingsTitle = descriptionRow.find('.settings-title');
                settingsTitle.html(ko.unwrap(valueAccessor)());
            });
        }
    };

    /*jslint unparam:true*/
    ko.bindingHandlers.giraSwiperReInit = {
        update: function (element, valueAccessor, allBindings, viewModel, bindingContext) {
            catchAll(function () {
                var activeSwiper,
                    $elem = $(element),
                    $swiperEl,
                    valueUnwrapped = ko.unwrap(valueAccessor()),
                    defaultLang = viewModel.defaultLang();

                $swiperEl = $elem.parents('.settings-swiper-container');
                activeSwiper =  $swiperEl.data("swiper");

                if (defaultLang && !activeSwiper) {
                    viewModel.setLicenseByLanguageCode(defaultLang);
                }
                if (valueUnwrapped === "reInit" && activeSwiper) {
                    activeSwiper.reInit();
                    setTimeout(function () {
                        activeSwiper.swipeTo(0, 0, false);
                    }, 110);
                }
                if (valueUnwrapped === "swipeTo" && activeSwiper) {
                    activeSwiper.swipeTo(0, 0, false);
                }
            });
        }
    };

    ko.bindingHandlers.giraRenderOkCancelButtons = {
        init: function (element, valueAccessor, allBindings) {
            catchAll(function () {
                var model = ko.unwrap(valueAccessor)();
                if (!model.isValid) {
                    model.isValid = ko.observable(true);
                }
                ko.bindingHandlers.giraRenderBeforeSlider.init(element, function () { return "gira-settings-buttons-template"; }, allBindings, model);
            });
        }
    };

    ko.bindingHandlers.giraRenderDateTimeOkCancelButtons = {
        init: function (element, valueAccessor, allBindings) {
            catchAll(function () {
                var model = ko.unwrap(valueAccessor)();
                if (!model.isValid) {
                    model.isValid = ko.observable(true);
                }
                ko.bindingHandlers.giraRenderBeforeSlider.init(element, function () { return "gira-dateTimeSettings-buttons-template"; }, allBindings, model);
            });
        }
    };
}());

//# sourceURL=gira.ko.extensions.js