﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output indent="yes" method="html"/>
  <!--
    Creates the basic tile structure including function symbol, description text and led/arrow.
    Other tiel elements are copied from params.
    
    params:
        statusText      Elements copied to the status text position
        controlElements Elements copied to the element box
        tileHeader      Elements copied to the tile header             
    -->
  <xsl:template name="tileStructure">
    <xsl:param name="statusText"/>
    <xsl:param name="controlElements"/>
    <xsl:param name="tileHeader"/>
    <xsl:param name="dataAttributes"/>
    
    <xsl:variable name="tileId">tile-<xsl:value-of select="Channel/@ContainerIndex" />-<xsl:value-of select="Channel/@Index" /></xsl:variable>
    
    <div class="tile tile-small">
      <xsl:attribute name="id">
        <xsl:copy-of select="$tileId" />
      </xsl:attribute>
      <xsl:copy-of select="$dataAttributes" />
      <div class="tile-flow-top" style="visibility: hidden"></div>
      <xsl:if test="Channel/FunctionSymbol/@Enable = 'true'">
        <div class="tile-icon">
          <xsl:attribute name="class">
            <xsl:text>tile-icon sprites {{</xsl:text><xsl:value-of select="Channel/@ContainerIndex" />-<xsl:value-of select="Channel/@Index" /><xsl:text>-tile-functionsymbol}}</xsl:text>
          </xsl:attribute>
        </div>
      </xsl:if>
      <xsl:copy-of select="$tileHeader" />
      <div class="grid-line {{{{tile-grid-line}}}} grid-line-one grid-line-small"></div>
      <div class="tile-description-box tile-description-box-small">
        <div class="tile-description-box-text">
          <div class="tile-description-text t2sg">
            <xsl:value-of select="Channel/Description/Language[@Index = 0]" />
          </div>
          <div class="tile-description-room t2gg">
            <xsl:value-of select="Channel/ContainerDescription/Language[@Index = 0]" />
          </div>
        </div>
        <!-- LED -->
        <xsl:if test="Channel/StatusLed/@Enable = 'true' or Channel/@TypeURN ='de.gira.schema.channels.Sceneextension' ">
          <div class="tile-status-led"></div>
        </xsl:if>
        <!-- Function Folder Arrow -->
        <xsl:if test="Channel/@TypeURN = 'de.gira.schema.channels.Container' or Channel/@TypeURN = 'de.gira.schema.channels.World'">
          <div class="container-arrow sprites {{{{tile-arrow-right}}}}"></div>
        </xsl:if>
      </div>
      <div class="grid-line {{{{tile-grid-line}}}} grid-line-two grid-line-small"></div>
      <!-- Status Text -->
      <xsl:copy-of select="$statusText"/>
      <!-- Control Elements -->
      <div class="element-box">
        <xsl:copy-of select="$controlElements"/> 
      </div>
    </div>
  </xsl:template>

  <xsl:template name="tileContent">
    <xsl:param name="statusText"/>
    <xsl:param name="controlElements"/>
    <xsl:param name="tileHeader"/>
    <xsl:param name="dataAttributes"/>

      <xsl:copy-of select="$dataAttributes" />
      <div class="tile-flow-top" style="visibility: hidden"></div>
      <xsl:if test="Channel/FunctionSymbol/@Enable = 'true'">
        <div class="tile-icon">
          <xsl:attribute name="class">
            <xsl:text>tile-icon sprites {{</xsl:text><xsl:value-of select="Channel/@ContainerIndex" />-<xsl:value-of select="Channel/@Index" /><xsl:text>-tile-functionsymbol}}</xsl:text>
          </xsl:attribute>
        </div>
      </xsl:if>
      <xsl:copy-of select="$tileHeader" />
      <div class="grid-line {{{{tile-grid-line}}}} grid-line-one grid-line-small"></div>
      <div class="tile-description-box tile-description-box-small">
        <div class="tile-description-box-text">
          <div class="tile-description-text t2sg">
            <xsl:value-of select="Channel/Description/Language[@Index = 0]" />
          </div>
          <div class="tile-description-room t2gg">
            <xsl:value-of select="Channel/ContainerDescription/Language[@Index = 0]" />
          </div>
        </div>
        <!-- LED -->
        <xsl:if test="Channel/StatusLed/@Enable = 'true' or Channel/@TypeURN ='de.gira.schema.channels.Sceneextension' ">
          <div class="tile-status-led"></div>
        </xsl:if>
        <!-- Function Folder Arrow -->
        <xsl:if test="Channel/@TypeURN = 'de.gira.schema.channels.Container' or Channel/@TypeURN = 'de.gira.schema.channels.World'">
          <div class="container-arrow sprites {{{{tile-arrow-right}}}}"></div>
        </xsl:if>
      </div>
      <div class="grid-line {{{{tile-grid-line}}}} grid-line-two grid-line-small"></div>
      <!-- Status Text -->
      <xsl:copy-of select="$statusText"/>
      <!-- Control Elements -->
      <div class="element-box">
        <xsl:copy-of select="$controlElements"/>
      </div>
  </xsl:template>
  
</xsl:stylesheet>