﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:import href="xsltemplates.xsl"/>
  <xsl:output indent="yes" />
  <xsl:output method="html"/>
  <xsl:template match="/">
    <div>
    <xsl:variable name="detailId">detail-<xsl:value-of select="Channel/@ContainerIndex" />-<xsl:value-of select="Channel/@Index" /></xsl:variable>
    <xsl:call-template name="channel_detail_description_row"/>      
      <div class="detail detailflip">
        <xsl:attribute name="id">
          <xsl:copy-of select="$detailId" />
        </xsl:attribute>
        <xsl:attribute name="data-datapoint-id">
          <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='SceneNo']/@Id"/>
        </xsl:attribute>
          <xsl:attribute name="data-sceneName">
              <xsl:value-of select="Channel/Description/Language[@Index = 0]"/>
          </xsl:attribute>
        <xsl:if test="Channel/DataPoints/DataPoint[@Name='StoreSceneNo']">
          <xsl:attribute name="data-datapoint-store-id">
            <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='StoreSceneNo']/@Id"/>
          </xsl:attribute>
        </xsl:if>
        <xsl:attribute name="data-count">
          <xsl:value-of select="Channel/@count"/>
        </xsl:attribute>
        <div class="coverflip-container">
          <div class="coverflip-viewsides">
            <div id="flip" class="coverflip-side front">
              <xsl:if test="Channel/DataPoints/DataPoint[@Name='StoreSceneNo']">
                <div class="sceneSettingsBtn">
                  <div class="sceneSettingsBtnSprite sprites {{{{btnSettings}}}}"></div>
                </div>
              </xsl:if>
              <div class="trigger-container">
                <div>
                  <xsl:attribute name="class">
                    <xsl:text>trigger-button sprites {{detail-button}} </xsl:text>
                  </xsl:attribute>
                  <span class="trigger-text-off t1sg">{{sceneDetailButtonRetrieve}}</span>
                </div>
                <div>
                  <xsl:attribute name="class">
                    <xsl:text>trigger-ring ring1 sprites {{statusring-0}}</xsl:text>
                  </xsl:attribute>
                </div>
                <div>
                  <xsl:attribute name="class">
                    <xsl:text>trigger-ring ring2 sprites {{statusring-2}}</xsl:text>
                  </xsl:attribute>
                </div>
              </div>
              <div class="coverflip-background">
              </div>
              <xsl:if test="Channel/TimeSwitches/@Enable ='true'">
                <div class="timer-icon sprites {{{{gc4_button_timer}}}}"></div>
              </xsl:if>
            </div>
          </div>
        </div>
      </div>

      <script type="text/javascript">
        (function(){
        var detailId = '<xsl:copy-of select="$detailId" />';
        var dataset = document.getElementById(detailId).dataset;
        
        eventsOnSceneTrigger('#'+detailId, dataset.datapointId);
        <xsl:if test="Channel/DataPoints/DataPoint[@Name='StoreSceneNo']">
          eventOnSceneSettingsButton('#'+detailId, dataset.datapointStoreId);
          initSceneBtns('#'+detailId);
        </xsl:if>

        <xsl:if test="Channel/TimeSwitches/@Enable ='true'">
          var timerFunctions = [{name: "call", datapoint: dataset.datapointId, values: [1]}];
          tsx.timer.registerTimer(detailId, 'scene', dataset.count, timerFunctions);
        </xsl:if>
          
        })();
      </script>
    </div>
   </xsl:template>
</xsl:stylesheet>

