﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:import href="xsltemplates.xsl"/>
  <xsl:output indent="yes" />
  <xsl:output method="html"/>
  <xsl:template match="/">
    <div>
    <xsl:variable name="detailId">
      <xsl:text>detail-</xsl:text><xsl:value-of select="Channel/@ContainerIndex" />-<xsl:value-of select="Channel/@Index" />
    </xsl:variable>
    <xsl:call-template name="channel_detail_description_row"></xsl:call-template>
    <div class="detail">
      <xsl:attribute name="id">
        <xsl:copy-of select="$detailId" />
      </xsl:attribute>
      <xsl:attribute name="data-heating-status-id">
        <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='HeatingStatus']/@Id"/>
      </xsl:attribute>
      <xsl:attribute name="data-cooling-status-id">
        <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='CoolingStatus']/@Id"/>
      </xsl:attribute>
      <xsl:attribute name="data-setpoint-temperature-status-id">
        <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='SetpointTemperatureStatus']/@Id"/>
      </xsl:attribute>
      <xsl:attribute name="data-setpoint-temperature-shift-up-id">
        <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='SetpointTemperatureShiftUp']/@Id"/>
      </xsl:attribute>
      <xsl:attribute name="data-setpoint-temperature-shift-down-id">
        <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='SetpointTemperatureShiftDown']/@Id"/>
      </xsl:attribute>
      <xsl:attribute name="data-controller-operation-lock-status-id">
        <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='ControllerOperationLockStatus']/@Id"/>
      </xsl:attribute>
      <xsl:attribute name="data-controller-operation-locked">
        <xsl:value-of select="Channel/ControllerOperationLocked/@Enable"/>
      </xsl:attribute>
      <xsl:attribute name="data-setpoint-temperature-shift-status-id">
        <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='SetpointTemperatureShiftStatus']/@Id"/>
      </xsl:attribute>
      <xsl:attribute name="data-setpoint-temperature-shift-absolute-id">
        <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='SetpointTemperatureShiftAbsolute']/@Id"/>
      </xsl:attribute>
      <xsl:attribute name="data-operation-mode-id">
        <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='OperationMode']/@Id"/>
      </xsl:attribute>
      <xsl:attribute name="data-presence-id">
        <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='Presence']/@Id"/>
      </xsl:attribute>
      <xsl:attribute name="data-presence-status-id">
        <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='PresenceStatus']/@Id"/>
      </xsl:attribute>
      <xsl:attribute name="data-show-presence-button-information-id">
        <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='ShowPresenceButtonInformation']/@Id"/>
      </xsl:attribute>
      <xsl:attribute name="data-dew-point-lock-status-id">
        <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='DewPointLockStatus']/@Id"/>
      </xsl:attribute>
      <xsl:attribute name="data-dew-point-status-id">
        <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='DewPointLockStatus']/@Id"/>
      </xsl:attribute>
      <xsl:attribute name="data-eco-modus-status-id">
        <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='EcoModusStatus']/@Id"/>
      </xsl:attribute>
      <xsl:attribute name="data-operation-mode-status-id">
        <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='OperationModeStatus']/@Id"/>
      </xsl:attribute>
      <xsl:attribute name="data-internal-temperature-id">
        <xsl:value-of select="//Temperature/DataPoints/DataPoint[@Name='InternalTemperature']/@Id"/>
      </xsl:attribute>
      <xsl:attribute name="data-actual-temperature-id">
        <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='ActualTemperature']/@Id"/>
      </xsl:attribute>
      <xsl:attribute name="data-controller-mode">
        <xsl:value-of select="Channel/ControllerMode/@Mode"/>
      </xsl:attribute>
      <xsl:attribute name="data-change-comfort-setpoint-temperature">
        <xsl:value-of select="Channel/SetPointTemperatureChange/@ChangeComfortSetpointTemperature"/>
      </xsl:attribute>
      <xsl:attribute name="data-change-standby-setpoint-temperature">
        <xsl:value-of select="Channel/SetPointTemperatureChange/@ChangeStandbySetpointTemperature"/>
      </xsl:attribute>
      <xsl:attribute name="data-change-economy-setpoint-temperature">
        <xsl:value-of select="Channel/SetPointTemperatureChange/@ChangeEconomySetpointTemperature"/>
      </xsl:attribute>
      <xsl:attribute name="data-rtc-id">
        <xsl:value-of select="Channel/@Id"/>
      </xsl:attribute>
      <xsl:attribute name="data-container-index">
        <xsl:value-of select="Channel/@ContainerIndex"/>
      </xsl:attribute>
      
      <div class="coverflip-container">
        <div class="coverflip-viewsides">
          <div id="rtc" class="coverflip-side front">
            <div class="rtc-controller">
              <div class="bg sprites {{{{gc4_rtr_skala_mask_bg}}}}"></div>
              <div class="dec">
                <div class="decs sprites {{{{gc4_icon_config_minus}}}}"></div>
              </div>
              <div class="inc">
                <div class="incs sprites {{{{gc4_icon_config_plus}}}}"></div>
              </div>
              <div class="details">
                <span class="is t2lgg">{{langRtcCurrentTemp}}</span>
                <span class="is-temp t2lgg">- - - °C</span>
                <span class="set t2lgg">{{langRtcSetpoint}}</span>
                <div class="divider sprites {{{{gc4_rtr_line_h}}}}"></div>
                <span class="set-unit t2gg">°C</span>
                <span class="set-temp t1sg">- - -</span>
                <div class="divider1 sprites {{{{gc4_rtr_line_h}}}}"></div>
                <div class="operation-mode-symbol sprites"></div>
                <span class="operation-mode-text t2lgg"></span>
                <div class="heating-cooling-dew-icon">
                  <div class="heating-cooling-status sprites"></div>
                </div>
              </div>
              <div class="footer">
                <div class="btn modes cssButton170">
                  <span class="label">{{rtcDetailModus}}</span>
                  <span class="sprites {{{{tile-arrow-right}}}} arrow-right"></span>
                </div>
              </div>
              <div class="coverflip-background">
              </div>
              <div id="rtr-hatch">
                <canvas id="rtr-hatch-canvas"></canvas>
              </div>
              <div class="mask sprites {{{{gc4_rtr_skala_mask}}}}"></div>
              <div class="knob-container">
                <div class="event-blocker"></div>
                <input disabled="disabled" class="knob rtr-stop-knob-input"
                  value="100"
                  data-angleOffset="-121"
                  data-angleArc="242"
                  data-min="100"
                  data-max="300">
                  <xsl:attribute name="id"><xsl:text>knob-</xsl:text><xsl:copy-of select="$detailId" />
                  </xsl:attribute>
                </input>
              </div>
            </div>
            <xsl:call-template name="rtc-mode-extension">
              <xsl:with-param name="detailId" select="$detailId"/>
            </xsl:call-template>
            <xsl:if test="//Channel/TemperatureControllerTimeSwitches/@Enable ='true'">
              <div class="timer-icon sprites {{{{gc4_button_timer}}}}"></div>
            </xsl:if>
            <div class="rtc-ecomode-img sprites {{{{gc4_rtr_icon_ecomode}}}}"></div>
            <div class="rtc-lockmode-img sprites {{{{gc4_listicon_lock}}}}"></div>
          </div>
        </div>
      </div>

      <script type="text/javascript">
        (function() {

        var detailId = '<xsl:value-of select="$detailId" />';
        var dataset = document.getElementById(detailId).dataset;
        var isControllerOperationLock = dataset.controllerOperationLocked === 'true';
        var changeComfortSetpointTemperature = dataset.changeComfortSetpointTemperature === 'true';
        var changeStandbytSetpointTemperature = dataset.changeStandbySetpointTemperature === 'true';
        var changeEconomySetpointTemperature = dataset.changeEconomySetpointTemperature === 'true';

        var timerId = 40200;

        function opMode(isEditable, icon, label, editId){
        return {isEditable: isEditable, icon: icon, label: label, editId: editId};
        }

        var opModes = {comfort: opMode(changeComfortSetpointTemperature, '{{gc4_rtr-icon_comfort_detail}}', '{{timerTemplatesRtcTimerActionKomfort}}', 'rtr-comfort-edit'),
        standby: opMode(changeStandbytSetpointTemperature, '{{gc4_rtr-icon_standby_detail}}', '{{timerTemplatesRtcTimerActionStandby}}', 'rtr-standby-edit'),
        economy: opMode(changeEconomySetpointTemperature, '{{gc4_rtr-icon_night_detail}}', '{{timerTemplatesRtcTimerActionNight}}', 'rtr-economy-edit'),
        thermalprotection: opMode(false, '{{gc4_rtr-icon_frost_detail}}', '{{timerTemplatesRtcTimerActionFrost}}', 'rtr-thermalprotection-edit')};

        var heatingIcon = '{{gc4_icon_heating_detail}}';
        var coolingIcon = '{{gc4_icon_cooling_detail}}';
        var dewPointIcon = '{{gc4_rtr_icon_tau}}';
        var arrowIcon = '{{tile-arrow-right}}';
        var hatchImage = '{{gc4_rtr_hatch_blocked}}';
        
        <xsl:if test="//Channel/TemperatureControllerTimeSwitches/@Enable ='true'">
          var timerFunctions = [{name: "operationMode", datapoint: dataset.operationModeId, values: [1, 2, 3, 4]}];
          tsxGdsUtility$.registerTimer(timerId, timerFunctions);
          tsx.timer.registerTimerButton(detailId, timerId,'rtc');
        </xsl:if>

        rtc.init(detailId, dataset, arrowIcon, hatchImage,'{{gc4_icon_config_plus}}', '{{gc4_icon_config_minus}}', opModes);
        RtcModes.registerRtcOperationModeStatusCaseSets(dataset.operationModeStatusId);
        rtc.registerRtcTemperatureStatusCaseSets(dataset, isControllerOperationLock, heatingIcon, coolingIcon, dewPointIcon);
        rtc.registerRtcEcoModeCaseSet(dataset.ecoModusStatusId);
        rtc.setheatingCoolingMode(dataset.controllerMode);
        RtcModes.buildModes();

        $("#" + detailId).on("init", function() {
          rtc.initRtcTemp();
        });
        })();
      </script>

    </div>
   </div>
  </xsl:template>
</xsl:stylesheet>