<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:import href="xsltemplates.xsl"/>
  <xsl:output indent="yes" />
  <xsl:output method="html"/>
  <xsl:template match="/">
    <div>
      <xsl:variable name="detailId">detail-top-<xsl:value-of select="Container/@Index" /></xsl:variable>
      <xsl:call-template name="container_detail_description_row"></xsl:call-template>
        <div class="detail">
          <xsl:attribute name="id">
            <xsl:copy-of select="$detailId" />
          </xsl:attribute>
          <xsl:attribute name="data-container-index">
            <xsl:value-of select="Container/@Index"/>
          </xsl:attribute>
          <div class="detail-view-white">
            <div class="detail-folder-register"></div>
            <div class="detail-folder-body">
              <div class="t1sg numcontent">
                <xsl:value-of select="count(Container/Channels/Channel)"/>
              </div>
              <div class="t2sg methodsstring">{{langFunctionFolderDetail}}</div>
              <div class="listcontent info-swiper-container-vertical">
                <div class="swiper-wrapper">
                  <div class="swiper-slide">
                    <xsl:for-each select="Container/Channels/Channel">
                      <span class="textline">
                        <span class="title t3sg"><xsl:value-of select="Description/Language[@Index = 0]"/></span>
                        <span class="status t3lsg"></span>
                      </span>
                      <div class="gridline"></div>
                    </xsl:for-each>
                  </div>
                </div>
              </div>
              <div class="info-swiper-scrollbar-vertical"></div>
            </div>
            <div class="detail-folder-down sprites {{{{detail-folder-down}}}}"></div>
          </div>
        </div>
      <script type="text/javascript">
        (function(){
        var detailId = '#<xsl:value-of select="$detailId"/>';
        var dataset = document.getElementById('<xsl:value-of select="$detailId"/>').dataset;
        var detailViewId = '#detail-view-' + dataset.containerIndex;
      <xsl:text disable-output-escaping="yes"><![CDATA[         
        $(function(){
          var mySwiper = $(detailId + ' .info-swiper-container-vertical').swiper({
            mode:'vertical',
            loop:false,
            scrollContainer: true,
            simulateTouch: !(("ontouchstart" in document.documentElement) || navigator.userAgent === 'Selenium'),
            calculateHeight: true,
            grabCursor: true,
            mousewheelControl: true,
            scrollbar: {
              container : detailId + ' .info-swiper-scrollbar-vertical',
              draggable : true,
              hide: true,
              snapOnRelease: true
            },
            onSlideMoveStart: function(){
              $(detailId + ' .info-swiper-container-vertical').data("swiper").reInit();
              $(detailId + ' .detail').trigger('touchcancel');
            }
          });
        });

        registerEventsForPressButton($(detailId),
          function(){
            $(detailId + '> .detail-view-white > .detail-folder-down ').css('display', 'block');
          },
          function(){
            $(detailId + '> .detail-view-white > .detail-folder-down ').css('display', 'none');
          },
          function(){
            NavbarController.getInstance().loadContainer(detailViewId, false, 0, undefined, animationTypes.COVER_ZOOM);
          }
        );        
]]></xsl:text>
        })();
      </script>
    </div>
    </xsl:template>
</xsl:stylesheet>
