/*global ko, $, gds$, _*/
/*jslint browser: true*/

(function (ns, ko) {
    "use strict";

    function NetworkViewModel(translate) {
        var data = [
                {value: "LAN", name: translate.i18n("configNetworkLANText")},
                {value: "WLAN", name: translate.i18n("configNetworkWLANText")}
            ],
            networks = ko.observableArray(data),
            selected = ko.observable();

        return {
            selected: selected,
            pageTitle: translate.i18n('pageNetworkTitle'),
            pageInfo: translate.i18n('pageNetworkInfo'),
            networks: networks,
            isValid: function () { return !!selected(); }
        };
    }

    ns.NetworkViewModel = NetworkViewModel;
}(window, ko));