/*global ko, $, _, Gira, getConnectionInfo*/
/*jslint browser: true*/

(function (ns, ko) {
    "use strict";

    function FinishViewModel(translate, gds, networkInterface) {
        var gdsAppName = 'confd',
            gdsGeneratorConfigKey = 'GeneratorConfiguration',
            gdsStartupTypeKey = 'StartupType',
            gdsFirstAppName = 'gira-app',
            gdsStartupParameter = 'startupParameter',
            isStarted = ko.observable(false),
            gds$ = gds;

        function setAppValue(appId, key, value) {
            return {
                request: {
                    command: "SetAppValue",
                    appName: appId,
                    key: key,
                    value: value
                }
            };
        }

        function copySplashScreenLanguageFile(lang, callback) {
            var appId = "powerd",
                connectionInfo = getConnectionInfo(),
                connection = new Gira.GdsConnectionWrapper(connectionInfo.ip),
                gdsConnector = new Gira.DcsToGdsConnector(appId, false, connection);

            try {
                $.ajax({
                    url: "lang/" + lang + "/splashscreen-lang.json",
                    cache: false,
                    async: false
                }).success(function (data) {
                    gdsConnector.__sendRegisterApplication();
                    gdsConnector.sendMessage(setAppValue(appId, "SplashScreenText", data));
                    callback();
                }).error(function (error) {
                    window.Gira.Log.error(error);
                });
            } catch (ex) {
                window.Gira.Log.exception(ex);
            }
        }

        function start(pageModels) {
            var config = {},
                useWifi = pageModels.networkModel.selected() === "WLAN";
            isStarted(true);
            // Prepare data ...
            pageModels.worldsModel.worlds().forEach(function (item) {
                config[item.value] = _.contains(pageModels.worldsModel.selected(), item.value);
            });
            config.DeviceBaseConfiguration = pageModels.installationEnvironmentModel.selected();
            config.selectedLanguage = pageModels.languageSelectionModel.selected();
            // Copy splash screen language file
            copySplashScreenLanguageFile(config.selectedLanguage, function () {
                // Save Configuration
                gds$.setAppValue(gdsAppName, gdsGeneratorConfigKey, JSON.stringify(config));
                gds$.setAppValue(gdsAppName, gdsStartupTypeKey, pageModels.installationEnvironmentModel.selected());
                gds$.setDeviceConfigurationValue(true, { 'TimeZoneID': pageModels.timeZonesModel.selectedGdsId()});

                networkInterface.network.wifi.isWifiOn(useWifi);

                // Save Start Parameter
                gds$.setAppValue(gdsFirstAppName, gdsStartupParameter, 'true');
                // Start Wizard Generation
                gds$.setValue("1101", "2");
                localStorage.initialInstallationDone = true;
            });
        }

        return {
            pageTitle: translate.i18n('pageFinishTitle'),
            pageInfo: translate.i18n('pageFinishInfo'),
            isStarted: isStarted,
            start: start,
            isValid: function () { return true; }
        };
    }

    ns.FinishViewModel = FinishViewModel;

}(window, ko));