﻿window.tsx.wizard = new (function () {
    var module = {};

    //gds app name and output file name for System
    var gdsAppName = 'confd';
    var gdsGeneratorConfigKey = 'GeneratorConfiguration';
    var gdsStartupTypeKey = 'StartupType';
    var gdsFirstAppName = 'gira-app';
    var gdsStartupParameter = 'startupParameter';


    //fist installation wizard data model    
    module.config = {

        "environments": [

        {
            value: 'TastsensorX', name: 'KNX',
            "worlds": [{ value: 'DCS', name: 'Türkommunikation' },
                   { value: 'WEATHER', name: 'Wetterprognose' }],
            "selected": []
        },
        {
            value: 'DCS', name: 'nur Türkommunikation',
            "worlds": [{ value: 'WEATHER', name: 'Wetterprognose' }],
            "selected": []
        }
        ],
        "selectedEnvironment": 'TastsensorX'
    };

    /**
	* returns the selected worlds for the given environment
	*/
    function getSelectedWorlds(env) {
        for (var i = 0; i < module.config.environments.length; i++) {
            if (module.config.environments[i].value === env) {
                return module.config.environments[i].selected;
            }
        }
    };

    /**
	* Save the user selected configuration to the file system.	
	*/
    module.saveConfiguration = function () {
        var opts = getSelectedWorlds(module.config.selectedEnvironment);

        var optsWorldJsonObj = {};
        for (w in opts) {
            optsWorldJsonObj[opts[w]] = "true";
        }
        optsWorldJsonObj["DeviceBaseConfiguration"] = module.config.selectedEnvironment;

        gds$.setAppValue(gdsAppName, gdsGeneratorConfigKey, JSON.stringify(optsWorldJsonObj));
        gds$.setAppValue(gdsAppName, gdsStartupTypeKey, module.config.selectedEnvironment);
    };

    /**
     * Save the user selected configuration to the file system.	
     */
    module.saveStartParameter = function () {
        gds$.setAppValue(gdsFirstAppName, gdsStartupParameter, 'true');
    };

    /**
     * Adds handlers for button states and click actions.
     */
    var registerWizardButton = function (pageId, classSuffix, callback, imageInfo) {
        var btnWizard = $(pageId + ' .fi_wizard_' + classSuffix);
        var rightIcon = btnWizard.find('.rightIcon');
        var leftIcon = btnWizard.find('.leftIcon');
        var targetId = btnWizard.attr('id_next');

        if (imageInfo != undefined) {
            if (imageInfo.right != undefined) {
                rightIcon.addClass('sprites');
                rightIcon.addClass(imageInfo.right.baseClass);
                rightIcon.addClass(imageInfo.right.iconClass);
            }
            if (imageInfo.left != undefined) {
                leftIcon.addClass('sprites');
                leftIcon.addClass(imageInfo.left.baseClass);
                leftIcon.addClass(imageInfo.left.iconClass);
            }
        }

        registerEventsForPressButton(btnWizard,
            function () {
                if (btnWizard.hasClass('disabled')) {
                    return;
                }
                btnWizard.addClass('down');
                if (imageInfo != undefined && imageInfo.right != undefined) {
                    handleWizardButtonIcon(rightIcon, imageInfo.right, true);
                }
                if (imageInfo != undefined && imageInfo.left != undefined) {
                    handleWizardButtonIcon(leftIcon, imageInfo.left, true);
                }
            }, function () {
                btnWizard.removeClass('down');
                if (imageInfo != undefined && imageInfo.right != undefined) {
                    handleWizardButtonIcon(rightIcon, imageInfo.right, false);
                }
                if (imageInfo != undefined && imageInfo.left != undefined) {
                    handleWizardButtonIcon(leftIcon, imageInfo.left, false);
                }
            }, function () {
                if (btnWizard.hasClass('disabled')) {
                    return;
                }
                if (typeof (callback) === "function") {
                    callback.call();
                }
                if (classSuffix === 'prev') {
                    prevPage(pageId, targetId);
                } else if (classSuffix === 'next') {
                    nextPage(pageId, targetId);
                }
            }
        );
    }

    /**
     * Handles inactive button states.
     */
    var handleWizardButtonIcon = function (icon, imageInfo, isDown) {
        if (isDown) {
            if (imageInfo.iconDownClass != undefined) {
                icon.removeClass(imageInfo.iconClass);
                icon.addClass(imageInfo.iconDownClass);
            }
        } else {
            if (imageInfo != undefined && imageInfo.iconDownClass != undefined) {
                icon.removeClass(imageInfo.iconDownClass);
                icon.addClass(imageInfo.iconClass);
            }
        }
    }

    /**
    * Register next button functionality: page change to next page
    */
    module.registerNextButton = function (pageId, callback, imageInfo) {
        registerWizardButton(pageId, 'next', callback, imageInfo);
    };

    /**
    * Register previous button functionality: page change to previous page
    */
    module.registerPrevButton = function (pageId, callback, imageInfo) {
        registerWizardButton(pageId, 'prev', callback, imageInfo);
    };

    /**
    * Register End configuration button functionality: save config using GDS and close the wizard
    */
    module.registerEndConfigButton = function (btnId) {
        var $btn = $('#' + btnId);

        registerEventsForPressButton($btn,
            function () {
                $btn.addClass('down');
            }, function () {
                $btn.removeClass('down');
            }, function () {
                $btn.off();
                module.saveConfiguration();
                module.saveStartParameter();
                module.startWizardGeneration();
                localStorage.initialInstallationDone = true;
            }
        );
    };

    /**
    * Register license check box functionality
    */
    module.onLicenseCheckBox = function () {
		var checkbox = $('.acceptLicense .checkbox-input');
        var checked = checkbox.prop('checked');
        if (checked) {
            checkbox.prop('checked', false);            
            $('#fi_page_1 .fi_wizard_next').addClass("disabled");
            $('.acceptLicense .custom-checkbox .noDownEffect').hide();
        }
        else {
            checkbox.prop('checked', true);
            module.registerNextButton('#fi_page_1');
            $('#fi_page_1 .fi_wizard_next').removeClass("disabled");
            $('.acceptLicense .custom-checkbox .noDownEffect').show();
        }
    };

    /**
    * reset license acceptance state to 'no'
    */
    module.onLicenseAbort = function () {
        var checkbox = $('.acceptLicense .checkbox-input');        
        checkbox.prop('checked', false);
        $('#fi_page_1 .fi_wizard_next').addClass("disabled");
        $('.acceptLicense .custom-checkbox .noDownEffect').hide();
    };

    /**
    * helper function to add an unclickable overlay to prevent user actions during animations
    */
    function addUnclickableOverlay() {
        var $overlay = $("<div>", {
            id: "immovableObject",
            style: "position: absolute; top:0; left:0; width: 480px; height:800px; z-index:10000; opacity:1.0;"
        });
        $('body').append($overlay);
    };

    /**
    * close the unclickable overlay
    */
    function removeUnclickableOverlay() {
        $("#" + "immovableObject").remove();
    };

    /**
    * trigger the page change animation to the left (next page)
    */
    function animateLeft(src, target) {
        var parent = src.parent();

        src.css({ position: 'absolute', left: 0 });
        target.hide().appendTo(parent).css({ left: 462, position: 'absolute' });

        src.animate({ left: -462 }, 500, function () {
            $(src).appendTo($('#hidden-pages'));
        });
        target.show().animate({ left: 0 }, 500, function () {
            target.css({ left: null, position: null });
            removeUnclickableOverlay();
        });
    }

    /**
    * trigger the page change animation to the right (previous page)
    */
    function animateRight(src, target) {
        var parent = src.parent();

        src.css({ position: 'absolute', left: 0 });
        target.hide().appendTo(parent).css({ left: -462, position: 'absolute' });

        src.animate({ left: 462 }, 500, function () {
            $(src).appendTo($('#hidden-pages'));
        });
        target.show().animate({ left: 0 }, 500, function () {
            target.css({ left: null, position: null });
            removeUnclickableOverlay();
        });
    }

    /**
    * set the page title of a new page and do the fade in/out animation
    */
    function setTitle(pageId) {
        var src = $(pageId + ' .title').text();
        var $dest = $('#' + "pageContent" + ' .fi_pageHeader .fi_blend:last');
        $dest.text(src);
        var $first = $('#' + "pageContent" + ' .fi_pageHeader .fi_blend:first');
        $first.insertAfter($dest);

        $dest.toggleClass('fi_fadeIn', true);
        $first.toggleClass('fi_fadeOut', true);

        $dest.toggleClass('fi_fadeOut', false);
        $first.toggleClass('fi_fadeIn', false);
    }

    /**
    * set the page info text of a new page and do the fade in/out animation
    */
    function setInfoText(pageId) {
        var src = $(pageId + ' .infoText').text();
        var $dest = $('#' + "pageContent" + ' .fi_pageDescription .fi_blend:last');
        $dest.text(src);
        var $first = $('#' + "pageContent" + ' .fi_pageDescription .fi_blend:first');
        $first.insertAfter($dest);

        $dest.toggleClass('fi_fadeIn', true);
        $first.toggleClass('fi_fadeOut', true);

        $dest.toggleClass('fi_fadeOut', false);
        $first.toggleClass('fi_fadeIn', false);

    }

    /**
    * do the whole forward page change to a new wizard page
    */
    function nextPage(currentPageId, nextPageId) {
        addUnclickableOverlay();
        animateLeft($(currentPageId), $('#' + nextPageId));

        setTitle('#' + nextPageId);
        setInfoText('#' + nextPageId);
    }

    /**
    * do the whole backward page change to a new wizard page
    */
    function prevPage(currentPageId, nextPageId) {
        addUnclickableOverlay();
        animateRight($(currentPageId), $('#' + nextPageId));

        setTitle('#' + nextPageId);
        setInfoText('#' + nextPageId);
    }


    /**
	* Start generation and turn off display
	*
	*/
    module.startWizardGeneration = function () {
        gds$.setValue("1101","2");
    };

    // knockout subscribale
    // required for communication between environmentSelectionModel and worldsSelectionModel
    module.subscribable = new ko.subscribable();

    /**
    * knockout model for install environment selection
    */
    module.environmentSelectionModel = new function () {
        var self = this;
        self.environment = ko.observableArray(module.config.environments);
        self.selected = ko.observable(module.config.selectedEnvironment);

        //allow other models to subscribe to the selected environment's changes
        self.selected.subscribe(function (newValue) {
            module.subscribable.notifySubscribers(newValue, 'environment');
            module.config.selectedEnvironment = newValue;
        });

        self.registerEvents = function (element, data) {
            eventsOnSettingsEntry(element[1].id);
            $(element[1]).on('settingsEntryAction', function () {
                self.selected(data.value);
            });
        };
    };

    /**
    * knockout model for additional worlds selection
    */
    module.worldsSelectionModel = new function () {
        var self = this;

        self.worlds = ko.observableArray();
        self.selected = ko.observableArray();

        //update 'additional worlds view' on install environment changes
        function setInstallEnvironment(env) {
            for (var i = 0; i < module.config.environments.length; i++) {
                if (module.config.environments[i].value === env) {
                    self.worlds(module.config.environments[i].worlds);
                    self.selected(module.config.environments[i].selected);
                    break;
                }
            }
        }

        setInstallEnvironment(module.config.selectedEnvironment);

        //subscribe to environmentSelectionModel's selected environment
        module.subscribable.subscribe(function (newValue) {
            setInstallEnvironment(newValue);
        }, null, 'environment');

        self.registerEvents = function (element, data) {
            eventsOnSettingsEntry(element[1].id);
            $(element[1]).on('settingsEntryAction', function () {
                var pos = self.selected.indexOf(data.value);

                if (pos < 0) {
                    self.selected.push(data.value);
                } else {
                    self.selected.splice(pos, 1);
                }
            });
        };
    };

    /**
    * init the whole wizard module
    * -sets the first wizard page visibile
    * -set  first page's title and info text (without animations)
    * -connect to GDS
    * -applay knockout bindings
    */
    module.init = function () {

        var $content = $('#pages');
        var $hidden = $('#hidden-pages #fi_page_0');
        $hidden.appendTo($content);

        setTitle('#fi_page_0');
        setInfoText('#fi_page_0');

        gds$.connect('ws://localhost:8182/gds/api');
        
        ko.applyBindings(module.environmentSelectionModel, $('#fi_page_2')[0]);
        ko.applyBindings(module.worldsSelectionModel, $('#fi_page_3')[0]);

        $(window).load(function () {          
            gds$.ready(function () {
                tsxGdsUtility$.removeSplashScreen();
            });
        });
    };

    return module;
})();