/**
 * 
 * Find more about the Spinning Wheel function at
 * http://cubiq.org/spinning-wheel-on-webkit-for-iphone-ipod-touch/11
 *
 * Copyright (c) 2009 Matteo Spinelli, http://cubiq.org/
 * Released under MIT license
 * http://cubiq.org/dropbox/mit-license.txt
 * 
 * Version 1.4 - Last updated: 2009.07.09
 * 
 * Modified by Noser Engineering AG
 */
SpinningWheel.getById = function (id) {
    return $('#' + id).data('SpinnWheel');
}

SpinningWheel.create = function (params) {
    if (this.getById(params.spinnWheelId) === undefined) {
        var mySpinnWheel = new SpinningWheel({ 'id': params.spinnWheelId, 'isFloat': params.isFloat, 'enabled': params.enabled , 'wrap': params.wrap});
        for (w in params.wheels) {
            mySpinnWheel.addWheel(params.wheels[w].degrees, params.wheels[w].defaultValue, true);
        }
        mySpinnWheel.open();
        $('#' + params.spinnWheelId).data('SpinnWheel', mySpinnWheel);
    }
    return this.getById(params.spinnWheelId);
}

SpinningWheel.getCurrentValueById = function (id) {
    return JSON.parse(sessionStorage.getItem(id));
}

function SpinningWheel(param) {
    this.id = param.id;
    this.isFloat = param.isFloat;
    this.friction = (param.friction === undefined) ? 0.003 : param.friction;
    this.slotData = [];
    this.enabled = param.enabled !== undefined ? param.enabled : true;
    this.wrapMode = this.enabled && ((param.wrap !== undefined) ? param.wrap : true);
    this.swWrapperId = this.id + '-sw-wrapper';
    this.swFrameId = this.id + '-sw-frame';
    this.swSlotsWrapperId = this.id + '-sw-slots-wrapper';
    this.swSlotsId = this.id + '-sw-slots';
    this.activeSlot = 0;
    this.isCalculateSlotsWidth = false;
    this.root = jQuery('#' + this.id);
    this.wrap = 0;
    this.wrapperElements = this.wrapMode ? 3 : 0;

    if (this.enabled) {

    this.onTouchStart = function(e) {
        this.startTouch = e.touches[0];
        this.swFrame.addEventListener('touchmove', this.TouchMoveStartHandler, false);
        return true;
    }

    this.onTouchMoveStart = function(e) {
        if (Math.abs(this.startTouch.clientX - e.changedTouches[0].clientX) > globals.general.moveStartThreshold) {
            this.swFrame.removeEventListener('touchmove', this.TouchMoveStartHandler, false);
        }
        if (Math.abs(this.startTouch.clientY - e.changedTouches[0].clientY) > globals.general.moveStartThreshold) {
            this.swFrame.removeEventListener('touchmove', this.TouchMoveStartHandler, false);
            if (e.currentTarget.id == this.swFrameId) {
                this.scrollStart(e);
            }
        }
    }

    this.onTouchMove = function(e) {
        this.lockScreen(e);
        if (e.currentTarget.id == this.swFrameId) {
            this.scrollMove(e);
        }
        return true;
    }

    this.onTouchEnd = function(e) {
        this.swFrame.removeEventListener('touchmove', this.TouchMoveStartHandler, false);
        if (e.currentTarget.id == this.swFrameId) {
            this.scrollEnd(e);
        }
        return true;
    }

    this.onWebkitTransitionEnd = function(e) {
        {
            this.scrollEnd(e);
        }
    }

    this.WebkitTransitionEndHandler = this.onWebkitTransitionEnd.bind(this);
    this.TouchStartHandler = this.onTouchStart.bind(this);
    this.TouchMoveStartHandler = this.onTouchMoveStart.bind(this);
    this.TouchMoveHandler = this.onTouchMove.bind(this);
    this.TouchEndHandler = this.onTouchEnd.bind(this);
}

/**
	 *
	 * Global events
	 *
	 */


    this.lockScreen = function (e) {
        e.preventDefault();
	    e.stopPropagation();
	};


	/**
	 *
	 * Initialization
	 *
	 */

	this.reset = function () {
		this.slotEl = [];

		this.activeSlot = 0;
		
		this.swWrapper = undefined;
		this.swSlotWrapper = undefined;
		this.swSlots = undefined;
		this.swFrame = undefined;
	};

	this.calculateSlotsWidth = function () {
	    if (this.isCalculateSlotsWidth) {
	        return;
	    }

	    this.isCalculateSlotsWidth = true;
		var td = this.swSlots.getElementsByTagName('td');
		for (var i = 0, j = 0; i < td.length; i++) {
		    if (td[i].className == 'floatingpoint') {
                continue;
		    }
		    this.slotEl[j++].slotWidth = td[i].offsetWidth;
		}
		this.offsetLeft = this.root.get(0).offsetLeft + this.swWrapper.offsetLeft + this.swSlotWrapper.offsetLeft + this.swSlots.offsetLeft;
	};

	this.create = function () {
		var i, l, out, ul, div;

		this.reset();	// Initialize object variables

		div = '<div id=' + this.swFrameId + ' class=sw-frame>';
		this.root.append(div);

		if (true&& this.isFloat) {
		    this.root.append('<div class="floatingpoint"></div>');
		}

		// Create the Spinning Wheel main wrapper
		div = document.createElement('div');
		div.id = this.swWrapperId;
		div.className = 'sw-wrapper';
		div.innerHTML = '<div id=' + this.swSlotsWrapperId + ' class="sw-slots-wrapper"><div id=' + this.swSlotsId + ' class="t1sg sw-slots"></div></div></div>';
		
		this.root.append(div);

		this.swWrapper = div;													// The SW wrapper
		this.swSlotWrapper = document.getElementById(this.swSlotsWrapperId);	// Slots visible area
		this.swSlots = document.getElementById(this.swSlotsId);					// Pseudo table element (inner wrapper)
		this.swFrame = document.getElementById(this.swFrameId);					// The scrolling controller
		var table = document.createElement('table');
		var tr = document.createElement('tr');
	    table.width = '100%';
		table.appendChild(tr);
	    this.swSlots.appendChild(table);
		// Create HTML slot elements
	    for (l = 0; l < this.slotData.length; l += 1) {
            if (this.wrapMode) {
                this.insertWrapElements(this.slotData[l]);
            }
			// Create the slot
			ul = document.createElement('ul');
			out = '';
			for (i in this.slotData[l].values) {
			    out += '<li>';
			    out += this.slotData[l].values[i];
			    out += '</li>';
			}
			ul.innerHTML = out;

			var td = document.createElement('td');		// Create slot container
			td.appendChild(ul);
		    tr.appendChild(td);
			// Append the slot to the wrapper
			//tr.appendChild(td);
			
			ul.slotPosition = l;			// Save the slot position inside the wrapper
			ul.slotYPosition = 0;
			ul.slotWidth = 0;
			this.cellHeight = parseInt(window.getComputedStyle(jQuery(this.swWrapper).find('.sw-slots li')[0]).height);
			this.offset = parseInt(jQuery(this.swWrapper).find('.sw-slots ul').css('top')) - this.wrapperElements * this.cellHeight;
	        this.lastEleOffset = (this.wrapMode ? this.wrapperElements - 2 : 0) * this.cellHeight;
            ul.slotMaxScroll = -(this.cellHeight * (this.slotData[l].count - 1));
			
			this.slotEl.push(ul);			// Save the slot for later use
		    
			// Place the slot to its default position
			var index = this.findIndexInSlot(l, this.slotData[l].defaultValue);
			this.scrollToIndex(l, index != -1 ? index : 0);
	    }
		
		// Add scrolling to the slots
	    this.swFrame.addEventListener('touchstart', this.TouchStartHandler, false);
	};

	this.insertWrapElements = function (slotData) {
	    var type = Object.prototype.toString.call(slotData.values);
	    if (type !== '[object Array]') {
	        throw new Error("Expected slot data array but was " + type);
	    }
	    var c = slotData.count;
	    slotData.count += 1;
        for (var i = 0; i < this.wrapperElements; i++) {
            slotData.values.push(slotData.values[i]);
        }
	    for (i = 0; i < this.wrapperElements; i++) {
	        slotData.values.unshift(slotData.values[c-1]);
	    }

    }

	this.open = function () {
		this.create();
	};
	
	/**
	 *
	 * Generic methods
	 *
	 */

	this.addWheel = function (values, defaultValue, isEnabled) {
		var count = 0;
		jQuery.each( values, function() {
			count ++;
		});
	    if (count > 0) {
	        var obj = { 'values': values, 'isEnabled': isEnabled, 'defaultValue': defaultValue, 'count': count };
	        this.slotData.push(obj);
	    }
	}

	this.getSelectedValues = function () {
        var wheels = [];
	    for (var i = 0; i < this.slotEl.length; i++) {
	        wheels.push(this.getSelectedValue(i));
	    }
	    return wheels;
	}

	this.getSelectedValue = function (slotNum) {
	    var index = -(this.slotEl[slotNum].slotYPosition - this.offset) / this.cellHeight;
        return { 'index': index, 'value': this.slotData[slotNum].values[index + this.wrapperElements] };
	};

	/**
	 *
	 * Rolling slots
	 *
	 */

	this.setPosition = function (slot, pos) {
	    pos = this.getWrappedPos(slot, pos);

		this.slotEl[slot].slotYPosition = pos;
		this.slotEl[slot].style.webkitTransform = 'translate3d(0, ' + pos + 'px, 0)';
	}

	this.getWrappedPos = function (slot, pos) {
	    if (this.wrapMode) {
	        pos = (pos - this.offset);
	        while (pos > 0) {
	            pos = pos + this.slotEl[slot].slotMaxScroll;
	        }
	        while (pos < this.slotEl[slot].slotMaxScroll) {
	            pos = pos - this.slotEl[slot].slotMaxScroll;
	        }
	        pos = pos + this.offset;
	    }
	    return pos;
	}

	this.findActiveSlot = function (e) {
        this.calculateSlotsWidth();

		var activeSlot = 0;
		// Find the clicked slot
		/* Warning: possible huge e.targetTouches[0].clientX prevent to pass through 'xPos < slot' */
		var xPos = e.targetTouches[0].clientX - this.offsetLeft;	// Clicked position minus left offset

		// Find tapped slot
		var slot = 0;
		for (var i = 0; i < this.slotEl.length; i ++) {
			slot += this.slotEl[i].slotWidth;
			activeSlot = i;
			if (xPos < slot) {
				break;
			}
		}
		return activeSlot;
	}
	this.scrollStart = function (e) {
	    this.activeSlot = this.findActiveSlot(e);

		// If slot is readonly do nothing
	    if (!this.slotData[this.activeSlot].isEnabled || (this.isFloat && this.isRistricted(this.activeSlot))) {
			this.swFrame.removeEventListener('touchmove', this.TouchMoveHandler, false);
			this.swFrame.removeEventListener('touchend', this.TouchEndHandler, false);
			return false;
		}

		this.slotEl[this.activeSlot].removeEventListener('webkitTransitionEnd', this.WebkitTransitionEndHandler, false);	// Remove transition event (if any)
		this.slotEl[this.activeSlot].style.webkitTransitionDuration = '0';		// Remove any residual transition
		
		// Stop and hold slot position
		var theTransform = window.getComputedStyle(this.slotEl[this.activeSlot]).webkitTransform;
		theTransform = new WebKitCSSMatrix(theTransform).m42;
		if (theTransform != this.slotEl[this.activeSlot].slotYPosition) {
			this.setPosition(this.activeSlot, theTransform);
		}
		
		this.startY = e.targetTouches[0].clientY;
		this.scrollStartY = this.slotEl[this.activeSlot].slotYPosition;
		this.scrollStartTime = e.timeStamp;

		this.swFrame.addEventListener('touchmove', this.TouchMoveHandler, false);
		this.swFrame.addEventListener('touchend', this.TouchEndHandler, false);
		
		return true;
	};

	this.scrollMove = function (e) {
		var topDelta = e.targetTouches[0].clientY - this.startY;

        if (this.wrapMode) {
            if ((this.slotEl[this.activeSlot].slotYPosition + topDelta - this.offset) > 0)
                this.wrap += 1;
            else if ((this.slotEl[this.activeSlot].slotYPosition + topDelta - this.offset) < this.slotEl[this.activeSlot].slotMaxScroll)
                this.wrap -= 1;
        } else if (this.slotEl[this.activeSlot].slotYPosition > 0 || this.slotEl[this.activeSlot].slotYPosition < this.slotEl[this.activeSlot].slotMaxScroll) {
			topDelta /= 2;
		}
		
		this.setPosition(this.activeSlot, this.slotEl[this.activeSlot].slotYPosition + topDelta);
		this.startY = e.targetTouches[0].clientY;
	}
	
	this.isRistricted = function(slotNum) {
	    if (slotNum > 0) {
	        if (this.getSelectedValue(slotNum - 1).index == this.slotData[slotNum - 1].count + (this.wrapMode ? - 2 : -1)) {
	            return true;
	        }
	    }
	    return false;
	}

	this.scrollEnd = function (e) {
		this.swFrame.removeEventListener('touchmove', this.TouchMoveHandler, false);
		this.swFrame.removeEventListener('touchend', this.TouchEndHandler, false);

		var destination;
		var currentPosition = this.slotEl[this.activeSlot].slotYPosition - this.offset;
		var scrollDuration = 100;
		
		if(currentPosition > 0 && !this.wrapMode){
			destination = 0;
		} else if (currentPosition < this.slotEl[this.activeSlot].slotMaxScroll && !this.wrapMode) {
   		    destination = this.slotEl[this.activeSlot].slotMaxScroll;
		}else{
			// Lame formula to calculate a fake deceleration
		    var scrollDistance = (this.slotEl[this.activeSlot].slotYPosition - this.scrollStartY);
		    scrollDistance = scrollDistance - this.wrap * this.slotEl[this.activeSlot].slotMaxScroll;
		    this.wrap = 0;
			// The drag session was too short or slow
			if (2*Math.abs(scrollDistance) < this.cellHeight) {
				destination = Math.round(currentPosition / this.cellHeight) * this.cellHeight;
			}else {
			    var scrollVector = Math.round((scrollDistance) / (e.timeStamp - this.scrollStartTime) / this.friction);
				scrollDuration = Math.abs(scrollVector);
				destination = Math.round((currentPosition+scrollVector) / this.cellHeight) * this.cellHeight;
				if (destination > 0 && !this.wrapMode) {
					destination = 0;
				} else if (destination < this.slotEl[this.activeSlot].slotMaxScroll && !this.wrapMode) {
					destination = this.slotEl[this.activeSlot].slotMaxScroll;
				}
			}			
		}

		if (this.isFloat) {
		    // Set decimal places to zero if maximum is reached 
		    if (destination == this.slotEl[this.activeSlot].slotMaxScroll + this.lastEleOffset) {
		        for (var i = this.activeSlot; i < this.slotEl.length; i++) {
		            this.scrollToIndex(i, 0, scrollDuration + 'ms');
		        }
		    }
		}
		
		this.scrollTo(this.activeSlot, destination, scrollDuration + 'ms');
	};

	this.scrollTo = function (slotNum, dest, runtime) {
	    if (isNaN(dest)) {
	        return;
	    }

	    var self = this;
	    var currentPos = window.getComputedStyle(this.slotEl[slotNum]).webkitTransform;
	    currentPos = new WebKitCSSMatrix(currentPos).m42;

        // start jquery nimation
	    $({ scroll: currentPos ? currentPos : 0 }).animate({ scroll: (dest ? dest : 0) + this.offset }, {
	        duration: runtime !== undefined ? runtime : 100,
	        easing: $.bez([0, 0, 0.2, 1]),
	        step: function (currentTop) {
	            var animationPos = self.getWrappedPos(slotNum, currentTop);
	            self.slotEl[slotNum].style.webkitTransform = 'translate3d(0, ' + animationPos + 'px, 0)';
	        }
	    });

        // Set final position and selected value immedeiatly to prevent usage of animation step values
	    var pos = this.getWrappedPos(slotNum, (dest ? dest : 0) + this.offset);
	    this.slotEl[slotNum].slotYPosition = pos;
	    sessionStorage.setItem(this.id, JSON.stringify(this.getSelectedValues()));
	};
	
	this.scrollToIndex = function (slotNum, index, runtime) {
	    if (0 <= index && index < this.slotData[slotNum].count) {
	        this.scrollTo(slotNum, -(index * this.cellHeight), runtime);
		}
	};

	this.scrollToValue = function (slotNum, value, runtime) {
		this.scrollToIndex(slotNum, this.findIndexInSlot(slotNum, value), runtime);
	};	
	
	this.findIndexInSlot = function (slotNum, value) {
	    for (var i = this.wrapperElements; i < this.slotData[slotNum].count + this.wrapperElements; i++) {
			if (this.slotData[slotNum].values[i] == value) {
				return i - this.wrapperElements;
			}
		}
		return -1;
	};
};