﻿tsx.ValueTransmitter = (function (detailId, dataset) {

    var statusValueEnabled = dataset.statusValueEnabled === 'true';
    var unitEnabled = dataset.unitEnabled === 'true';
    var valueIncrementEnabled = dataset.valueIncrementEnabled === 'true';
    var scalingInfo = dataset.scalingInfo === 'true';

    var minScalingInfo = parseInt(dataset.scalingInfoMin);
    var maxScalingInfo = parseInt(dataset.scalingInfoMax);

    var suffix = '-' + dataset.containerIndex + '-' + dataset.channelIndex;
    var statusValueId = 'detail' + suffix + '_statusValue';
    var spinnWheelId = 'spinnWheel' + suffix;
    var precision = parseInt(dataset.precision);
    var okBtn = $('#' + spinnWheelId + '_OkBtn');

    var slotNum = 0;
    var lowest, highest, lowestValue;
    var isFloat = precision > 0;

    determineMinMaxValue();
        
    var degreesInt = new Array();
    var degreesDec = new Array();
    if (valueIncrementEnabled) {
        generateWheelValues();
    } else {
        degreesInt[0] = formatNum(dataset.basisValue);
        if (isFloat) {
            degreesDec[0] = getDecAsInt(dataset.basisValue).toString();
        }
    }

    var currentValue = SpinningWheel.getCurrentValueById(spinnWheelId);
    var wheels = [{ 'degrees': degreesInt, 'defaultValue': formatNum((currentValue != null && currentValue.length > 0 && !isNaN(currentValue[0].value)) ? currentValue[0].value : dataset.basisValue) },
                { 'degrees': degreesDec, 'defaultValue': (currentValue != null && currentValue.length > 1 && !isNaN(currentValue[1].value)) ? currentValue[1].value : getDecAsInt(dataset.basisValue) }];

    var spinnWheel = SpinningWheel.create({ 'spinnWheelId': spinnWheelId, 'isFloat': isFloat, 'wheels': wheels, 'enabled': valueIncrementEnabled });

    registerOkButton();

    if (statusValueEnabled) {
        registerStatusCaseSet();
    }

    /**
    * Generates arrays with the all possible values of the spinningwheels based on the confiuguration
    */
    function generateWheelValues() {
        var inc = parseInt(Math.max(1, parseFloat(dataset.valueIncrement)));

        // Add min value
        degreesInt[0] = formatNum(lowest);

        // Adapt first step if basis value is not reached with the selected value increment
        if (Math.abs((dataset.basisValue - lowest) % dataset.valueIncrement) !== 0) {
            lowestValue = lowest + Math.abs((lowest - dataset.basisValue) % dataset.valueIncrement);
        } else {
            lowestValue = lowest + parseInt(dataset.valueIncrement);
        }

        // Fill values between min and max
        for (var i = 1, v = lowestValue; v < highest; v += inc) {
            var num = formatNum(v);
            if (i > 0 && degreesInt[i - 1] === num) {
                continue;
            } else {
                degreesInt[i++] = num;
            }
        }
        // Add max value
        degreesInt[degreesInt.length] = highest;

        //
        if (isFloat) {
            inc = getDecAsInt(dataset.valueIncrement);
            if (inc === 0) {
                degreesDec[0] = 0;
            } else {
                for (var j = 0, w = 0; w <= 9; w += inc) {
                    degreesDec[j++] = w.toString();
                }
            }
        }
    }

    /**
    * Determines the min and max value based on the configuration
    */
    function determineMinMaxValue() {
        if (scalingInfo) {
            if (!isNaN(minScalingInfo)) {
                lowest = minScalingInfo;
            }
            if (!isNaN(maxScalingInfo)) {
                highest = maxScalingInfo;
            }
        } else {
            switch (dataset.type) {
                case 'de.gira.schema.datapoints.Temperature':
                    lowest = parseFloat(0);
                    highest = parseFloat(40);
                    break;
                case 'de.gira.schema.datapoints.Percent':
                    lowest = 0;
                    highest = 100;
                    break;
                case 'de.gira.schema.datapoints.SCount':
                    lowest = -128;
                    highest = 127;
                    break;
                case 'de.gira.schema.datapoints.UCount':
                case 'de.gira.schema.datapoints.Percent255':
                default:
                    lowest = 0;
                    highest = 255;
                    break;
            }
        }
    }

    /**
    * Registers events for the ok button in order to transmit the selected value
    */
    function registerOkButton() {
        registerEventsForPressButton(okBtn,
        function () { okBtn.addClass('down'); },
        function () { okBtn.removeClass('down'); },
        function () {
            var value = spinnWheel.getSelectedValues()[slotNum].value;
            if (isFloat) {
                value += '.' + spinnWheel.getSelectedValues()[slotNum + 1].value;
            }
            ComClient.sendTagValue(dataset.transmitId, isFloat ? parseFloat(value) : parseInt(value));
        });
    }

    /**
    * Register CaseSet for status value and set functions on receive
    */
    function registerStatusCaseSet() {
        temporaryCaseSets.push(new CaseSet(dataset.statusId, CaseSetType.VALUE)
           .setOnValueFunction(function (value) {
               if (isNaN(parseInt(value))) {
                   value = '-';
                   $('#' + statusValueId).text(value + (unitEnabled ? ' ' + dataset.unitValue : ''));
               }
               else {
                   value = Round(value, isFloat ? precision : 0);
                   $('#' + statusValueId).text((Round(value, isFloat ? precision : 0)) + (unitEnabled ? ' ' + dataset.unitValue : ''));
               }
           }));
    }

    /**
    * Returns the decimal places of a number as integer
    */
    function getDecAsInt(num) {
        var slices = (num + '').split('.');
        return parseInt(isNaN(slices[1]) ? 0 : slices[1]);
    };

    /**
    * Adds leading zeros to a value to match the length of the max value
    */
    function formatNum (i) {
        var absi = Math.abs(parseInt(i));
        return (i < 0 ? '-' : '') + '00'.substr(0, (absi < 100 && highest >= 100) + (absi < 10 && highest >= 10)) + absi;
    };
});