/**
 * Saves the HTTP Get Parameters
 */
function saveHTTPGetParameters()
{
    var httpGetVars = {};
    var strGet = document.location.search.substr(1, document.location.search.length);
    if (strGet !== '')
    {
        var gArr = strGet.split('&');
        for (var i = 0; i < gArr.length; ++i)
        {
            var v = '';
            var vArr = gArr[i].split('=');
            if (vArr.length > 1) {
                v = vArr[1];
            }
            httpGetVars[unescape(vArr[0])] = unescape(v);
        }
    }
    return httpGetVars;
}

/**
 * Gets the saved HTTP Get Parameters
 * 
 * @param {string} param 
 *          The parameter you want to get
 * @return {string}
 *          Returns the parameter value
 */
function getHTTPGetParameters(param) {
    if (this.httpGetVars === null || this.httpGetVars === undefined) {
        this.httpGetVars = saveHTTPGetParameters();
    }

    if (!this.httpGetVars[param]) {
        return 'undefined';
    }
    return this.httpGetVars[param];
}