/*
 * switches the tile between small and large
 * @param {string} tileId
 *			the tileID of the selected tile
 */
function tileSwitcher(tileId)
{
    var tile = $("#" + tileId);
    var tileGridLine = tile.find(">.grid-line");
    var tileDescBox = tile.find(">.tile-description-box");

    if (tile.is(".tile-small, .tile-large")) {
        tile.toggleClass("tile-small");
        tile.toggleClass("tile-large");
    }

    if (tileGridLine.is(".grid-line-small, .grid-line-large")) {
        tileGridLine.toggleClass("grid-line-small");
        tileGridLine.toggleClass("grid-line-large");
    }

    if (tileDescBox.is(".tile-description-box-small, .tile-description-box-large")) {
        tileDescBox.toggleClass("tile-description-box-small");
        tileDescBox.toggleClass("tile-description-box-large");
    }
};

/*
 * changes the tileSize and hide/show the neighbor tile
 * use the tileSwitcher for the size
 *
 * @param {string} tileId
 *			the tileID of the selected tile
 */
function changeTileSize(tileId)
{
    // TODO: broken semantic; 'neighborId' won't be assigned since id could become '-0'!
    var n = tileId.lastIndexOf("e");
    var id = tileId.substring(n + 1, tileId.length);
    id = parseInt(id);
    var idName = tileId.substring(0, n + 1);
    var neighborId;
    if (id % 2 === 1)
    {
        neighborId = id + 1;
    }
    else if (id % 2 === 0)
    {
        neighborId = id - 1;
    }

    var neighborName = idName + neighborId;

    if ($('#tile-' + id).hasClass('tile-small'))
    {
        $('#' + neighborName).hide();
        tileSwitcher('tile-' + id);
    }
    else if ($('#tile-' + id).hasClass('tile-large'))
    {
        $('#' + neighborName).show();
        tileSwitcher('tile-' + id);
    }
};

/*
 * changes classes when the tile is touchdown or mousedown
 * to change the colors and images
 *
 * @param {string} tile
 *			the tile name of the selected tile
 */
function onTileDown(tile)
{
    if(!tile.hasClass('tile-down')) {
      tile.addClass('tile-down');
      tile.find('.tile-flow-top').css('visibility', 'visible');
      tile.find('.grid-line').addClass('grid-line-down');
      tile.find('.tile-description-box > .tile-description-box-text > .tile-description-text').removeClass('t2sg').addClass('t2ws');
      tile.find('.tile-description-box > .tile-description-box-text > .tile-description-room').removeClass('t2gg').addClass('t2ws');
      tile.find('.tile-status-text').removeClass('t2gg').addClass('t2ws');
      tile.find('.tile-function-folder-text').removeClass('t2gg').addClass('t2ws');
      tile.find('.container-content-count').addClass('down-state');

      if (tile.find('.element-box > .onoffswitch') !== undefined) {
          tile.find('.element-box > .onoffswitch > .onoffswitch-label > .onoffswitch-switch').addClass('button-left-down');
          tile.find('.element-box > .onoffswitch > .onoffswitch-label > .onoffswitch-mask').addClass('onoffswitch-mask-down');
      }
	  	  
      var rtrTileSymbol = tile.find('.RTR_tile_symbol');
      if (rtrTileSymbol.length > 0) {
          spriteDown(rtrTileSymbol[0]);
          spriteDown(rtrTileSymbol[1]);
      }

      var tileIcon = tile.find('.tile-icon');
      if (tileIcon.length > 0) { 
          spriteDown(tileIcon[0]);
      }
      var tileLed = tile.find('.tile-status-led >.sprites, .tile-status-led');
      if (tileLed.length > 0) {
          for (var i = 0; i < tileLed.length; i++) {
          spriteDown(tileLed[i]);
		  }
      }

      var tileArrow = tile.find('.tile-description-box >.container-arrow');
      if (tileArrow.length > 0) {
          spriteDown(tileArrow[0]);
      }

      var tileButtons = tile.find('.element-box >.buttongroup');
      if (tileButtons.length > 0) {
          tileButtons.find('.button-left').addClass('button-left-down');
          tileButtons.find('.button-right').addClass('button-right-down');
      }

      var tileTriggerButton = tile.find('.element-box > .trigger-button > .tile-trigger-button');
      if (tileTriggerButton.length > 0) {
          tileTriggerButton.addClass('button-left-down');
      }

    }
  };

  /*
   * changes classes when the tile is touchup or mouseup
   * to change the colors and images
   *
   * @param {string} tile
   *			the tile name of the selected tile
   */
  function onTileUp(tile) {
      if(tile.hasClass('tile-down')) {
          var tileIcon = tile.find('.tile-icon');
          if (tileIcon.length > 0) {
              spriteUp(tileIcon[0]);
          }
          var tileLed = tile.find('.tile-status-led >.sprites, .tile-status-led');
          if (tileLed.length > 0) {
              for (var i = 0; i < tileLed.length; i++) {
              spriteUp(tileLed[i]);
			  }
          }

          var tileArrow = tile.find('.container-arrow');
          if (tileArrow.length > 0) {
              spriteUp(tileArrow[0]);
          }
          
          var tileButtons = tile.find('.element-box >.buttongroup');
          if (tileButtons.length > 0) {
              tileButtons.find('.button-left').removeClass('button-left-down');
              tileButtons.find('.button-right').removeClass('button-right-down');
          }

          var tileTriggerButton = tile.find('.element-box > .trigger-button > .tile-trigger-button');
          if (tileTriggerButton.length > 0) {
              tileTriggerButton.removeClass('button-left-down');
          }
          

          tile.removeClass('tile-down');
          tile.find('.tile-flow-top').css('visibility', 'hidden');
          tile.find('.grid-line').removeClass('grid-line-down');
          tile.find('.tile-description-box > .tile-description-box-text > .tile-description-text').removeClass('t2ws').addClass('t2sg');
          tile.find('.tile-description-box > .tile-description-box-text > .tile-description-room').removeClass('t2ws').addClass('t2gg');
          tile.find(' >.tile-status-text').removeClass('t2ws').addClass('t2gg');
          tile.find(' >.tile-function-folder-text').removeClass('t2ws').addClass('t2gg');
          tile.find(' >.container-content-count').removeClass('down-state');
          
          if (tile.find('.element-box > .onoffswitch') !== undefined) {
              tile.find('.element-box > .onoffswitch > .onoffswitch-label > .onoffswitch-switch').removeClass('button-left-down');
              tile.find('.element-box > .onoffswitch > .onoffswitch-label > .onoffswitch-mask').removeClass('onoffswitch-mask-down');
          }
      }
  };

/*
 * mouse and touch events on the tile
 *
 * @param {string} tile
 *			the tile name of the selected tile
 */
function eventsOnTile(tile)
{
    var tileJQuery = $('#' + tile);

    registerEventsForSwipeableElement(tileJQuery,
        function () {
            onTileDown(tileJQuery);
        },
        function () {
            onTileUp(tileJQuery);
        },
        function () {
            tileJQuery.trigger('tileAction');
        }
    );

    var elementBoxJquery = tileJQuery.find('.element-box');
    var elementBoxElement = elementBoxJquery[0];
    
    elementBoxJquery.mousedown(function (e) {
        var swiperEvent = document.createEvent('MouseEvent');
        swiperEvent.initMouseEvent(e.type, e.bubbles, e.cancelable, window, e.detail,
			e.screenX, e.screenY, e.clientX, e.clientY, e.ctrlKey, e.altKey, e.shiftKey,
			e.metaKey, e.button, e.relatedTarget);
        tileJQuery.parent()[0].dispatchEvent(swiperEvent);
        e.stopPropagation();
    });

    elementBoxElement.ontouchstart = function (e) {
        var swiperEvent = document.createEvent('TouchEvent');
        swiperEvent.initTouchEvent(e.touches, e.targetTouches, e.changedTouches, e.type, e.bubbles, e.cancelable, window, e.detail,
			e.screenX, e.screenY, e.clientX, e.clientY, e.ctrlKey, e.altKey, e.shiftKey,
			e.metaKey, e.button, e.relatedTarget);
        tileJQuery.parent()[0].dispatchEvent(swiperEvent);
        e.stopPropagation();
    };
};

/*
 * loads the content of an html/xhtml file and paste this in the right DOM element
 *
 * @param {string} file
 *			the file name of loaded html/xhtml
 * @param {string} destId
 *			the id where the content of the loaded file is pasted in
 */
function loadTileFromFile(file, destId)
{
     $.ajax({
        url: file,
        data: {},
        cache: false,
        async: false,
        success: function(data) {

        //d = $(data).filter(".tile");      
        $(destId).html(data);

        },
        dataType: 'html'
    });   
};

/*
 * loads the content of an html/xhtml file and paste this in the right tile container
 *
 * @param {string} file
 *			the file name of loaded html/xhtml
 * @param {string} containerId
 *			the id where the content of the laoded file is pasted in
 * @param {string} tileId
 *			the id of the tile
 */
function loadContainerTileFromFile(file, containerId, tileId)
{
    var container = document.getElementById('slide-container-' + containerId);
    var containerTiles = container.getElementsByClassName('tile-container');
    $.ajax({
        url: file,
        data: {},
        cache: false,
        async: false,
        success: function(data) {            
        $(containerTiles[tileId]).html(data);
        },
        dataType: 'html'
    });
};

/**
 * Registers a caseset to change the statues text according to the current value of the 
 * valueStatusDatapoint.
 *
 * @param {string} statusDatapoint
 *			Datapoint to listen for status changes
 * @param {string} onText
 *			Text to dispolay in on state
 * @param {string} offText
 *			Text to dispolay in off state 
 * @param {string} tileId
 *			Id of the tile
 */
function registerStatusTextCaseSet(statusDatapoint, onText, offText, tileId) {
    temporaryCaseSets.push(new CaseSet(statusDatapoint, CaseSetType.CONTENT)
          .addCase(new Case().setExpectedValue(1).setNewValue(onText))
          .addCase(new Case().setExpectedValue(0).setNewValue(offText))
          .setOnValueFunction(function (value) {
              if ( !isValidString(value) ) {
                  value = "- - -";
              }
              changeText(new Array(tileId, 'tile-status-text'), value);
          })
     );  
}

/**
 * Registers a caseset to change the statues text according to the current value of the 
 * valueStatusDatapoint.
 *
 * @param {string} valueStatusDatapoint
 *			Datapoint to listen for status changes
 * @param {string} tileId
 *			Id of the tile
 */
function registerStatusValueCaseSet(valueStatusDatapoint, tileId) {
    temporaryCaseSets.push(new CaseSet(valueStatusDatapoint, CaseSetType.VALUE)
        .setOnValueFunction(function (value) {
            var valInt = Round(value, 0);

            if(!isValidValue(valInt) || value === "" ) {
                valInt = '-';
            }
            changeText(new Array(tileId, 'tile-status-text'), valInt + ' %');
        })
    );
}

/**
 * Registers a caseset to change the statues text according to the current value of the 
 * valueStatusDatapoint.
 *
 * @param {string} valueStatusDatapoint
 *			Datapoint to listen for status changes
 * @param {string} tileId
 *			Id of the tile
 */
function registerStatusTemplateValueCaseSet(valueStatusDatapoint, tileId, valueUnit, roundValue) {
    temporaryCaseSets.push(new CaseSet(valueStatusDatapoint, CaseSetType.VALUE)
        .setOnValueFunction(function (value) {
            if (roundValue) {
                if (!isValidValue(value)) {
                    value = "- - -";
                } else {
                    value = Math.round(parseFloat(value));
                }
            } else if (!isValidString(value)) {
                value = "- - -";
            }

            value = value + ' ' + valueUnit;

            changeText(new Array(tileId, 'tile-status-text'), value);
        })
    );
}

/*
 * Registers a caseset to toggle the LED icon on status changes.
 *
 * @param {string} statusDatapoint
 *			Datapoint to listen for status changes
 * @param {string} on
 *			On state Led CSS class 
 * @param {string} off
 *			Off state Led CSS class 
 * @param {string} tileId
 *			Id of the tile
 */
function registerLedCaseSet(statusDatapoint, on, off, tileId) {
    temporaryCaseSets.push(new CaseSet(statusDatapoint, CaseSetType.CONTENT)
        .addCase(new Case().setExpectedValue(1).setNewValue(on))
        .addCase(new Case().setExpectedValue(0).setNewValue(off))
        .setOnValueFunction(function (value) {
            if (!isValidString(value) ) {
                value = off;
            }
            changeSpriteClass(new Array(tileId, 'tile-description-box', 'tile-status-led'), value, false);
        })
    );
}

/**
 * Registers events for the toggle switch button including the animationless initialization when the
 * according view is loaded
 *
 * @param {string} statusDatapoint
 *			Datapoint to listen for status changes
 * @param {string} onoffswitchId
 *			Id of the toggle switch button
 * @param {string} tileId
 *			Id of the trigger tile
 * @param {string} switchDatapoint
 *			Datapoint to send switch values
 */
function registerToggleSwitchButton(statusDatapoint, onoffswitchId, tileId, switchDatapoint) {
    var onoffswitch = $('#' + tileId + ' .onoffswitch');
    toggleSwitchButton(onoffswitch, tileId, switchDatapoint);
    temporaryCaseSets.push(new CaseSet(statusDatapoint, CaseSetType.CONTENT)
    .addCase(new Case().setExpectedValue(1).setNewValue(true))
    .addCase(new Case().setExpectedValue(0).setNewValue(false))
    .setOnValueFunction(function (value) {
        if (!isValidValue(value) ){
            value = false;
        }
        changeToggleSwitchButtonState(onoffswitchId, value);
    })
    );
    $('#' + tileId).on('init', function () {
        onoffswitch.addClass('transitions-disabled');
        changeToggleSwitchButtonState(onoffswitchId, parseInt(ComClient.getTagValue(statusDatapoint), 10));
        setTimeout(function () {
            $(onoffswitch).removeClass('transitions-disabled');
        }, 0);
    });
}

/**
 * Registers events for the tile trigger button
 *
 * @param {string} switchDatapoint
 *			Datapoint to send trigger values
 * @param {string} triggerButtonId
 *			Id of the trigger button
 * @param {string} tileId
 *			Id of the value trigger tile
 */
function registerTriggerButton(switchDatapoint, triggerButtonId, tileId) {
    var button = $('#' + triggerButtonId);
    registerEventsForTilePressButton(
        tileId,
        button,
        function() {
            button.attr('onclick', '').unbind('click');

            ComClient.sendTagValue(switchDatapoint, 1);
        });
}

/**
 * Registers events for the tile value trigger button
 *
 * @param {string} switchDatapoint
 *			Datapoint to send trigger values
 * @param {string} triggerButtonId
 *			Id of the trigger button
 * @param {string} tileId
 *			Id of the value trigger tile
 * @param {boolean} scalingInfo
 *          if true parseFloat, otherwise parseInt
 */
function registerValueTriggerButton(switchDatapoint, triggerButtonId, tileId, scalingInfo, basisValue) {
    var button = $('#' + triggerButtonId);
    registerEventsForTilePressButton(
        tileId,
        button,
        function() {
            var value = $('#' + tileId).data('currentSpinValue');
            if (scalingInfo) {
                value = parseFloat(value);
            } else {
                value = parseInt(value);
            }
            if (isValidValue(value)) {
                ComClient.sendTagValue(switchDatapoint, value);
            }
            else if (isValidValue(basisValue)) {
                //fallback if no value is set in the valuetransmitter aka slotmachine aka spinningwheel
                ComClient.sendTagValue(switchDatapoint, basisValue);
            }
        });
}

/**
 * Registers the callback to set the send value of the value transmitter tile based on the value
 * of the according detail view.
 *
 * @param {string} tileId
 *			Id of the value transmitter tile
 * @param {string} spinningWheelId
 *			Id of the detail value transmitter spinning wheel
 * @param {string} showUnits
 *			Value unit
 * @param {bool} showUnitsTrue
 *			Flag to enable value unit display
 * @param {bool} showStatusValue
 *			Flag to enabale status value display
 */
function registerValueTransmitter(tileId, spinningWheelId, showUnits, showUnitsTrue) {
    $('#' + tileId).on('loadTile', function () {
        var value = '-';
        
        var currentSpinValue = SpinningWheel.getCurrentValueById(spinningWheelId);
        if (currentSpinValue != null) {
            $('#' + tileId).data('currentSpinValue', currentSpinValue[0].value);            


                if (currentSpinValue.length == 2) {
                    value = currentSpinValue[0].value + '.' + currentSpinValue[1].value;
                    if (value === "." || !isValidValue(currentSpinValue[0].value) || !isValidValue(currentSpinValue[1].value))
                        value = '-';

                } else {
                    value = Number(currentSpinValue[0].value);
                    if (!isValidValue(value))
                        value = '-';

                }

                if (showUnitsTrue) {
                    value = value + ' ' + showUnits;
                }

                $('#' + tileId + ' >.tile-status-text').text(value);

        }
    });
}

/*
 * Adds event listener to the on/off buttons for switches in tile view (I/O)
 *
 * @param {string} tileId
 *		    ID of the tile
 * @param {string} tagId
 *			tag ID of the switch 
 * @param {string} onButton
 *			the ON-Button
 * @param {string} offButton
 *			the OFF-Button
 */
function initOnOffTileButtons(tileId, tagId, onButton, offButton) {
    registerEventsForTilePressButton(
        tileId,
        onButton,
        function () {
            //clicked
            ComClient.sendTagValue(tagId, 1);
        });

    registerEventsForTilePressButton(
        tileId,
        offButton,
        function () {
            //clicked
            ComClient.sendTagValue(tagId, 0);
        });
}

/*
 * Helper function for event handling on tile buttons
 *
 * @param {string} tileId
 *		    ID of the tile
 * @param {object} button
 *			button object 
 * @param {function} clickFunction (optional)
 *			callback which will be executed onclick
 * @param {function} downFunction (optional)
 *			callback which will be on touch down
 * @param {function} upFunction (optional)
 *			callback which will be on touch up
 */
function registerEventsForTilePressButton(tileId, button, clickFunction, downFunction, upFunction) {;
    var buttonFg = button.find('.sliderbutton-fg');
    var buttonBg = button.find('.sliderbutton-bg');

    //necessary due tue slightly different button implementations
    if (button.hasClass('sliderbutton-bg')) {
        buttonBg = button;
    }

    var buttonLabel = button.find('> .tile-trigger-button > .sliderbutton-label')[0];

    if (typeof clickFunction === 'undefined') {
        clickFunction = function() {};
    }

    if (typeof downFunction === 'undefined') {
        downFunction = function() {
            onControlDownChangeTileBackground(tileId);
            buttonBg.addClass('sliderbutton-bg-down');
            buttonFg.addClass('sliderbutton-fg-down');
            spriteDown(buttonLabel);
        };
    }

    if (typeof upFunction === 'undefined') {
        upFunction = function() {
            onControlReleaseChangeTileBackground(tileId);
            buttonBg.removeClass('sliderbutton-bg-down');
            buttonFg.removeClass('sliderbutton-fg-down');
            spriteUp(buttonLabel);
        };
    }
    registerEventsForPressButton(
        button,
        downFunction,
        upFunction,
        clickFunction
    );

}