/**
 * Changes text of the element specified by cssPath to specified value including 
 * text translation to the according localization settings
 * 
 * @param {array} cssPath 
 *          DOM path of the element
 * @param {string} value
 *          text value of the element
 */
function changeText(cssPath, value) {
    var parent = _findElement(cssPath);
    parent.text(value);
};


/**
 * Resolves element specified by cssPath
 * 
 * @param {array} cssPath 
 *          DOM path of the element
 * @returns {dom-element} element 
 *          the requested element or 'undefined'
 */
function _findElement(cssPath) {
    var id = cssPath[0];
    var length = cssPath.length;

    element = $('#' + id);

    for (var i = 1; i < length; i++) {
        element = element.find('.' + cssPath[i]);
    }
    return element;
}
;

function changeSpriteClass(cssPath, value, isNineSliced) {
    isNineSliced = typeof isNineSliced !== 'undefined' ? isNineSliced : false;
    var parent = _findElement(cssPath);
    var parentClass = parent.attr("class");
    if (parentClass.indexOf('sprites') == -1 && !isNineSliced) {
         parentClass = parentClass + " sprites";
    }
    if (parentClass.indexOf('sprite_') != -1) {
        parentClass = parentClass.replace(/sprite_\S*\s?/g, value);
    } else {
         parentClass = parentClass + " " + value;
    }
    parent.prop("class", parentClass);
};

