﻿/**
 * Registers a caseset to toggle the LED icon on status changes.
 *
 * @param {string} statusDatapoint
 *			Datapoint to listen for status changes
 * @param {string} on
 *			On state Led CSS class 
 * @param {string} off
 *			Off state Led CSS class 
 * @param {string} tileId
 *			Id of the tile
 * @param {string] pathToLedDiv 
            dom tree path to LED div
 */
function registerLedCaseSetOnCustomView(statusDatapoint, on, off, pathToLedDiv) {
    temporaryCaseSets.push(new CaseSet(statusDatapoint, CaseSetType.CONTENT)
        .addCase(new Case().setExpectedValue(1).setNewValue(on))
        .addCase(new Case().setExpectedValue(0).setNewValue(off))
        .setOnValueFunction(function (value) {
            if (!isValidString(value)) {
                value = off;
            }
            changeSpriteClass(pathToLedDiv, value, false);
        })
    );
}


/**
 * Registers a caseset to show the status value
 *
 * @param {string} statusValueDatapoint
 *			Datapoint to listen for status changes 
 * @param {string} statusValueCssPath
 *			css path where the status text is shown
 * @param {boolean} round
 *          round the received value
 */
function registerDetailStatusValueCaseSet(statusValueDatapoint, statusValueCssPath, roundValue) {
    temporaryCaseSets.push(new CaseSet(statusValueDatapoint, CaseSetType.VALUE)
        .setOnValueFunction(function (value) {
            if (roundValue)
            {
                if (!isValidValue(value))
                {
                    value = "- - -";
                }
                else
                if (roundValue)
                {
                    value = Math.round(parseFloat(value));
                    if( !isValidValue(value) )
                    {
                        value = "- - -";
                    }

                }
            }
            else
            if (!isValidString(value)  )
            {
                value = "- - -";
            }

            changeText(statusValueCssPath, value);
        })
    );
}

/**
 * Registers a caseset to show the status value using predefined texts for ON/OFF state
 *
 * @param {string} statusValueDatapoint
 *			Datapoint to listen for status changes 
 * @param {string} onText
 *			text used for ON state
 * @param {string} offText
 *			text used for OFF state
 * @param {string} statusValueCssPath
 *			css path where the status text is shown
 */
function registerDetailStatusOnOffCaseSet(statusValueDatapoint, onText, offText, statusValueCssPath) {
    temporaryCaseSets.push(new CaseSet(statusValueDatapoint, CaseSetType.CONTENT)
          .addCase(new Case().setExpectedValue(1).setNewValue(onText))
          .addCase(new Case().setExpectedValue(0).setNewValue(offText))
          .setOnValueFunction(function (value) {
              if (!isValidString(value)) {
                  value = '- - -';
              }
              changeText(statusValueCssPath, value);
          })
    );
}


