/*jslint browser: true*/
/*global ko, $*/

(function (ns) {
    "use strict";

    function Cameras(saveCallbackFunc, config) {
        var saveCallback = saveCallbackFunc,
            Messages = window.Gira.DCS.Messages,
            isVisible = ko.observable(false),
            cameraList = ko.observableArray();

        return {
            cameraList : cameraList,
            init: function (menuObj) {
                cameraList.removeAll();
                menuObj.forEach(function (camera) {
                    cameraList.push(camera);
                });
            },
            getPersistedData: function () {
                return {};
            },
            select: function (e) {
                saveCallback([Messages.setMenuValue.showCamera(e.key, e.value)], false);
            },
            isVisible: isVisible,
            label: config.label
        };
    }
    ns.Cameras = Cameras;
}(window.Gira.DCS));

//@ sourceURL=dcs.settings.cameras.js