#/bin/sh

SD_CARD_LOCATION=/opt/card
SD_CARD_DEMO_MODE_BASE_DIR=gira/demo

DEMO_MODE_ACTIVATION_FLAG=$SD_CARD_LOCATION/$SD_CARD_DEMO_MODE_BASE_DIR/demo.sales
DEMO_MODE_ACTIVATED_FLAG=$SD_CARD_LOCATION/$SD_CARD_DEMO_MODE_BASE_DIR/demo.sales.activated

GIRA_APP_CONFIGURATION_FILE=/opt/userdata/generator-configuration

DEMO_MODE_CONFIGURATION_SRC_FILE=/opt/gira/demo/sales/configFile.xml
DEMO_MODE_CONFIGURATION_DEST_FILE=/opt/userdata/demomode-configuration

SVP_GENERATOR="/usr/bin/mono /opt/gapp-generator/tsx/svp/de.gira.app.tastsensorX.preprocessors.svp.exe"
SVP_GAPP_INPUT_FILE=/opt/userdata/gapp-generator/tsx/gapinput
DEMO_MODE_KNX_PRJ_DIR=/opt/gira/demo/sales
DEMO_MODE_KNX_PRJ_FILE=EtsDemoMode.xml
DEMO_MODE_KNX_PRJ=$DEMO_MODE_KNX_PRJ_DIR/$DEMO_MODE_KNX_PRJ_FILE

GAP_GENERATOR="/usr/bin/mono /opt/gapp-generator/tsx/gap/de.gira.app.tastsensorX.preprocessors.gap.exe"
DEMO_MODE_GAPP_BASE_DEST_DIR=/opt/userdata/demo
DEMO_MODE_GAPP_DEST_DIR=$DEMO_MODE_GAPP_BASE_DEST_DIR/sales/gapp/

DEMO_MODE_DEVICE_DEFINITION_FILE=ctrl4_device_demo.xml

#
# G1 RTR DevicePackages > 1.2.53.0 have the watchdog activated.
# As the below performed generation takes much longer than the watchdog timeout time
# the watchdog needs to be handled here.
# We expect a reliable system when we use the demonstration mode so simply
# reload the kernel module here with nowayout=0 option to let the kernel feed the dog.
# There is a reboot at the end of this functions so we do not need to reload the module
# with nowayout=1 again.
#
do_generate() {

	rmmod imx2_wdt
	sleep 1
	modprobe imx2_wdt nowayout=0

	CURRENT_LANGUAGE=$(cat $GIRA_APP_CONFIGURATION_FILE | cut -d , -f 4 | sed -e 's/}//g')
	if [ "$CURRENT_LANGUAGE" != "" ]
	then
		echo "current language $CURRENT_LANGUAGE"
	else
		echo "current language empty, set to default"
		CURRENT_LANGUAGE='"selectedLanguage":"de"'
	fi
	CURRENT_LANGUAGE_EXT=$(echo $CURRENT_LANGUAGE | cut -d : -f 2 | sed -e 's/"//g' -e 's/}//g')
	DEMO_MODE_LANGUAGE=$(cat $DEMO_MODE_CONFIGURATION_SRC_FILE | cut -d , -f 4 | sed -e 's/}//g')
	DEMO_MODE_CONFIGURATION=$(cat $DEMO_MODE_CONFIGURATION_SRC_FILE | sed -e "s@$DEMO_MODE_LANGUAGE@$CURRENT_LANGUAGE@")
	echo $DEMO_MODE_CONFIGURATION > $DEMO_MODE_CONFIGURATION_DEST_FILE
	sync
	if [ -f "$SD_CARD_LOCATION/$SD_CARD_DEMO_MODE_BASE_DIR/$DEMO_MODE_KNX_PRJ_FILE.$CURRENT_LANGUAGE_EXT" ]
	then
		DEMO_MODE_KNX_PRJ=$SD_CARD_LOCATION/$SD_CARD_DEMO_MODE_BASE_DIR/$DEMO_MODE_KNX_PRJ_FILE.$CURRENT_LANGUAGE_EXT	
	fi	
	CMD="$SVP_GENERATOR -o $SVP_GAPP_INPUT_FILE -e $DEMO_MODE_KNX_PRJ -c $DEMO_MODE_CONFIGURATION_DEST_FILE"
	echo $CMD
	$SVP_GENERATOR -o $SVP_GAPP_INPUT_FILE -e $DEMO_MODE_KNX_PRJ -c $DEMO_MODE_CONFIGURATION_DEST_FILE
        CMD="$GAP_GENERATOR $SVP_GAPP_INPUT_FILE $DEMO_MODE_GAPP_DEST_DIR true"
        echo $CMD
	$GAP_GENERATOR $SVP_GAPP_INPUT_FILE $DEMO_MODE_GAPP_DEST_DIR true
	cp /opt/gira/demo/sales/$DEMO_MODE_DEVICE_DEFINITION_FILE /opt/userdata/devicestack/devicedefinition/$DEMO_MODE_DEVICE_DEFINITION_FILE
	touch $DEMO_MODE_ACTIVATED_FLAG
	sync
	sync
	sleep 5
	reboot -f

}


do_clean() {

    # Triggering the watchdog here once should be sufficient.
    echo Z > /dev/watchdog

    if [ -f "/opt/userdata/devicestack/devicedefinition/$DEMO_MODE_DEVICE_DEFINITION_FILE" ]
    then
       echo "remove device definition file from user data"
       rm /opt/userdata/devicestack/devicedefinition/$DEMO_MODE_DEVICE_DEFINITION_FILE
    fi
    if [ -f $DEMO_MODE_CONFIGURATION_DEST_FILE ]
    then
       echo "remove generated demo mode configuration file"
       rm $DEMO_MODE_CONFIGURATION_DEST_FILE
    fi

    if [ -d "$DEMO_MODE_GAPP_BASE_DEST_DIR" ]
    then
        echo "remove generated demo $DEMO_MODE_GAPP_BASE_DEST_DIR directory"
        rm -R $DEMO_MODE_GAPP_BASE_DEST_DIR
    fi

    if [ -d "$SVP_GAPP_INPUT_FILE/staticfiles" ]
    then
        echo "remove generated staticfiles in $SVP_GAPP_INPUT_FILE directory"
        rm -R $SVP_GAPP_INPUT_FILE/staticfiles
    fi

    if [ -f $SVP_GAPP_INPUT_FILE/device_independent.zip ]
    then
	echo "remove  device_independent.zip in $SVP_GAPP_INPUT_FILE directory"
        rm $SVP_GAPP_INPUT_FILE/device_independent.zip
    fi

    if [ -f $DEMO_MODE_ACTIVATED_FLAG ]
    then
	echo "remove demo activated flag"
        rm $DEMO_MODE_ACTIVATED_FLAG
    fi        

}


DEMO_MODE_ACTION="nothing"

if [ -f $DEMO_MODE_ACTIVATION_FLAG ]
then
    echo "demo mode"
    if [ -f $DEMO_MODE_ACTIVATED_FLAG ]
    then
        echo "demo mode already active on sdcard"
	if [ ! -d "$DEMO_MODE_GAPP_BASE_DEST_DIR" ]
        then
	  echo "demo mode not active on device, trigger new generation"
          DEMO_MODE_ACTION="generate"
	fi
    else
	DEMO_MODE_ACTION="generate"
    fi
else
    DEMO_MODE_ACTION="clean"
fi


if [ "generate" == "$DEMO_MODE_ACTION" ]
then
        echo "demo mode action: generate"
	do_generate
else 
	if [ "clean" == "$DEMO_MODE_ACTION" ]
	then
	        echo "demo mode action: clean"
		do_clean
	else
        	echo "demo mode action: no action"
	fi
fi

