<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:output indent="yes" />
    <xsl:output method="html"/>
    <xsl:template match="/">

      .fi_wizard_title {
        padding-bottom: <xsl:value-of select="/metrics/wizard/metric[@key = 'fi_wizard_title']/padding-bottom" />px;
        padding-top: <xsl:value-of select="/metrics/wizard/metric[@key = 'fi_wizard_title']/padding-top" />px;
        height: <xsl:value-of select="/metrics/wizard/metric[@key = 'fi_wizard_title']/height" />px;
        position: relative;
        left: <xsl:value-of select="/metrics/wizard/metric[@key = 'fi_wizard_title']/left" />px;
        width: <xsl:value-of select="/metrics/wizard/metric[@key = 'fi_wizard_title']/width" />px;
      }

        .fi_wizard_image{
        position: relative;
        top: <xsl:value-of select="/metrics/wizard/metric[@key = 'fi_wizard_image']/top" />px;
        left: <xsl:value-of select="/metrics/wizard/metric[@key = 'fi_wizard_image']/left" />px;
        }

        #fi_wizard_end{
        width: <xsl:value-of select="/metrics/wizard/metric[@key = 'fi_wizard_end']/width" />px;
    }
    
    .fi_pageHeader {
        height: <xsl:value-of select="/metrics/wizard/metric[@key = 'fi_pageHeader']/height" />px;
        margin-left: <xsl:value-of select="/metrics/wizard/metric[@key = 'fi_pageHeader']/margin-left" />px;
        margin-top: <xsl:value-of select="/metrics/wizard/metric[@key = 'fi_pageHeader']/ margin-top" />px;
        max-width: <xsl:value-of select="/metrics/wizard/metric[@key = 'fi_pageHeader']/ max-width" />px;
        text-overflow: ellipsis;
        white-space: nowrap;
        overflow: hidden;
     }
     
     .fi_pageDescription {
        height: <xsl:value-of select="/metrics/wizard/metric[@key = 'fi_pageDesciption']/height" />px;
        }

        .fi_blend{
        position: absolute;
        max-width: inherit;
        text-overflow: inherit;
        white-space: inherit;
        overflow: inherit;
        }

        @-webkit-keyframes fi_fadeIn {
        0% {
        opacity: 0;
        }

        100% {
        opacity: 1;
        }
        }

        .fi_fadeIn {
        -webkit-animation-name: fi_fadeIn;
        -webkit-animation-fill-mode: both;
        -webkit-animation-duration: 1s;
        }

        @-webkit-keyframes fi_fadeOut {
        0% {
        opacity: 1;
        }

        100% {
        opacity: 0;
        }
        }

        .fi_fadeOut
        {
        -webkit-animation-name: fi_fadeOut;
        -webkit-animation-fill-mode: both;
        -webkit-animation-duration: 1s;
        }

        .install-environment  .flow-top{
        position: absolute;
        }

        .white-divider
        {
        width: <xsl:value-of select="/metrics/timer/metric[@key = 'timer-view-container']/width" />px;
        border-top: <xsl:value-of select="/metrics/layout/metric[@key = 'layout.default-border']/width" />px solid #FFFFFF;
      }

      .fi_wizard_body .loadedText {
      background-color: #F5F5F5;
      width: <xsl:value-of select="/metrics/wizard/metric[@key = 'fi_wizard_body.loadedText']/width" />px;
      margin-top: <xsl:value-of select="/metrics/wizard/metric[@key = 'fi_wizard_body.loadedText']/margin-top" />px;
      margin-left: <xsl:value-of select="/metrics/wizard/metric[@key = 'fi_wizard_body.loadedText']/margin-left" />px;
      }

      .fi_wizard_body .acceptLicense {
      background-color: #F5F5F5;
      position: relative;
      }

      .fi_wizard_body .acceptLicense .settings-row-checkbox{
      position: absolute;
      top: 48%;
      transform: translateY(-50%);
      }

      .fi_wizard_body .acceptLicenseText {
      max-width: <xsl:value-of select="/metrics/wizard/metric[@key = 'fi_wizard_body.acceptLicenseText']/max-width - /metrics/wizard/metric[@key = 'fi_wizard_body.acceptLicenseText']/left" />px;
      line-height:normal;
      padding-top: <xsl:value-of select="/metrics/wizard/metric[@key = 'fi_wizard_body.acceptLicenseText']/top" />px;
      padding-left: <xsl:value-of select="/metrics/wizard/metric[@key = 'fi_wizard_body.acceptLicenseText']/left" />px;
      padding-bottom: <xsl:value-of select="/metrics/wizard/metric[@key = 'fi_wizard_body.acceptLicenseText']/bottom" />px;
      position: relative;
      }

      #fi_page_1 .fi_wizard_body {
      background-color: #FFFFFF;
      }

      .fi_wizard_body .loadedText .paragraph,
      .fi_wizard_body .loadedText .caption,
      .fi_wizard_body .loadedText .subcaption,
      .fi_wizard_body .loadedText .link,
      .fi_wizard_body .loadedText table,
      .fi_wizard_body .loadedText .listentry {
      margin-left: <xsl:value-of select="/metrics/wizard/metric[@key = 'fi_wizard_body.paragraph']/margin-left" />px;
      width: <xsl:value-of select="/metrics/wizard/metric[@key = 'fi_wizard_body.paragraph']/width" />px;
      }

      .fi_wizard_body .loadedText .paragraph:first-of-type {
      padding-top:  <xsl:value-of select="/metrics/wizard/metric[@key = 'fi_wizard_body.paragraph.first']/padding-top" />px;
      }

      .fi_wizard_body .loadedText .paragraph:last-of-type {
      padding-bottom:  <xsl:value-of select="/metrics/wizard/metric[@key = 'fi_wizard_body.paragraph.last']/padding-bottom" />px;
      }

      .fi_wizard_body .custom-checkbox .noDownEffect {
      display:none;
      }

    </xsl:template>
</xsl:stylesheet>