<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:output indent="yes" />
    <xsl:output method="html"/>
    <xsl:template match="/">

      .trigger-container {
      left: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-trigger-container']/left" />px;
      top: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-trigger-container']/top" />px;
      position: absolute;
      z-index: 1;
      }

      .trigger-container .trigger-button {
      left: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-button']/left" />px;
      top: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-button']/top" />px;
      border-top-left-radius: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-button']/radius" />px;
      border-top-right-radius:<xsl:value-of select="/metrics/detail/metric[@key = 'detail-button']/radius" />px;
      border-bottom-left-radius: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-button']/radius" />px;
      border-bottom-right-radius: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-button']/radius" />px;
      position: absolute;
      z-index: 3;
      }

      .trigger-container .trigger-ring {
      position: absolute;
      pointer-events: none;
      z-index: 2;
      }

      .trigger-container .trigger-ring.ring2 {
      opacity: 0;
      }

      .trigger-container .trigger-text-on, .trigger-text-off {
      width: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-trigger-text']/width" />px;    
      top: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-trigger-text']/top" />px;
      left: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-trigger-text']/left" />px;
      text-align: center;
      text-overflow: ellipsis;
      overflow: hidden;
      white-space: nowrap;
      position: absolute;
      display: block;
      z-index: 5;
      }

      .trigger-container .trigger-text-on {
      opacity: 0;
      }

      .trigger-container .trigger-text-off {
      opacity: 1;
      }

      .trigger-container .shadow-trigger {
      -webkit-filter: drop-shadow(0px 2px 2px rgba(0,0,0, 0.2));
      }

    </xsl:template>
</xsl:stylesheet>