﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:import href="../xsltemplates.xsl"/>
  <xsl:import href="tile_structure.xsl"/>
  <xsl:output indent="yes" />
  <xsl:output method="html"/>
  <xsl:template match="/">
    <!-- set tileId variable -->
    <xsl:variable name="tileId">
      <xsl:call-template name="tileId"/>
    </xsl:variable>

    <div class="tile tile-small">
      <xsl:attribute name="id">
        <xsl:copy-of select="$tileId" />
      </xsl:attribute>
      <xsl:attribute name="data-off-text">
        <xsl:value-of select="Channel/StatusTexts/Off"/>
      </xsl:attribute>
      <xsl:attribute name="data-on-text">
        <xsl:value-of select="Channel/StatusTexts/On"/>
      </xsl:attribute>
      <xsl:attribute name="data-switch-id">
        <xsl:value-of select="Channel/DataPoints/DataPoint[@TypeURN='de.gira.schema.datapoints.Switch' and @Name='OnOff']/@Id" />
      </xsl:attribute>
      <xsl:attribute name="data-status-id">
        <xsl:value-of select="Channel/DataPoints/DataPoint[@TypeURN='de.gira.schema.datapoints.SwitchState' and @Name='State']/@Id" />
      </xsl:attribute>
      <xsl:attribute name="data-led-on">
        <xsl:text>{{statusled-</xsl:text><xsl:value-of select="Channel/StatusLed/@On" /><xsl:text>}}</xsl:text>
      </xsl:attribute>
      <xsl:attribute name="data-led-off">
        <xsl:text>{{statusled-</xsl:text><xsl:value-of select="Channel/StatusLed/@Off" /><xsl:text>}}</xsl:text>
      </xsl:attribute>
      
    <!-- generate tile structure-->
    <xsl:call-template name="tileContent">
      <xsl:with-param name="statusText">
        <xsl:if test="Channel/StatusTexts/@Enable = 'true' or Channel/StatusValue/@Enable = 'true'">
          <div class="tile-status-text t2gg">- - -</div>
        </xsl:if>
      </xsl:with-param>
      <xsl:with-param name="controlElements">
        <xsl:call-template name="tileOnOffButtons">
          <xsl:with-param name="Index" select="Channel/@Index" />
        </xsl:call-template>
      </xsl:with-param>
      <xsl:with-param name="tileHeader"></xsl:with-param>
    </xsl:call-template>
      <script type="text/javascript">
        (function(){
        var tileId = '<xsl:value-of select="$tileId"/>';
        var dataset = document.getElementById(tileId).dataset;
        var tile =  $('#'+tileId);
        var onButton = $('.tileButtonOn', tile);
        var offButton = $('.tileButtonOff', tile);

        eventsOnTile(tileId);
        initOnOffTileButtons(tileId, dataset.switchId, onButton, offButton);

        <xsl:if test="Channel/StatusLed/@Enable = 'true'">
          registerLedCaseSet(dataset.statusId, dataset.ledOn, dataset.ledOff, tileId);
        </xsl:if>
        <xsl:if test="Channel/StatusTexts/@Enable = 'true'">
          registerStatusTextCaseSet(dataset.statusId, dataset.onText, dataset.offText, tileId);
        </xsl:if>
        
        <!-- ######################### set tile click action ######################### -->
        tile.on('tileAction',function(){
          NavbarController.getInstance().openDetailElement(this);
        });
        })();
      </script>
    </div>
  </xsl:template>
</xsl:stylesheet>
