<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:output indent="yes" />
    <xsl:output method="html"/>
    <xsl:template match="/">
.tile {
    background-color: #f5f5f5;
    position: relative;
    height: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.tile']/height" />px;
    display: inline-block;
}

.tile-control-down {
    background-color: #ebebeb;
}

.tile-down {
    background-color: #505050; 
}

.tile-small {
    width: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.tile.small']/width" />px;
}

.tile-large {
    width: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.tile.large']/width" />px;  
}

.tile-flow-top {
    height: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.tile.flow.top']/height" />px;
    background: -webkit-linear-gradient(top, #141414 0%,#505050 100%);
}

.tile-icon {
    position: absolute;
    top: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.tile.icon']/top" />px;
    left: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.tile.icon']/left" />px;
    width: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.tile.icon']/width" />px;
    height: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.tile.icon']/height" />px;
}

.grid-line {
    height: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.grid.line']/height" />px;
    margin-left: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.grid.line']/margin-left" />px;
    position: absolute;
}

.grid-line-down {
    background-image: url(../img/<xsl:value-of select="/metrics/tile/metric[@key = 'tile.grid.line']/width" />x<xsl:value-of select="/metrics/tile/metric[@key = 'tile.grid.line']/height" />_repeating_gc4_grid_line_down.png);
      }

      .grid-line-small {
      width: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.grid.line.small']/width" />px;
}

.grid-line-large {
    width: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.grid.line.large']/width" />px;
}

.grid-line-one {
    top: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.grid.line.one']/top" />px;
}

.grid-line-two{
    top: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.grid.line.two']/top" />px;
}

.tile-description-box {
    position: absolute;
    top: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.tile.description.box']/top" />px;
    height: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.tile.description.box']/height" />px;
    left: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.tile.description.box']/left" />px;
}

.tile-description-box-small {
    width: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.tile.description.box.small']/width" />px;
}


.tile-description-box-large {
    width: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.tile.description.box.large']/width" />px;
}

.tile-description-box-text {
    position: relative;
    float: left;
    width: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.tile.description.box.text']/width" />px;
}

.tile-description-text {
    position: relative;
    top: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.tile.description.text']/top" />px;
    text-overflow: ellipsis;
    overflow: hidden;
    white-space: nowrap;
    padding-top: 4px;
}

.tile-description-room {
    position: relative;
    top: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.tile.description.room']/top" />px;
    text-overflow: ellipsis;
    overflow: hidden;
    white-space: nowrap;
    visibility: hidden;
}

.tile-status-led {
    position: absolute;
    height: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.tile.status.led']/height" />px;
    width: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.tile.status.led']/width" />px;
    top: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.tile.status.led']/top" />px;
    right: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.tile.status.led']/right" />px;
}

.tile-status-text, .tile-function-folder-text {
    position: absolute;
    left: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.tile.status.text']/left" />px;
    top: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.tile.status.text']/top" />px;
    padding-top: 4px;
    margin-top: -4px;
}

.tile-status-text {
    max-width: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.tile.status.text']/max-width" />px;
    text-overflow: ellipsis;
    overflow: hidden;
    white-space: nowrap;
}

.tile-status-text-long{
    max-width: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.tile.status.text.long']/max-width" />px !important;
}

.element-box {

	position: absolute;
	bottom: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.element.box']/bottom" />px;
	right: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.element.box']/right" />px;
	height: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.element.box']/height" />px;
	padding-top: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.element.box']/padding-top" />px;
	padding-right: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.element.box']/padding-right" />px;
}

.tile .container-content-count {
  position: absolute;
  top: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.container-content-count']/top" />px;
  right: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.container-content-count']/right" />px;
  border: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.container-content-count']/border" />;
  color:#ffffff;
  background-color:#505050;
  height:<xsl:value-of select="/metrics/tile/metric[@key = 'tile.container-content-count']/height" />px;
  width:<xsl:value-of select="/metrics/tile/metric[@key = 'tile.container-content-count']/width" />px;
  line-height:<xsl:value-of select="/metrics/tile/metric[@key = 'tile.container-content-count']/lineHeight" />px;
  text-align: center;
  text-shadow: 0px 1px 0px rgba(0,0,0,0.5);
  -webkit-border-radius:8px;
  -webkit-box-shadow: inset 0px 0px 10px 0px rgba(0,0,0,0.5)
}

.tile .container-content-count.down-state {
  -webkit-box-shadow:none !important;
  text-shadow: 0px -1px 0px rgba(0,0,0,0.5) !important;
  border:1px solid #FFFFFF !important;
  height:<xsl:value-of select="/metrics/tile/metric[@key = 'tile.container-content-count']/height - 2" />px !important;
  width:<xsl:value-of select="/metrics/tile/metric[@key = 'tile.container-content-count']/width - 2" />px !important;
  line-height:<xsl:value-of select="/metrics/tile/metric[@key = 'tile.container-content-count']/lineHeight - 2" />px !important;
}

.tile .container-arrow {
  position: absolute;
  top: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.arrow-right']/top" />px;
  right: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.arrow-right']/right" />px;
}

.tile .buttongroup {
  position: relative;
  top: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.buttongroup']/top" />px;
  width: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.buttongroup']/width" />px;
  height: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.buttongroup']/height" />px;
  right: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.buttongroup']/right" />px;
}

.tile .button-left {
    position: relative;
    float: left;
}
 
.tile .button-right {
  position: absolute;
  left: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.arrow-up']/left" />px;
}
 
.tile .button-left:before{
  content: "";
  display: block;
  position: absolute;
  top: -5px;
  left: -15px;
  right: -15px;
  bottom: -5px;
  border: 5px solid transparent;
}
.tile .button-right:before{
  content: "";
  display: block;
  position: absolute;
  top: -5px;
  left: -15px;
  right: -13px;
  bottom: -5px;
  border: 5px solid transparent;
}
.tile .button-right-down,
.tile .button-left-down {
  -webkit-filter: drop-shadow(0px 8px 5px rgba(0,0,0, 0.5));
}
    

.tile .RTR_tile_symbol{
  position: absolute;
  float: left;
  top: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.rtr-symbol']/top" />px;
  left: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.rtr-symbol']/left" />px;
}
      
.tile .trigger-button {
  position: relative;
  top: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.trigger-button']/top" />px;
  width: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.trigger-button']/width" />px;
  height: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.trigger-button']/height" />px;
  right: <xsl:value-of select="/metrics/tile/metric[@key = 'tile.trigger-button']/right" />px;
}

.tile .trigger-button:before{
  content: "";
  display: block;
  position: absolute;
  top: -5px;
  left: -15px;
  right: -13px;
  bottom: -5px;
  border: 5px solid transparent;
}

    </xsl:template>
</xsl:stylesheet>
