﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:gira="urn:gira">
  <xsl:import href="xsltemplates.xsl"/>
  <xsl:output indent="yes" />
  <xsl:output method="html"/>
  <xsl:template match="/">
    <xsl:variable name="detailId">detail-<xsl:value-of select="Channel/@ContainerIndex" />-<xsl:value-of select="Channel/@Index" /></xsl:variable>
    <div class="detail detailflip">
        <xsl:attribute name="id">
            <xsl:value-of select="$detailId" />
        </xsl:attribute>
      <xsl:call-template name="channel_detail_description_row"></xsl:call-template>
      <div class="coverflip-container">
        <div class="coverflip-viewsides">
          <div id="flip" class="coverflip-side front">
              <div data-bind="template: {{name: 'gira-shutter-template'}}">
              </div>
              <div class="coverflip-background">
              </div>
              <xsl:if test="Channel/TimeSwitches/@Enable ='true'">
                  <div class="timer-icon sprites {{{{gc4_button_timer}}}}"></div>
              </xsl:if>
            <script type="text/javascript">
              $(function(){
                <xsl:call-template name="shutterRelativeConfiguration"></xsl:call-template>
                config.detailId = '<xsl:value-of select="$detailId" />';
                var model = new window.ShutterRelativeModel(config, tsx);
                ko.applyBindings(model, $('#<xsl:value-of select="$detailId"/>')[0]);
              });
          </script>
          </div>
        </div>
      </div>
    </div>
  </xsl:template>
</xsl:stylesheet>