/*
 * Adds event listener to the toggleSwitchButton
 *
 * @param {string} button
 *			button jquery element
 * @param {string} tileId
 *			tile id
 * @param {string} tag
 *			communication tag
 */
function toggleSwitchButton(button, tileId, tag) {
    var checkbox = button.find('input[type="checkbox"]');
    var checkBoxFg = button.find('.sliderbutton-fg');
    var checkBoxBg = button.find('.sliderbutton-bg');

    registerEventsForPressButton(button,
        function () {
            onControlDownChangeTileBackground(tileId);
            checkBoxBg.addClass('sliderbutton-bg-switch-down');
            checkBoxFg.addClass('sliderbutton-fg-down');
        },
        function () {
            onControlReleaseChangeTileBackground(tileId);
            checkBoxBg.removeClass('sliderbutton-bg-switch-down');
            checkBoxFg.removeClass('sliderbutton-fg-down');
        },
        function () {
            checkbox.prop("checked", !checkbox.prop("checked"));
            if (checkbox.prop("checked")) {
                ComClient.sendTagValue(tag, 1);
            } else {
                ComClient.sendTagValue(tag, 0);
            }
        }
    );
}

/*
 * changes the State of the ToggleSwitchButton
 *
 * @param {string} id
 *			button id
 * @param {string} state
 *			new state of the button
 */
function changeToggleSwitchButtonState(id, state) {
    var $id = $('#' + id);
    if (state !== $id.prop("checked"))
    {
        $id.prop("checked", state);
    }
}

/*
 * Changes the background of a toggle button
 *
 * @param {string} id ToggleButton id
 * @param {string} background Class of the background element (slider-background-left or slider-background-right)
 * @param {string} value New background color as hex string (e.g. #FFFFFF)
 */
function setToggleButtonBackground(id, background, value) {
    var backgroundElement = $("label[for='" + id + "'] ." + background);
    backgroundElement.css("background", value);
}

/*
 * changes the Background of a tile when the controls are down
 *
 * @param {string} tile
 *			tile id
*/
function onControlDownChangeTileBackground(tile)
{
    $('#' + tile).addClass('tile-control-down');
}

/*
 * changes the Background of a tile when the controls are up
 *
 * @param {string} tile
 *			tile id
*/
function onControlReleaseChangeTileBackground(tile)
{
    $('#' + tile).removeClass('tile-control-down');
}

/**
 * Change sprite_XYZ class of element to sprite_XYZ_inactive
 * 
 * @param {type} element element to change
 * @returns {undefined}
 */
function spriteDisable(element) {
    /*Widgets*/
    if (element !== undefined) {
        var cName = element.className;
        var sprite = cName.match(/\bsprite_\w*/i);
        if (sprite !== null && sprite[0].match("_inactive") === null) {
            var spriteNew = sprite[0] + "_inactive";
            element.className = cName.replace(sprite[0], spriteNew);
        }
    }
};

/**  
 * Change sprite_XYZ_inactive class of element to sprite_XYZ
 * 
 * @param {type} element element to change
 * @returns {undefined}
 */
function spriteEnable(element) {
    /*Widgets*/
    if (element !== undefined) {
        var cName = element.className;
        var sprite = cName.match(/\bsprite_\w*_inactive/i);
        if (sprite !== null) {
            var spriteNew = sprite[0].replace("_inactive", "");
            element.className = cName.replace(sprite[0], spriteNew);
        }
    }
};

function changeSpriteImage(element, spriteClass) {
    if (element !== undefined) {
        var cName = element.className;
        var sprite = cName.match(/\bsprite_\w*/i);
        if (sprite !== null) {
            element.className = cName.replace(sprite[0], spriteClass);
        }
    }
}


