﻿/**
 * changes classes when the settings entry is touchdown or mousedown
 * to change the colors and images
 *
 * @param {string} settingsEntry
 *			the name of the selected settings entry
 */
function onSettingsEntryDown(settingsEntry, event) {
    if ($(event.target).hasClass("ignorerowevent") || settingsEntry.hasClass("ignorerowevent") || settingsEntry.hasClass("inactive") || settingsEntry.hasClass('inactive')) {
        return;
    }
    if (settingsEntry.attr('class') == undefined) {
        settingsEntry = settingsEntry.find('.settings-row');
    }
    if (!settingsEntry.hasClass('down') && !settingsEntry.hasClass('inactive')) {
        settingsEntry.addClass('down');
        settingsEntry.find('.flow-top').css('visibility', 'visible');
        settingsEntry.find('.settings-row-text.sub-menu-text').removeClass('t2sg').addClass('t2ws');

        var sprites = settingsEntry.find('.sprites:not(.noDownEffect)');
        $(sprites).each(function(i, sprite) {
            spriteDown(sprites[i]);
        });
    }
};

/**
 * changes classes when the settingsEntry is touchup or mouseup
 * to change the colors and images
 *
 * @param {string} settingsEntry
 *			the name of the selected settings entry
 */
function onSettingsEntryUp(settingsEntry) {
    if (settingsEntry.attr('class') == undefined) {
        settingsEntry = settingsEntry.find('.settings-row');
    }

    if (settingsEntry.hasClass('down')) {
        var sprites = settingsEntry.find('.sprites:not(.noDownEffect)');
        $(sprites).each(function(i, sprite) {
            spriteUp(sprites[i]);
        });

        settingsEntry.removeClass('down');
        settingsEntry.find('.flow-top').css('visibility', 'hidden');
        settingsEntry.find('.settings-row-text.sub-menu-text').removeClass('t2ws').addClass('t2sg');
    }
};

/**
 * mouse and touch events on the settings entry
 *
 * @param {string} settingsEntry
 *			the name of the selected settings entry
 */
function eventsOnSettingsEntry(settingsEntry) {
    var settingsEntryJQuery = undefined;
    if (typeof settingsEntry == 'string') {
        settingsEntryJQuery = $('#' + settingsEntry);
    } else {
        settingsEntryJQuery = settingsEntry;
    }

    registerEventsBase(settingsEntryJQuery,
        function(e) {
            onSettingsEntryDown(settingsEntryJQuery, e);
        },
        function() {
            onSettingsEntryUp(settingsEntryJQuery);
        },
        function() {
            if (settingsEntryJQuery.hasClass("ignorerowevent") || settingsEntryJQuery.hasClass("inactive"))
                return;
            settingsEntryJQuery.trigger('settingsEntryAction');
        },
        { stopPropagation: false, ignoreY: false, callUpFunction4TouchMove: true, callClickAction4TouchEnd: true }
    );
};

/**
 * Returns all html input elements from given dom element.
 * @param {object} dom element
 * @return {array} input elements
 */
function saveAllInputs(main) {
    var arr = new Array();

    $(main).find('input').each(function(index, elem) {
        var inputValue = $(elem).val();
        //Get the input id
        var inputId = $(elem).attr('id');
        //Add them to the array
        var obj = new Object();
        obj.id = inputId;
        obj.val = inputValue;
        arr.push(obj);
    });
    return arr;
}

/**
 * Restores all input fields in sub tree with array's values.
 * @param {object} dom element
 * @param {array} key(id) and value(val)
 */
function restoreAllInputs(main, arr) {
    $(arr).each(function(index, elem) {
        var id = elem.id;
        var val = elem.val;
        $('#' + id).val(val);
    });
}

/**
 * Opens the settings view element for the specified settings entry.
 * 
 * @param String main ID of the settings entry which was clicked
 * @param String sub ID of the settings entry which has to be loaded
 */
function openSettingsElement(main, sub, callback) {
    var inputArr = saveAllInputs('#' + main);
    var inputData;
    inputData = new Object();
    inputData.cssId = '#' + main;
    inputData.data = inputArr;

    var navbarController = NavbarController.getInstance();
    navbarController._addUnclickableOverlay();

    $.ajax({
        url: "templates/settings/" + sub + ".xhtml",
        data: {},
        cache: false,
        async: false,
        success: function(data) {
            try {
                $('#border_left').show();
                var first = $('#' + main);
                var second = $(data);
                animateLeft(first, second);

                var scrollPosition = first.data('settingsSwiper').getWrapperTranslate('y');
                navbarController.addBackFunction(function () {
                    openSettingsLastElement(sub, main, inputData);
                    $('#' + main).data('settingsSwiper').setWrapperTranslate(0, scrollPosition, 0);

                });

                var onEnter = $('#' + sub).data('onEnter');
                if (onEnter != undefined) onEnter.call();

                if (typeof callback == 'function') {
                    callback();
                }
            } catch (e) {
                window.Gira.Log.error("exception while loading templates/settings/" + sub + ".xhtml" + ": " + e);
                navbarController._removeUnclickableOverlay();
                throw e;
            }
        },
        error: function() {
            navbarController._removeUnclickableOverlay();
        },
        dataType: 'html'
    });
};

/**
 * Opens the settings element from history.
 * 
 * @param String recent ID of the settings entry which was clicked
 * @param String last ID of the settings entry which has to be loaded on history click
 */
function openSettingsLastElement(recent, last, inputData) {
    var navbarController = NavbarController.getInstance();
    navbarController._addUnclickableOverlay();
    $.ajax({
        url: "templates/settings/" + last + ".xhtml",
        data: {},
        cache: false,
        async: false,
        success: function(data) {
            $('#border_left').show();
            var $recent = $('#' + recent);
            var $last = $(data);
            animateRight($recent, $last);

            if (inputData != null && inputData.data != null && inputData.cssId == '#' + last) {
                restoreAllInputs('#' + last, inputData.data);
            }

            var onBack = $('#' + last).data('onBack');
            if (onBack != undefined) onBack.call();
        },
        error: function() {
            navbarController._removeUnclickableOverlay();
        },
        dataType: 'html'
    });
};

/**
 * Right to left animation for settings menu
 * 
 * @param Object src jQuery object of the settings menu which is shown
 * @param Object target jQuery object of the settings entry which has to be loaded
 */
function animateLeft(src, target) {
    var parent = src.parent();
    var width = parent.width();

    src.css({ position: 'absolute', left: 0 });
    target.hide().appendTo(parent).css({ left: 462, position: 'absolute' });

    /* register/unregister settingsCaseSets */
    settingsCaseSet = $(src).data('caseSets');
    if (settingsCaseSet !== null && settingsCaseSet != undefined && settingsCaseSet.length !== 0) {
        ComClient.unregisterAll(settingsCaseSet);
    }
    settingsCaseSet = $(target).data('caseSets');
    if (settingsCaseSet !== null && settingsCaseSet != undefined && settingsCaseSet.length !== 0) {
        ComClient.registerAll(settingsCaseSet);
    }

    src.animate({ left: -462 }, 500, function() {
        $(src).remove();
    });
    target.show().animate({ left: 0 }, 500, function() {
        target.css({ left: null, position: null });
        NavbarController.getInstance()._removeUnclickableOverlay();
        target.data("settingsSwiper").reInit();
    });
}

/**
 * Left to Right animation for settings menu
 * 
 * @param Object src jQuery object of the settings menu which is shown
 * @param Object target jQuery object of the settings entry which has to be loaded
 */
function animateRight(src, target) {
    var parent = src.parent();
    var width = parent.width();

    src.css({ position: 'absolute', left: 0 });
    target.hide().appendTo(parent).css({ left: -462, position: 'absolute' });

    /* register/unregister settingsCaseSets */
    settingsCaseSet = $(src).data('caseSets');
    if (settingsCaseSet !== null && settingsCaseSet != undefined && settingsCaseSet.length !== 0) {
        ComClient.unregisterAll(settingsCaseSet);
    }
    settingsCaseSet = $(target).data('caseSets');
    if (settingsCaseSet !== null && settingsCaseSet != undefined && settingsCaseSet.length !== 0) {
        ComClient.registerAll(settingsCaseSet);
    }

    src.animate({ left: 462 }, 500, function() {
        $(src).remove();
    });
    target.show().animate({ left: 0 }, 500, function() {
        target.css({ left: null, position: null });
        NavbarController.getInstance()._removeUnclickableOverlay();
        target.data("settingsSwiper").reInit();
    });
}

/** 
 * enable/disable the items for the DIRECT-Function 
 * 
 */
function enablePrimaryItems(elems, offset, value) {
    var checkedItems = 0;
    // elems index 0 = ok abbrechen
    // elems index 1 = direktfunktion aktivieren
    for (var j = offset; j < elems.length; j++) {

        var addClass = value === true ? 'inactive' : 't2gg';
        var removeClass = value === true ? 't2gg' : 't2sg';

        if (value) {
            $('.settings-row#' + elems[j].id + ' .radio-input').prop('disabled', false);

            if ($(elems[j]).children('.settings-togglebutton').length <= 0) {
                $(elems[j]).removeClass('inactive');
            } else {
                $(elems[j]).addClass('inactive');
            }

            eventsOnSettingsEntry(elems[j].id);
            $(elems[j]).bind('settingsEntryAction', function() {
                $(this).find('input').prop("checked", true);
            });
            $(elems[j]).find('.settings-row-text').removeClass('inactive');
            $(elems[j]).find('.custom-radio-disabled').addClass('custom-radio');
            $(elems[j]).find('.custom-radio-disabled').removeClass('custom-radio-disabled');
        } else {
            $(elems[j]).addClass('inactive');
            
            $(elems[j]).find('.custom-radio').addClass('custom-radio-disabled');
            $(elems[j]).find('.custom-radio').removeClass('custom-radio');

            $(elems[j]).unbind('click');
            $(elems[j]).unbind('touchdown');
            $(elems[j]).unbind('mousedown');
            $(elems[j]).unbind('focus');
            $(elems[j]).unbind('touchstart');
            $(elems[j]).unbind('touchmove');
            $(elems[j]).unbind('settingsEntryAction');

            $(elems[j]).unbind();


            $(elems[j]).unbind('settingsEntryAction');
            $('.settings-row#' + elems[j].id + ' .radio-input').prop('disabled', true);
            if ($(elems[j]).children('.settings-togglebutton').length <= 0) {
                $(elems[j]).find('.settings-row-text').addClass('inactive');
            }
        }

        if (value) {

            if ($(elems[j]).find('.radio-input').prop('checked'))
                checkedItems++;
        }
    }
    //select first list entry if nothing is preselected
    if (value && checkedItems == 0) {
        //first element (offset) is the primary function toggle (on/off), so we need the second element
        $(elems[offset + 1]).find('input').prop("checked", true);
    }
}

/**
 * Reads the currently configured primary function and sets the according radio box
 * in the primary funciton selection
 */
function initPrimaryFunctionSelection() {
    var primFunctionIsActive = primaryFunction.isPrimaryFunctionActive();
    if (primFunctionIsActive) {
        var primaryFunctionData = primaryFunction.getPrimaryFunction();
        $('#' + primaryFunctionData).prop("checked", true);
    }

    // elems index 0 = direktfunktion aktivieren (activate primary function)
    var listOffset = 1;

    var elems = $('#' + SettingsElements['PRIMARYFUNCTION_TOGGLE']).parents('.menuPage').find('.settings-row');

    $('#' + SettingsElements['PRIMARYFUNCTION_TOGGLE']).change(function() {
        if ($('#' + SettingsElements['PRIMARYFUNCTION_TOGGLE']).prop('checked')) {
            enablePrimaryItems(elems, listOffset, true);
        } else {
            enablePrimaryItems(elems, listOffset, false);
        }
    });

    if (elems.length <= listOffset) {
        changeToggleSwitchButtonState(SettingsElements['PRIMARYFUNCTION_TOGGLE'], 0);
    } else {
        changeToggleSwitchButtonState(SettingsElements['PRIMARYFUNCTION_TOGGLE'], primFunctionIsActive ? 1 : 0);
        enablePrimaryItems(elems, listOffset, primFunctionIsActive);
    }
}

/**
 * Sets the currently configured primary function 
 * in the primary function selection
 */
function setPrimaryChannel() {
    var primaryFunctionContent = $('input[name=selectPf]:radio:checked').val();

    if ($('#' + SettingsElements['PRIMARYFUNCTION_TOGGLE']).prop('checked')) {
        primaryFunction.savePrimaryFunction(primaryFunctionContent);
    } else {
        fsm.API.PrimaryFunction.Disable();
    }
}

/**
 * Map settings to input elements
 */
SettingsElements = new Object();

/**
 * register input element
 *
 * @param String settingsID
 * @param String elementId
 */
function registerSettingsInput(settingsID, elementId) {
    SettingsElements[settingsID] = elementId;
}

/**
 * Register SettingsRow containing a sliderButton down status handling
 *
 * @param String settingsRowId
 */
function registerSliderButtonRow(settingsRowId) {
    var settingsRow = $('#' + settingsRowId);
    var onoffswitch = settingsRow.find(' .onoffswitch');
    var checkBoxFg = settingsRow.find('.sliderbutton-fg');
    var checkBoxBg = settingsRow.find('.sliderbutton-bg');
    var checkbox = settingsRow.find('input[type="checkbox"]');

    registerEventsForPressButton(onoffswitch,
        function() {
            if (!onoffswitch.hasClass('inactive')) {
                onControlDownChangeTileBackground(settingsRowId);
                checkBoxBg.addClass('sliderbutton-bg-switch-down');
                checkBoxFg.addClass('sliderbutton-fg-down');
            }
        },
        function() {
            onControlReleaseChangeTileBackground(settingsRowId);
            checkBoxBg.removeClass('sliderbutton-bg-switch-down');
            checkBoxFg.removeClass('sliderbutton-fg-down');
        },
        function () {
            if (!onoffswitch.hasClass('inactive')) {
                checkbox.prop("checked", !checkbox.prop("checked")).trigger('change');
            }
        }
    );
}

/**
 * Intitializes the homescreen selection formular
 */
function initHomescreenSelection() {
    var homescreen = localStorage['homescreen'];
    if (!homescreen) homescreen = 'tile';
    $('input[name="selectHomescreen"][value="' + homescreen + '"]').prop("checked", true);
}

/**
 * Stores the homescreen selection
 */
function setHomescreen() {
    localStorage['homescreen'] = $('input[name=selectHomescreen]:radio:checked').val();
    NavbarController.getInstance()._homescreenType = $('input[name=selectHomescreen]:radio:checked').val();
}

function initProximitySelection() {
    try {
        tsxGdsUtility$.getProximitySensorSensitivity(function(value) {
            $('input[name="proximitySelection"][value="' + value + '"]').prop("checked", true);
        });
    } catch (e) {
    }
}

function setProximityValue() {
    try {
        tsxGdsUtility$.setProximitySensorSensitivity($('input[name=proximitySelection]:radio:checked').val());
    } catch (e) {
    }
}

/**
 * initialize the RtcCalibration and spinning Wheel
 * @param string temperatureTag
 * @param string spinnWheelId
 */
function initRtcCalibration(temperatureTag, spinnWheelId) {
    //add noSwiping Class to the Slide
    var swiperslide = $('#settingsMenuRtcCalibration').parents('.swiper-slide');
    swiperslide.addClass('noSwipingV');

    //get actualTemperatureTag Value 
    var value = '';
    if (temperatureTag != null) {
        value = ComClient.getTagValue(temperatureTag);
    }

    if (!isNaN(value) && value !== '') {
        //hide Textbox2 and Show the spinningWheel
        $("#settingsMenuRtcCalibration > .valuator").show();
        $("#settingsMenuRtcCalibration > .textbox").show();
        $("#settingsMenuRtcCalibration > .textbox2").hide();

        var precision = 1;
        var isFloat = precision > 0;
        var degreesInt = Array.apply(null, Array(41)).map(function(_, i) { return i; });
        var degreesDec = Array.apply(null, Array(10)).map(function(_, i) { return i; });

        //split the actual temperature value
        var currentValue = parseFloat(value).toFixed(1).split('.');
        currentValue[1] = currentValue[1].substring(0, 1);

        var wheels = [
            { 'degrees': degreesInt, 'defaultValue': currentValue[0] },
            { 'degrees': degreesDec, 'defaultValue': currentValue[1] }
        ];
        //create spinning wheel
        SpinningWheel.create({ 'spinnWheelId': spinnWheelId, 'isFloat': isFloat, 'wheels': wheels });
    } else {
        //hide spinning wheel and show textbox2
        $("#settingsMenuRtcCalibration > .valuator").hide();
        $("#settingsMenuRtcCalibration > .textbox").hide();
        $("#settingsMenuRtcCalibration > .textbox2").show();
    }
}

/**
 * set the new RtcCalibration Value to the GDS
 */
function setRtcCalibration() {
    var spinningWheelId = "spinnWheel-rtc-calibration";
    var value = '';
    var currentSpinValue = SpinningWheel.getCurrentValueById(spinningWheelId);
    if (currentSpinValue != null) {
        if (currentSpinValue.length == 2) {
            value = currentSpinValue[0].value + '.' + currentSpinValue[1].value;
        } else {
            value = Number(currentSpinValue[0].value);
        }
        //gds sent value
        tsxGdsUtility$.setTemperatureCalibration(value);
    }
}

function enableDisableSettingsRow(id, enabled) {
    if (enabled) {
        $('#' + id).removeClass("inactive");
        $('#' + id + ' .t3lgg').addClass("t3lsg");
        $('#' + id + ' .t3lsg').removeClass("t3lgg");
        $('#' + id + ' .input').removeAttr('disabled');
    } else {
        $('#' + id).addClass("inactive");
        $('#' + id + ' .t3lsg').addClass("t3lgg");
        $('#' + id + ' .t3lgg').removeClass("t3lsg");
        $('#' + id + ' .input').attr('disabled', 'true');
    }
}

/**
 * Show text field delete input button; you can override the textlength test with the optional showX parameter (boolean)
 */
function showDeleteInputX(settingsRowId, inputFieldId, showX) {
    var textLength = 0;
    var inputField = $(settingsRowId + ' ' + inputFieldId);
    if (inputField && inputField.val()) {
        textLength = $(settingsRowId + ' ' + inputFieldId).val().length;
    }
    if (showX == undefined && textLength > 0) {
        showX = true;
    }
    var ico = $(settingsRowId + ' .settings-x-icon').css('display', 'block');
    if (showX == true) {
        ico.css('display', 'block');
    } else {
        ico.css('display', 'none');
    }
}

function togglePasswordCheckbox(settingsRowId, inputFieldId, checkboxId) {
    var checked = $(checkboxId).prop('checked');
    if (checked) {
        $(checkboxId).prop('checked', false);
        $(settingsRowId + ' ' + inputFieldId).attr('type', 'password');
    } else {
        $(checkboxId).prop('checked', true);
        $(settingsRowId + ' ' + inputFieldId).attr('type', 'text');
    }
}

///**
// * Loads the license content in the settings menu page
// */
//function loadLicense() {
//    /* load and set new content*/
//    $.ajax({
//        url: "templates\\licenses\\license.xhtml",
//        data: {},
//        cache: false,
//        async: false,
//        success: function(data) {
//            $(".loadedText").append($(data));
//        },
//        dataType: 'html'
//    });
//}