﻿/*jslint todo: true browser: true*/
/*global gds$, fsm, globals*/

/**
* Polls device configuration for network connection state and triggers a super error if the
* connection was lost.
*/
(function () {
    "use strict";
    var I18nTexts = window.Gira.appLang.appI18nTexts;

    /**
    * Checks the connection state of ethernet and wifi interfaces and opens or closes the super error popup accordingly. 
    */
    function checkConnectionError() {
        gds$.updateDeviceConfiguration(true, function (deviceConfig) {
            var connected = deviceConfig.NetworkTechnologies_wifi_Connected === 'true' ||
                            deviceConfig.NetworkTechnologies_ethernet_Connected === 'true';
            if (connected) {
                fsm.API.SystemMessage.CloseSuperError();
            } else {
                fsm.API.SystemMessage.OpenSuperError(I18nTexts.openSuperError);
            }
        });
    }

    // start interval
    window.setInterval(checkConnectionError, globals.connection.pollInterval);

}());