/*global ko, $, gds$, _*/
/*jslint browser: true*/

(function (ns) {
    "use strict";

    function LicenseViewModel(setSystemDefaultLanguage, licenseData) {
        var langDe = {code : "de", buttonText: "English version"},
            langEn = {code : "en", buttonText: "German version"},
            activeLicenses = licenseData.licenseTextObj(),
            activeLicenseText = ko.observable(''),
            licenseAgreementText = ko.observable(''),
            updateCompleted = ko.observable('').extend({ notify: 'always' }),
            switchButtonVisibility = ko.observable(false),
            licenseLanguages = [langDe.code, langEn.code],
            activeLicenseLanguage = '',
            activeLicenseButtonText = ko.observable(''),
            langConfig,
            getLicenseLangByLandCode = function (langCode) {
                var licenseLangCode = '';
                if (_.contains(licenseLanguages, langCode)) {
                    licenseLangCode = langCode;
                } else {
                    licenseLangCode = langEn.code;
                }
                return licenseLangCode;
            },
            defaultLang = ko.observable(),
            updateLicenceLang = function (langCode) {
                activeLicenseLanguage = langCode;
                activeLicenseText(activeLicenses[activeLicenseLanguage]);
                activeLicenseButtonText(langDe.code === activeLicenseLanguage ? langDe.buttonText : langEn.buttonText);
                licenseAgreementText(langDe.code === activeLicenseLanguage ? activeLicenses.agreeDe : activeLicenses.agreeEn);
            },
            setLicenseByLanguageCode = function (langCode) {
                var newLicenseLang = getLicenseLangByLandCode(langCode),
                    setNewLanguage = (newLicenseLang !== activeLicenseLanguage);

                if (setNewLanguage) {
                    updateLicenceLang(newLicenseLang);
                }
                switchButtonVisibility(langCode !== langDe.code);

                return setNewLanguage;
            };

        if (setSystemDefaultLanguage === undefined) {
            setSystemDefaultLanguage = true;
        }

        if (setSystemDefaultLanguage) {
            if (ns.appLang) {
                langConfig = ns.appLang.getLanguageConfig();
                defaultLang(langConfig.lang);
                setLicenseByLanguageCode(defaultLang());
            }
        }

        function getNextLanguage() {
            var indexOfCurrent = licenseLanguages.indexOf(activeLicenseLanguage),
                nextIndex = 0;
            if (indexOfCurrent < (licenseLanguages.length - 1)) {
                nextIndex = indexOfCurrent + 1;
            }

            updateLicenceLang(licenseLanguages[nextIndex]);
            updateCompleted('reInit');
        }

        return {
            getNextLanguage: getNextLanguage,
            setLicenseByLanguageCode: setLicenseByLanguageCode,
            activeLicenseText : activeLicenseText,
            activeLicenseButtonText : activeLicenseButtonText,
            switchButtonVisibility : switchButtonVisibility,
            activeLicenseLang : function () {return activeLicenseLanguage; },
            updateCompleted: updateCompleted,
            defaultLang : defaultLang,
            licenseAgreementText: licenseAgreementText
        };
    }
    ns.LicenseViewModel = LicenseViewModel;
    ns.licenseViewModel = new LicenseViewModel(true, ns.licenseData);
}(window.Gira));