﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:import href="timer-xsltemplates.xsl"/>
  <xsl:import href="../xsltemplates.xsl"/>
  <xsl:output indent="yes" />
  <xsl:output method="html"/>
  <xsl:template match="/">
    <div id="timer-view" class="timer-overview coverflip-side back">
      <div id="timer-list-view">
        <div class="timer-description-row">
          <div class="timer-description-row-text">
            <div class="t3sg">{{timerHeadline}}</div>
          </div>
        </div>
        <xsl:call-template name="timerListControls">
        </xsl:call-template>
        <div class="container">
        <div class="timer-swiper-container">
          <div class="swiper-wrapper noSwipingH">
            <div class="swiper-slide">
              <div class="settings-description-text-item t3lsg">{{timerDescriptionText}}</div>
              <div class="timer-toggle">
                  <div class="timer-toggle-text t1sg">{{timerToggleText}}</div>
                  <div class="timer-toggle-button">
                    <xsl:call-template name="toggleSwitchButton">
                      <xsl:with-param name="Id">
                        <xsl:text>onoffswitch-timer</xsl:text>
                      </xsl:with-param>
                      <xsl:with-param name="ColorIdLeft" select="2"/>
                      <xsl:with-param name="ColorIdRight" select="0" />
                      <xsl:with-param name="ColorPicker" select="false" />
                    </xsl:call-template>
                  </div>
                </div>
                <div class="timer-list" data-bind="template: {{ name: 'timer-template', foreach: timers, as: 'timer',  afterRender: registerEvents }}"></div>
              </div>
            </div>
          </div>
        </div>
        <div class="timer-view-scrollbar"></div>
        <script id="timer-template" type="text/template">
          <div class="timer-row timer-element" data-bind="attr{{id: 'timer-element-' + timer.index}}">
            <div class="flow-top"></div>
            <div class="checkbox-wrapper ignoreRowEvent">
              <div class="checkbox ignoreRowEvent" data-bind="attr{{timerId: timer.index}}">
                <div class="ignoreRowEvent sprites {{{{checkbox-red}}}}"></div>
              </div>
            </div> 
            <div class="timer-box">
              <span class="timer-days t1sg" data-bind="text: $root.formatDays(timer.recurrence, timer.weekdays)"></span>
              <span class="timer-time t1gg" data-bind="text: $root.formatTime(timer.time)"></span>
              <span class="timer-action t3gg" data-bind="text: $root.formatAction(timer.triggerValue)"></span>
            </div>
            <div class="timer-clock day sprites {{{{gc4_clocktimer_day}}}} noDownEffect" data-bind="visible: $root.showClock(timer.time)">
              <div class="minutes sprites {{{{gc4_clocktimer_minutes_day}}}} noDownEffect"><xsl:attribute name="data-bind"><xsl:text>style: {'-webkit-transform': 'rotate('+$root.minuteRotation(timer.time)+'deg)'}</xsl:text></xsl:attribute>
              </div>
              <div class="hours sprites {{{{gc4_clocktimer_hours_day}}}} noDownEffect"><xsl:attribute name="data-bind"><xsl:text>style: {'-webkit-transform': 'rotate('+$root.hourRotation(timer.time)+'deg)'}</xsl:text></xsl:attribute>
            </div>
            </div>
            <div class="timer-clock night sprites {{{{gc4_clocktimer_night}}}} noDownEffect" data-bind="visible: !$root.showClock(timer.time)">
              <div class="minutes sprites {{{{gc4_clocktimer_minutes_night}}}} noDownEffect"><xsl:attribute name="data-bind"><xsl:text>style: {'-webkit-transform': 'rotate('+$root.minuteRotation(timer.time)+'deg)'}</xsl:text></xsl:attribute>
              </div>
              <div class="hours sprites {{{{gc4_clocktimer_hours_night}}}} noDownEffect"><xsl:attribute name="data-bind"><xsl:text>style: {'-webkit-transform': 'rotate('+$root.hourRotation(timer.time)+'deg)'}</xsl:text></xsl:attribute>
              </div>
            </div>
            <div class="timer-arrow sprites {{{{tile-arrow-right}}}}"></div>
          </div>
        </script>

        <script type="text/javascript">
          createMenuSwiperV("#timer-list-view .timer-swiper-container", "#timer-list-view  .timer-view-scrollbar", "#timer-list-view", '.timer-row, .timer-action-row');
        </script>
      </div>
      <div id="timer-edit-view">
        <div class="timer-description-row">
          <div class="timer-description-row-text">
            <div class="t3sg">
              <span>{{timerTimerDescriptionName}}</span>
              <span class="extended-timer-description t3lsg"></span>
            </div>
          </div>
        </div>
        <xsl:call-template name="timerEditControls">
        </xsl:call-template>
        <div class="container">
          <div class="timer-swiper-container">
            <div class="swiper-wrapper noSwipingH">
              <div class="swiper-slide">
                <div class="timer-headline">
                  <span class="t3lsg">{{timerTimerHeadline}}</span>
                </div>
                <div class="timer-day-selection">
                  <div class="day-selection-button">{{timerDaysMon}}</div>
                  <div class="day-selection-button">{{timerDaysTue}}</div>
                  <div class="day-selection-button">{{timerDaysWed}}</div>
                  <div class="day-selection-button">{{timerDaysThu}}</div>
                  <div class="day-selection-button">{{timerDaysFri}}</div>
                  <div class="day-selection-button">{{timerDaysSat}}</div>
                  <div class="day-selection-button">{{timerDaysSun}}</div>
                </div>
                <div class="timer-time-selection">
                  <xsl:call-template name="slotmachine">
                    <xsl:with-param name="spinnWheelId">timer-time-wheel</xsl:with-param>
                  </xsl:call-template>
                  <div class="valuator">
                    <div class="gradient-top CSS8a"/>
                    <div class="timer-double-line top"/>
                    <div class="gradient-bottom CSS8b"/>
                    <div class="timer-double-line bottom"/>
                    <div class="timer-colon">
                      <div class="timer-css-dot"/>
                      <div class="timer-css-dot"/>
                    </div>
                  </div>  
                </div>
                <div class="timer-double-line full bottoms"></div>
                <div class="timer-headline-sub">
                  <span class="t3lsg">{{timerTimerSubHeadline}}</span>
                </div>
                <xsl:call-template name="rtcTimerAction"/>
                <xsl:call-template name="switchTimerAction"/>
                <xsl:call-template name="dimmerTimerAction"/>
                <xsl:call-template name="sceneTimerAction"/>
                <xsl:call-template name="blindShutterTimerAction"/>
                <xsl:call-template name="shutterRelativeTimerAction"/>
                <div class="timer-double-line full"></div>
                <div class="blindpuffer"></div>
              </div>
            </div>
          </div>
        </div>
        <div class="timer-view-scrollbar"></div>
        <script type="text/javascript">
          (function(){
          createMenuSwiperV("#timer-edit-view .timer-swiper-container", "#timer-edit-view  .timer-view-scrollbar", "#timer-edit-view", '.timer-row, .timer-action-row');
          var hours = Array.apply(null, Array(24)).map(function (_, i) {return ('0' + i).slice(-2);});
          var minutes = Array.apply(null, Array(60)).map(function (_, i) {return ('0' + i).slice(-2);});
          var wheels = [{'degrees':hours, 'defaultValue':'00'}, {'degrees':minutes, 'defaultValue':'00'}];

          SpinningWheel.create({'spinnWheelId':'timer-time-wheel', 'isFloat':false, 'wheels':wheels});
          })();
        </script>
      </div>
    </div>
    </xsl:template>
</xsl:stylesheet>