<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:import href="xsltemplates.xsl"/>
    <xsl:output indent="yes"/>
    <!-- key to select all tiles on the same slide -->
    <xsl:key name="tiles-by-slides" match="Tile[@slide]" use="@slide" />
    
    <xsl:template match="/">
      <xsl:variable name="viewId">
        <xsl:text>tile-view-</xsl:text>
        <xsl:value-of select="Container/@Index"/>
      </xsl:variable>
      <div class="view-container">
        <xsl:attribute name="id">
          <xsl:copy-of select="$viewId" />
        </xsl:attribute>
        <div id="breadcrumb">
          <div class="t3sw" id="room">
            <xsl:value-of select="Container/Description/Language[@Index = 0]"/>
            <xsl:text>&#160;</xsl:text>
          </div>
          <div class="t3gg" id="function">
            <xsl:if test="Container/@ElementCount - Container/@FunctionFolders - Container/@Applications != 0">
              <xsl:value-of select="Container/@ElementCount - Container/@FunctionFolders - Container/@Applications"/>
              <xsl:if test="Container/@ElementCount - Container/@FunctionFolders - Container/@Applications = 1">
                <xsl:text>&#160;{{tileViewFunction1}}</xsl:text>
              </xsl:if>
              <xsl:if test="Container/@ElementCount - Container/@FunctionFolders - Container/@Applications > 1">
                <xsl:text>&#160;{{tileViewFunction2}}</xsl:text>
              </xsl:if>
            </xsl:if>
            <xsl:if test="Container/@FunctionFolders != 0">
              <xsl:text>&#160;</xsl:text>
              <xsl:value-of select="Container/@FunctionFolders"/>
              <xsl:if test="Container/@FunctionFolders = 1">
                <xsl:text>&#160;{{tileViewFunction3}}</xsl:text>
              </xsl:if>
              <xsl:if test="Container/@FunctionFolders > 1">
                <xsl:text>&#160;{{tileViewFunction4}}</xsl:text>
              </xsl:if>
            </xsl:if>
            <xsl:if test="Container/@Applications != 0">
              <xsl:text>&#160;</xsl:text>
              <xsl:value-of select="Container/@Applications"/>
              <xsl:if test="Container/@Applications = 1">
                <xsl:text>&#160;{{tileViewFunction5}}</xsl:text>
              </xsl:if>
              <xsl:if test="Container/@Applications > 1">
                <xsl:text>&#160;{{tileViewFunction6}}</xsl:text>
              </xsl:if>
            </xsl:if>
          </div>
        </div> 
        <div class="container">
          <div class="swiper-container-tile-view">
            <div class="swiper-wrapper">
              <xsl:variable name="container-list" select="Container/Tile[not(@slide=following::Tile/@slide)]" />
              <xsl:for-each select="$container-list">
                <xsl:variable name="container-id" select="@slide" />
                <div id="slide-container-{$container-id}" class="slide-container swiper-slide">
                  <xsl:for-each select="key('tiles-by-slides', $container-id)">
                    <xsl:if test="position() mod 2 = 1">
                      <div class="tile-grid-row">
                        <div class="tile-container">
                          <tileViewElement>
                            <xsl:value-of select="@Filename" />
                          </tileViewElement>
                        </div>
                        <div class="divider-small-vertical"></div>
                        <div class="tile-container">
                          <tileViewElement>
                            <xsl:value-of select="following-sibling::node()/@Filename" />
                          </tileViewElement>
                        </div>
                      </div>
                      <div class="divider-small"></div>
                    <xsl:if test="following-sibling::*" >
                      <xsl:choose>
                        <xsl:when test="not(position() = last() or position()+1 = last())">
                          <div class="space"></div>
                        </xsl:when>
                        <xsl:otherwise>
                          <div class="space large-tile-bottom"></div>
                        </xsl:otherwise>
                      </xsl:choose>
                      <div class="divider-small"></div>
                    </xsl:if>
                    </xsl:if>
                  </xsl:for-each>
                </div>
              </xsl:for-each>
            </div>
          </div>
          <xsl:call-template name="bulletbar">
            <xsl:with-param name="srcElements" select="Container/Tile[not(@slide=following::Tile/@slide)]"/>
          </xsl:call-template>
        </div>
        
        <script type="text/javascript">
          (function(){
            var viewId = '#<xsl:value-of select="$viewId"/>';
<xsl:text disable-output-escaping="yes"><![CDATA[                   
            $(viewId).data('caseSets', temporaryCaseSets);
            temporaryCaseSets = [];

            //initialize swiper container
            var tileviewSwiper = createSwiperH(viewId, '.swiper-container-tile-view', '{{bullets-active}}', '{{bullets-inactive}}', viewTypes.TILE);
            $(viewId).data('swiper', tileviewSwiper);
            $(viewId).data('wasSwiped', false);
            $(viewId).on('loadView', function() {
              //save swiper (required for back functionality)
              NavbarController.getInstance()._swiper = tileviewSwiper;
            });
]]></xsl:text>
        })();
      </script>
      </div>
    </xsl:template>

</xsl:stylesheet>
