﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:import href="../xsltemplates.xsl"/>
    <xsl:import href="tile_structure.xsl"/>
    <xsl:output indent="yes" />
    <xsl:output method="html"/>


    <!--
    Create +/- buttons with 'heating' symbol for RTR
    -->
    <xsl:template name="RTC_tileButtons">
        <xsl:param name="Index" />
        <div class="buttongroup">
            <div class="RTR_tile_button button-left sliderbutton-bg">
                <xsl:attribute name="id">
                    <xsl:text>RTR_minus-</xsl:text><xsl:value-of select="Channel/@ContainerIndex" />-<xsl:value-of select="$Index"/>
                </xsl:attribute>
                <xsl:attribute name="style">display: none;</xsl:attribute>
              <div class="sliderbutton-fg"></div>
              <div class="sliderbutton-label sprites {{{{gc4_button_minus}}}}"></div>
            </div>
            <div class="RTR_tile_button button-left sliderbutton-bg disabled">                
              <div class="sliderbutton-fg"></div>
              <div class="sliderbutton-label sprites {{{{gc4_button_minus_disabled}}}}"></div>
            </div>
            <div class="RTR_tile_symbol sprites {{{{gc4_icon_cooling_detail}}}}">
                <xsl:attribute name="id">
                    <xsl:text>RTR_cooling-</xsl:text><xsl:value-of select="Channel/@ContainerIndex" />-<xsl:value-of select="$Index"/>
                </xsl:attribute>
                <xsl:attribute name="style">display: none;</xsl:attribute>
            </div>
            <div class="RTR_tile_symbol sprites {{{{gc4_icon_heating_detail}}}}">
                <xsl:attribute name="id">
                    <xsl:text>RTR_heating-</xsl:text><xsl:value-of select="Channel/@ContainerIndex" />-<xsl:value-of select="$Index"/>
                </xsl:attribute>
                <xsl:attribute name="style">display: none;</xsl:attribute>
            </div>
            <div class="RTR_tile_button_right button-right sliderbutton-bg ">
                <xsl:attribute name="id">
                    <xsl:text>RTR_plus-</xsl:text><xsl:value-of select="Channel/@ContainerIndex" />-<xsl:value-of select="$Index"/>
                </xsl:attribute>
                <xsl:attribute name="style">display: none;</xsl:attribute>
              <div class="sliderbutton-fg"></div>
              <div class="sliderbutton-label sprites {{{{gc4_button_plus}}}}"></div>
            </div>
            <div class="RTR_tile_button_right button-right sliderbutton-bg disabled">                
              <div class="sliderbutton-fg"></div>
              <div class="sliderbutton-label sprites {{{{gc4_button_plus_disabled}}}}"></div>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template match="/">
        <!-- set tileId variable -->
        <xsl:variable name="tileId">
            <xsl:call-template name="tileId"/>
        </xsl:variable>

        <!-- create controll elements -->
        <xsl:variable name="controlElements">
            <xsl:call-template name="RTC_tileButtons">
                <xsl:with-param name = "Index">
                    <xsl:value-of select="$tileId"/>
                </xsl:with-param>
            </xsl:call-template>
        </xsl:variable>

      <div class="tile tile-small">
        <xsl:attribute name="id">
          <xsl:copy-of select="$tileId" />
        </xsl:attribute>
        <xsl:attribute name="data-heating-status-id">
          <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='HeatingStatus']/@Id"/>
        </xsl:attribute>
        <xsl:attribute name="data-cooling-status-id">
          <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='CoolingStatus']/@Id"/>
        </xsl:attribute>
        <xsl:attribute name="data-setpoint-temperature-status-id">
          <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='SetpointTemperatureStatus']/@Id"/>
        </xsl:attribute>
        <xsl:attribute name="data-setpoint-temperature-shift-up-id">
          <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='SetpointTemperatureShiftUp']/@Id"/>
        </xsl:attribute>
        <xsl:attribute name="data-setpoint-temperature-shift-down-id">
          <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='SetpointTemperatureShiftDown']/@Id"/>
        </xsl:attribute>
        <xsl:attribute name="data-controller-operation-lock-status-id">
          <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='ControllerOperationLockStatus']/@Id"/>
        </xsl:attribute>
        <xsl:attribute name="data-operation-mode-status-id">
          <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='OperationModeStatus']/@Id"/>
        </xsl:attribute>
        <xsl:attribute name="data-controller-operation-locked">
          <xsl:value-of select="Channel/ControllerOperationLocked/@Enable"/>
        </xsl:attribute>
        <xsl:attribute name="data-setpoint-temperature-shift-up-id">
          <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='SetpointTemperatureShiftUp']/@Id"/>
        </xsl:attribute>
        <xsl:attribute name="data-container-index">
          <xsl:value-of select="Channel/@ContainerIndex"/>
        </xsl:attribute>
        
        <!-- generate tile structure-->
        <xsl:call-template name="tileContent">
          <xsl:with-param name="statusText">
            <div class="tile-status-text t2gg">- - - °C</div>
          </xsl:with-param>
          <xsl:with-param name="controlElements">
            <xsl:copy-of select="$controlElements" />
          </xsl:with-param>
          <xsl:with-param name="tileHeader"></xsl:with-param>
        </xsl:call-template>
        <script type="text/javascript">
          (function(){

          var tileId = '<xsl:value-of select="$tileId"/>';
          var dataset = document.getElementById(tileId).dataset;
          
          eventsOnTile(tileId);
          RtcTile.init(tileId, dataset);

          <!-- ######################### set tile click action ######################### -->
          $('#' + tileId).on('tileAction',function(){
          NavbarController.getInstance().openDetailElement(this);
          });
          })();
        </script>
      </div>
    </xsl:template>
</xsl:stylesheet>
