<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:import href="xsltemplates.xsl"/>
  <xsl:output method="html"/>
    <xsl:template match="/">
      <div id="status-bar-data">
        <xsl:attribute name="data-internal-temperature-id">
          <xsl:value-of select="//Temperature/DataPoints/DataPoint[@Name='InternalTemperature']/@Id"/>
        </xsl:attribute>
        <xsl:attribute name="data-room-temperature-enabled">
          <xsl:value-of select="//Temperature/ShowRoomTemperature/@Enable"/>
        </xsl:attribute>
        <xsl:attribute name="data-outdoor-temperature-id">
          <xsl:value-of select="//Temperature/DataPoints/DataPoint[@Name='OutdoorTemperature']/@Id"/>
        </xsl:attribute>
        <xsl:attribute name="data-outdoor-temperature-enabled">
          <xsl:value-of select="//Temperature/ShowOutdoorTemperature/@Enable"/>
        </xsl:attribute>
        <xsl:attribute name="data-unit-enabled">
          <xsl:value-of select="//Temperature/ShowUnits/@Enable"/>
        </xsl:attribute>
        <xsl:attribute name="data-unit-value">
          <xsl:value-of select="//Temperature/ShowUnits"/>
        </xsl:attribute>
        
      <xsl:call-template name="statusBar"/>
      <script type="text/javascript">
        ko.applyBindings(tsx.StatusbarController, $('#status-bar-data')[0]);
        var dataset = document.getElementById('status-bar-data').dataset;
        var unitDescriptor = "";
        if( dataset.unitEnabled === 'true') {
           unitDescriptor = " " + dataset.unitValue;
           unitDescriptor = unitDescriptor.substring(0,3);
        }
        tsx.StatusbarController.tempIn('--.- ' + unitDescriptor);
        tsx.StatusbarController.tempOut('--.- ' + unitDescriptor);
        <xsl:if test="//Temperature/ShowRoomTemperature/@Enable='true'">
          //register permanent in-temperature case set
          //use tag 36851 (tag 14643 is working if connected to a HS)
          permanentCaseSets.push(new CaseSet(dataset.internalTemperatureId, CaseSetType.VALUE).setOnValueFunction(function(value) {
              setDataFunction(tsx.StatusbarController.tempIn, parseFloat(value).toFixed(1),"--.-",unitDescriptor);
          }));
        </xsl:if>
        <xsl:if test="//Temperature/ShowOutdoorTemperature/@Enable='true'">
          permanentCaseSets.push(new CaseSet(dataset.outdoorTemperatureId, CaseSetType.VALUE).setOnValueFunction(function(value) {
              setDataFunction(tsx.StatusbarController.tempOut, parseFloat(value).toFixed(1),"--.-",unitDescriptor);
          }));
        </xsl:if>
      </script>
      </div>
    </xsl:template>
</xsl:stylesheet>
