﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:template match="/">
    #settings-overlay {
    position: absolute;
    width: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.overlay']/width" />px;
    height: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.overlay']/height" />px;
    margin: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.overlay']/margin" />;
    z-index: 90000;
    top: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.overlay']/top" />px;
    }

    #animatedSettingsContent
    {
    position: absolute;
    bottom: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.animated']/bottom" />px;
    height: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.animated']/height" />px;
    }

    #settings-view {
    width: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.view']/width" />px;
    height: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.view']/height" />px;
    padding-top: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.view']/padding-top" />px;
    overflow-y: hidden;
    overflow-x: hidden;
    }

    #settings-overlay #settings-view:hover {
    overflow-y: scroll;
    overflow-x: hidden;
    }

    .settings-container{
    width: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.container']/width" />px;
    min-height: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.container']/min-height" />px;
    margin-left: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.container']/margin-left" />px;
    background-color: #F5F5F5;
    }

    .menuPage .settings-description-row {
    width: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.description-row']/width" />px;
    height: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.description-row']/height" />px;
    background-color: rgb( 225, 225, 225);
    }

    .menuPage  .settings-description-row .settings-description-row-text {
    padding-top: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.description-row-text']/padding-top" />px;
    padding-left: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.description-row-text']/padding-left" />px;
    }
    
    .menuPage .settings-description-row-text .t3sg{
    float: left;
    }
    
    .menuPage .settings-description-row-text .spacer{
    float: left;
    width: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.description-row-text.spacer']/width" />px;
    height: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.description-row-text.spacer']/height" />px;
    }

    .menuPage .settings-row-white {
    height: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.settings-row-white']/height" />px;
    background-color: white;
    }

    .menuPage .settings-row {
    border: none;
    border-top: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.settings-row']/border" />px solid #FFFFFF;
    border-bottom: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.settings-row']/border" />px solid #c8c8c8;
    width: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.settings-row']/width" />px;
    height: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.settings-row']/height" />px;
    position: relative;
    float: none;
    clear: both;
    background-color: #F5F5F5;
    }

    .menuPage .settings-row.big {
    height: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.settings-row.big']/height" />px !important;
    }

    .menuPage .settings-row.inputField.bigger {
    height: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.settings-row.inputfield.bigger']/height" />px !important;
    }

    .menuPage .settings-row .settings-row-select {
    height: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.settings-row.select']/height" />px;
    margin-top: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.settings-row.select']/margin-top" />px;
    position: relative;
    }

    .menuPage  .settings-row .settings-row-text{
    margin-left: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.settings-row-text']/left" />px;
    display: block;
    text-overflow: ellipsis;
    white-space: nowrap;
    overflow: hidden;
    float: left;
    max-width: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.settings-row-text']/max-width" />px;
    }
    .menuPage  .settings-row .inactive{
    color: #C8C8C8;
    }

    .menuPage  .settings-row .settings-row-icon + .menuPage  .settings-row .settings-row-text{
    margin-left: 6px;
    }

    .menuPage .settings-row.dsl-placeholder {
    background-color: #ffffff !important;
    }

    .settings-description-text-item{
    border-top: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.settings-row']/border" />px solid #FFFFFF;
    border-bottom: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.settings-row']/border" />px solid #c8c8c8;
    
    padding-left: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.settings-description-text-item']/padding-left" />px;
    padding-right: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.settings-description-text-item']/padding-right" />px;
    padding-top: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.settings-description-text-item']/padding-top" />px;
    padding-bottom: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.settings-description-text-item']/padding-bottom" />px;

    width: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.settings-description-text-item']/width" />px;
    line-height: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.settings-description-text-item']/line-height" />px !important;
    background-color: #F5F5F5;
    }

    .menuPage .settings-row.inputField{
    height: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.settings-row.inputField']/height" />px;
    }

    .menuPage .settings-x-icon{
    position: absolute;
    height: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.x.icon']/height" />px;
    width: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.x.icon']/width" />px;
    top: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.x.icon']/top" />px;
    left: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.x.icon']/left" />px;
    display: none;
    }

    .menuPage .settings-row-inputField-lable{
    position: absolute;
    top: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.settings-row-inputField-lable']/top" />px;
    left: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.settings-row-inputField-lable']/left" />px;
    }
			   
    .menuPage .settings-row .settings-error-label{
	  color: rgb(220, 60, 60);
    position: absolute;
    top: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.settings-row-inputField-lable-error']/top" />px;
    left: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.settings-row-inputField-lable-error']/left" />px;
    }	

    .menuPage .sub-menu-text{
    margin-top: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.settings-row-text']/top-sub" />px;
    padding-top: 4px;
    }

    .menuPage  .settings-row .settings-arrow{
    position: absolute;
    left: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.settings-arrow']/left" />px;
    top: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.settings-arrow']/top" />px;
    }

    .menuPage  .settings-row .settings-togglebutton{
    position: absolute;
    left: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.settings-togglebutton']/left" />px;
    top: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.settings-togglebutton']/top" />px;
    }

    .menuPage  .settings-row .disabled{
    color: rgb(200, 200, 200);
    }

    .menuPage  .settings-row .settings-refresh-icon{
    position: absolute;
    left: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.settings-refresh-icon']/left" />px;
    top: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.settings-refresh-icon']/top" />px;
    }

    .menuPage .down{
    background-color: #505050;
    }

    .menuPage  .flow-top{
    height: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.flow-top']/height" />px;
    width: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.flow-top']/width" />px;
    background: -webkit-linear-gradient(top, #141414 0%,#505050 100%);
    visibility: hidden;
    position: fixed;
    }

    #settings-overlay .settings-swiper-scrollbar{
    z-index: 2;
    right: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.scrollbar']/right" />px;
    }

    #settings-view::-webkit-scrollbar {
    width: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view.scrollbar']/width" />px;
    -webkit-appearance: none;
    }

    #settings-view::-webkit-scrollbar-track {

    }

    #settings-view::-webkit-scrollbar-thumb {
    background: #C2C2C2;
    height: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view.scrollbar.thumb']/height" />px;
    }

    #settings-view::-webkit-scrollbar-thumb:window-inactive {
    background: #C2C2C2;
    }

    .menuPage .settings-row-icon{
    width: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.icon']/width" />px;
    height: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.icon']/height" />px;
    margin-top: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.icon']/margin-top" />px;
    margin-left: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.icon']/margin-left" />px;
    float: left;
    }

    .menuPage .settings-row-sortable-icon{
    width: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.icon']/width" />px;
    height: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.icon']/height" />px;
    margin-top: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.icon']/margin-top" />px;
    margin-left: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.icon']/margin-left" />px;
    float: left;
    }

    .menuPage .settings-row-text.radiobutton-with-icon{
    margin-left: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.text-radiobutton-icon']/left" />px !important;
    display: block;
    max-width: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.text-radiobutton-icon']/width" />px !important;
    }
    
       .menuPage .settings-row-text.long{
    max-width: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.text-radiobutton-icon.long']/width" />px !important;
    }
    
       .menuPage .settings-row-text.short{
    max-width: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.text-radiobutton-icon.short']/width" />px !important;
    }

    .menuPage .settings-row-radiobutton, .menuPage .settings-row-checkbox , .menuPage .checkbox-with-label {
    position: absolute;
    top: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.radiobutton']/top" />px;
    left: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.radiobutton']/left" />px;
    }

    .settings-row-radiobutton .custom-radio, .settings-row-radiobutton .custom-radio-disabled, .settings-row-radiobutton .custom-checkbox{
    height: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.custom-radiobutton']/height" />px;
    width: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.custom-radiobutton']/width" />px;
    background: rgb(225,225,225); /*235,235,235*/
    border-radius: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.custom-radiobutton']/border-radius" />%;
    box-shadow: inset 0 1px rgba(0,0,0,0.1), 0 1px #fff;
    }

    .menuPage .settings-row.down .custom-radio, .menuPage .settings-row.down .custom-radio-disabled, .settings-row-checkbox .custom-checkbox, .checkbox-with.label .custom-checkbox{
    box-shadow: none;
    }

    .menuPage .settings-row.inactive .custom-radio, .menuPage .settings-row.inactive .custom-radio-disabled{
    background: #f5f5f5; /*245,245,245*/
    box-shadow: inset 0 1px rgba(0,0,0,0.1), 0 1px #fff;
    }

    .settings-row-radiobutton .radio-input:checked + .custom-radio-label .custom-radio:before{
    content: '';
    display: block;
    width: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.custom-radiobutton-checked']/width" />px;
    height: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.custom-radiobutton-checked']/height" />px;
    position: absolute;
    border-radius: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.custom-radiobutton-checked']/border-radius" />%;
    left: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.custom-radiobutton-checked']/left" />px;
    top: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.custom-radiobutton-checked']/top" />px;
    background: #3C3C3C;
    }

    .settings-row-radiobutton .radio-input:checked + .custom-radio-label .custom-radio-disabled:before{
    content: '';
    display: block;
    width: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.custom-radiobutton-checked']/width" />px;
    height: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.custom-radiobutton-checked']/height" />px;
    position: absolute;
    border-radius: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.custom-radiobutton-checked']/border-radius" />%;
    left: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.custom-radiobutton-checked']/left" />px;
    top: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.custom-radiobutton-checked']/top" />px;
    background: rgb(200,200,200);
    }
    
    .settings-row-radiobutton .radio-input, .settings-row-checkbox .checkbox-input, .checkbox-with-label .checkbox-input{
    display:none;
    }

    .settings-row-checkbox .custom-checkbox, .checkbox-with-label .custom-checkbox{
    height: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.custom-checkbox']/height" />px;
    width: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.custom-checkbox']/width" />px;
    -webkit-border-radius:<xsl:value-of select="/metrics/settings/metric[@key = 'settings.custom-checkbox']/border-radius" />%;
    border: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.custom-checkbox']/border" />px solid rgb(180,180,180);
    -webkit-box-shadow: 0px <xsl:value-of select="/metrics/settings/metric[@key = 'settings.custom-checkbox']/border" />px 0px 0px #ffffff, 0px <xsl:value-of select="/metrics/settings/metric[@key = 'settings.custom-radiobutton']/border" />px 0px 0px rgb(255,255,255) inset;
    background-color: rgb(245,245,245);
    display: inline-block;
    }

    .settings-row.down .settings-row-checkbox .custom-checkbox, .settings-row.down .checkbox-with-label .custom-checkbox{
    -webkit-box-shadow: none !important;
    }

    .custom-checkbox-label .custom-checkbox .sprites{
    display: none;
    }
    .settings-row-checkbox .checkbox-input:checked + .custom-checkbox-label .custom-checkbox .sprites,
    .checkbox-with-label .checkbox-input:checked + .custom-checkbox-label .custom-checkbox .sprites{
    display: block;
    }

    .settings-row-sortindicator {
    float: left;
    width: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.sortindicatorhandle']/width" />px;
    height: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.sortindicatorhandle']/height" />px;
    }

    .settings-row-sortindicator div {
    width: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.sortindicatoricon']/width" />px;
    height: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.sortindicatoricon']/height" />px;
    margin-left: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.sortindicatoricon']/left" />px;
    margin-top: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.sortindicatoricon']/top" />px;
    }

   .settings-row .left, .timer-controls .left, .buttons .left, .scene-controls .left
    {
    float: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.row.left']/float" />;
    margin-left: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.row.left']/margin-left" />px;
    margin-top: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.row.left']/margin-top" />px;
    }

    .settings-row .right, .timer-controls .right, .buttons .right, .scene-controls .right
    {
    float: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.row.right']/float" />;
    margin-right: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.row.right']/margin-right" />px;
    margin-top: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.row.right']/margin-top" />px;
    }


    <!-- IPv4 input element -->
   .menuPage .input.inputform{
    position: absolute;
    top: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.inputform']/top" />px;
    left: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.inputform']/left" />px;
    width: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.inputform']/width" />px;
    height: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.inputform']/height" />px;
    margin: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.inputform']/margin" />;
    padding-left: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.inputform']/padding-left" />px;
    padding-right: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.inputform']/padding-right" />px;
    border: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.inputform']/border" />px solid rgb(180, 180, 180);
    background-color: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.inputform']/background-color" />;
    -webkit-border-radius: 18px;
    -webkit-box-shadow: inset 0px 2px 2px 0px rgba(60, 60, 60, 0.2);
   padding-top: 2px;

    }

    <!-- IPv4 input element -->
   .menuPage .input.inputformError{
    border: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.inputform']/border" />px solid rgb(220, 60, 60);
    }
	
	.menuPage .settings-row.inputField.inputFormError {
	height: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settings.settings-row-inputField.inputFormError']/height" />px;
}

    .menuPage .input.inputform:focus{
    outline: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.inputform.focus']/outline" />px;
   border: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.inputform.focus']/border" />px solid rgb(160, 160, 160);
    }

    .menuPage .input.font:disabled{
    font-family: UniversNextMedium;
    color: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.inputform.disabled']/color" />;
    font-size: <xsl:value-of select="/metrics/font/metric[@key = 't2sg']/font-size" />px;
    line-height: <xsl:value-of select="/metrics/font/metric[@key = 't2sg']/line-height" />px;
    }

    .menuPage .input.font:enabled{
    font-family: UniversNextMedium;
    color: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.inputform.enabled']/color" />;
    font-size: <xsl:value-of select="/metrics/font/metric[@key = 't2sg']/font-size" />px;
    line-height: <xsl:value-of select="/metrics/font/metric[@key = 't2sg']/line-height" />px;
    }

    .menuPage .input::-webkit-input-placeholder
    {
    color: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.inputform.enabled']/color" />;
    }
    
    .menuPage .input:disabled::-webkit-input-placeholder
    {
    color: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.inputform.disabled']/color" />;
    }

    .menuPage .input:required:invalid {
    color: rgb(220, 60, 60);
    border: 1px solid rgb(220, 60, 60);
    }

    #settingsMenuRtcCalibration .textBox, #settingsMenuRtcCalibration .textBox2 {
    margin-top: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settingsMenuRtcCalibration.textBox']/margin-top" />px;
    margin-left: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settingsMenuRtcCalibration.textBox']/margin-left" />px;
    width: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settingsMenuRtcCalibration.textBox']/width" />px;
    line-height: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settingsMenuRtcCalibration.textBox']/line-height" />px !important;
  }
  
    .menuPage .valuator{
    position: absolute;
    top: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.settingsMenuRtcCalibration.valuator']/top" />px;}
    
    .menuPage  .valuator .sw-slots li {
    height:<xsl:value-of select="/metrics/settings/metric[@key = 'settings.settingsMenuRtcCalibration.valuator.li']/height" />px;
    }

    .menuPage .checkbox-with-label {
    position: absolute;
    top: 90px;
    left: 18px;
    }

    .menuPage .checkbox-label {
    position: absolute;
    top: 102px;
    left: 66px;
    }


    .menuPage .currentConnection .ssid {
    float: left;
    max-width: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.wifi.ssid']/right" />px !important;
    }

    .menuPage .currentConnection .wifiicons {
    position: relative;
    right: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.wifi.icons']/right" />px;
    top: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.wifi.icons']/top" />px;
    }

    .menuPage .currentConnection .wifiicons .connected {
    float: right;
    margin-right: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.wifi.icons.connected']/margin-right" />px;
    }

    .menuPage .currentConnection .wifiicons .security {
    float: right;
    margin-right: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.wifi.icons.security']/margin-right" />px;
    }

    .menuPage .currentConnection .wifiicons .signalStrength {
    float: right;
    }
    
    .loadedText {
    width: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.license']/width" />px;
    margin-left: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.license']/margin-left" />px;
    margin-top: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.license']/margin-top" />px;
    }

    .paragraph, .caption, .subcaption, .link, .listentry {
    line-height: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.license']/line-height" />px !important;
    }

    .loadedText ul {
    list-style-type: none;
    margin-left: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.license.ul']/margin-left" />px;
    }


    .loadedText ul <xsl:text disable-output-escaping="yes">></xsl:text> li:before {
    content: "-";
    position: absolute;
    margin-left: <xsl:value-of select="/metrics/settings/metric[@key = 'settings.license.li']/margin-left" />px;
  }
  
  .hidden-row{
    display: none !important;
  }


</xsl:template>
</xsl:stylesheet>
