<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:import href="xsltemplates.xsl"/>
  <xsl:import href="timer/timer-xsltemplates.xsl"/>
  <xsl:output indent="yes" />
  <xsl:output method="xml" />
  <xsl:template match="/">
    <html>
      <head>
        <meta http-equiv="content-type" content="text/html;charset=utf-8" />
        <meta name="viewport" content="width=480, height=800, initial-scale=1.0, maximum-scale=1.0, user-scalable=0" />
        <link href="css/animations-gira.css" rel="stylesheet" type="text/css" />
        <link href="css/layout.css" rel="stylesheet" type="text/css" />
        <link href="css/tile.css" rel="stylesheet" type="text/css" />
        <link href="css/clickSlider.css" rel="stylesheet" type="text/css" />
        <link href="css/help.css" rel="stylesheet" type="text/css" />
        <link href="css/settings.css" rel="stylesheet" type="text/css" />
        <link href="css/overlays.css" rel="stylesheet" type="text/css" />
        <link href="css/idangerous.swiper.css" rel="stylesheet" />
        <link href="css/idangerous.swiper.scrollbar.css" rel="stylesheet" />
        <link href="css/sprites.css" rel="stylesheet" />
        <link href="css/switch.css" rel="stylesheet" />
        <link href="css/trigger.css" rel="stylesheet" />
        <link href="css/container.css" rel="stylesheet" />
        <link href="css/blindabsolute.css" rel="stylesheet" />
        <link href="css/shutterabsolute.css" rel="stylesheet" />
        <link href="css/tks.css" rel="stylesheet" />
        <link href="css/dimabs.css" rel="stylesheet" />
        <link href="css/status_detail.css" rel="stylesheet" />
        <link href="css/valueTransmitter.css" rel="stylesheet" />
        <link href="css/jquery-ui-slider-qc.css" rel="stylesheet" />
        <link href="css/popup.css" rel="stylesheet" />
        <link rel="stylesheet" type="text/css" href="css/keyboard.css" />
        <link rel="stylesheet" type="text/css" href="css/primary_function.css" />
        <link rel="stylesheet" type="text/css" href="css/timer.css" />
        <link rel="stylesheet" type="text/css" href="css/scene.css" />
        <link rel="stylesheet" type="text/css" href="css/rtc.css"/>
        <link rel="stylesheet" type="text/css" href="gira/css/gira.css"/>
        <script>
          localStorage.initialInstallationDone = true;
          if(localStorage.initialInstallationDone == undefined || localStorage.initialInstallationDone == "false"){
            window.location = "firstInstallationWizard.html";
          }
        </script>
        <script src="js/libs/state-machine.min.js"></script>
        <script src="js/fsm.js"></script>
        <script src="js/tsx.js"></script>
        <script src="js/libs/jquery/jquery.min-1.10.2.js"></script>
        <script src="js/libs/jquery/jquery-ui-1.10.4.custom.min.js"></script>
        <script src="js/libs/jquery/jquery.ui.slider-gira-1.10.4.js"></script>
        <script src="js/libs/jquery/jquery.ui.touch-punch.js"></script>
        <script src="js/libs/jquery/jquery.ui.position-1.10.4.js"></script>
        <script src="js/libs/jquery/jquery.md5.js"></script>
        <script src="js/libs/jquery/jquery.dragsort-0.5.2.min.js"></script>
        <script src="js/libs/jquery/jquery.remove-hook.js"></script>
        <script src="js/libs/jquery/jquery.bez.min.js"></script>

        <script src="js/libs/jsKeyboard.js"></script>
        <script src="js/libs/knockout-3.1.0.js"></script>
        <script src="js/libs/knockout-sortable.min.js"></script>
        <script src="js/libs/underscore-min.js"></script>

        <script src="gira/js/gira.namespaces.js"></script>
        <script src="gira/js/gira.globals.js" type="text/javascript"></script>
        <script src="gira/js/gira.log.js"></script>
        <script src="gira/js/gira.language.manager.js"></script>
        <script src="js/gira.languages.js"></script>
        <script src="gira/js/gira.I18n.js" type="text/javascript"></script>
        <script src="gira/js/gira.ko.extensions.js" type="text/javascript"></script>
        <script src="gira/js/gira.gdsConnectionWrapper.js" type="text/javascript"></script>
        <script src="gira/js/gira.gdsConnector.js" type="text/javascript"></script>
        <script src="gira/js/gira.config.loader.js" type="text/javascript"></script>
        <script src="gira/js/gira.moduleLoader.js" type="text/javascript"></script>

        <script src="js/StatusbarController.js"></script>
        <script src="js/Tile.js"></script>
        <script src="js/Template.js"></script>
        <script src="js/Widgets.js"></script>
        <script src="js/HelperFunctions.js"></script>
        <script src="js/Utility.js"></script>

        <script src="js/libs/gds/gdsquery.js"></script>
        <script src="js/libs/gds/tsxGdsUtility.js"></script>
        <script src="js/Case.js"></script>
        <script src="js/CaseSet.js"></script>
        <script src="js/GdsConnector.js"></script>
        <script src="js/ComClient.js"></script>
        <script src="js/NavBarSettingsButton.js"></script>
        <script src="js/NavbarController.js"></script>
        <script src="js/NetworkSettings.js"></script>
        <script src="js/SettingsController.js"></script>
        <script src="js/libs/swiper/idangerous.swiper.js"></script>	
        <script src="js/libs/swiper/idangerous.swiper.scrollbar.js"></script>
        <script src="js/libs/moment-with-langs.js"></script>
        <script src="js/Switch.js"></script>
        <script src="js/Trigger.js"></script>
        <script src="js/Slider.js"></script>       
        <script src="js/DimmerAbsoluteController.js"></script>
        <script src="js/SwiperFactory.js"></script>
        <script src="js/System.js"></script>
        <script src="js/BlindAbsolute.js"></script>
        <script src="js/BlindAbsoluteButton.js"></script>
        <script src="js/BlindAbsoluteTile.js"></script>
        <script src="js/Globals.js"></script>
        <script src="js/Timer.js"></script>
        <script src="js/Coverflip.js"></script>
        <script src="js/EtsConfig.js"></script>
        <script src="js/libs/jquery/jquery.knob.js"></script>
        <script src="js/libs/mustache.js"></script>
        <script src="js/rtc.js"></script>
        <script src="js/RtcModes.js"></script>
        <script src="js/RtcTile.js"></script>
        <script src="js/RtcUiController.js"></script>
        <script src="js/spinningwheel.js"></script>
        <script src="js/Status.js"></script>
        <script src="js/PrimaryFunction.js"></script>
        <script src="js/Scene.js"></script>
        <script src="js/ErrorHandler.js"></script>
        <script src="js/ConnectionErrorHandler.js"></script>
        <script src="js/PopupTsx.js"></script>
        <script src="js/Overlay.js"></script>
        <script src="js/startup.js"></script>
        <script src="js/logger.js"></script>
        <script src="js/gira.shutterRelative.js"></script>
        <script src="js/WifiConnectionSettings.js"></script>
        <script src="js/WifiSettings.js"></script>
        <script src="js/ValueTransmitter.js"></script>

        <script src="js/gira.dateTimeFormats.js"></script>
        <script src="js/gira.deviceConfigurationInterface.js"></script>
        <script src="js/gira.network.js"></script>
        <script src="js/gira.reliable.js"></script>
        <script src="js/gira.bootstrapper.js"></script>
        <script src="gira/js/gira.license.data.js"></script>
        <script src="gira/js/gira.license.viewModel.js"></script>

        <script>
          var containers;
          window.tsx.EtsConfig = window.tsx.createEtsConfig();

          sessionStorage.clear();

          // localization
          var locale = getHTTPGetParameters('locale');
          if(locale !== 'undefined') moment.lang(locale);

          permanentCaseSets = new Array();
          temporaryCaseSets = new Array();
          settingsCaseSets = new Array();

          // init System Variables
          system = new System();

          $(document).ready(function()
          {
            var bootstrapper = new window.Gira.Bootstrapper();
            bootstrapper.init();

          // populate connection infos
            var connectionInfo = getConnectionInfo();

            // prevent multitouch
            singleTouchOnly(false);

            ComClient.connect(connectionInfo['ip'], connectionInfo['port'], connectionInfo['login'], connectionInfo['password']);

            console.log("temporaryCaseSets count: " + temporaryCaseSets.length);
            permanentCaseSets.push(new CaseSet(system.displayDataPoint, CaseSetType.VALUE).setOnValueFunction(function(value) {
              if(system.displayStatus != value){
                system.displayStatus = value;
                if(parseInt(value) === 0){
                  if($("#black_transition").length == 0){
                    fsm.API.Overlay.OpenBlack();
                  }
                }else if(parseInt(value) === 1){
                  fsm.API.Overlay.CloseBlack();
                }
              }
            }));
            ComClient.registerAll(permanentCaseSets);

            setInterval(function(){getClock()},1000);
            setInterval(function(){getDate()},1000);
            //preload containers + templates
            appendFromUrl("xml/gira-ko-templates.html", $(document.body), false);

            containers = [<xsl:for-each select="//View">
              <xsl:text>'</xsl:text><xsl:value-of select="current()"/><xsl:text>',</xsl:text>
            </xsl:for-each>];

           containers.forEach(function (container) {
            try {
              preloadContainer(container);
            } catch (e) {
              window.Gira.Log.error("exception while loading container " + container + ": " + e);
            }
          });

          $('body').on("homeButtonPressed", function () { resetCoverflip(); });
          setTimeout(function(){NavbarController.getInstance().loadHomescreen();}, 100);

          jsKeyboard.init("virtualKeyboard");
          });

          //do stuff that requires a gds connection
          window.tsx.startup.onGDSConnection();

          //Last initialisation steps that require the whole doc to be ready
          $(window).load(function(){
          window.tsx.startup.onAppReady();
          });
        </script>

      </head>
      <body oncontextmenu="return false;">
        <div id="pageContent">
        <div id="statusbar">
          <xsl:copy-of select="document('../templates/statusbar/statusbar.xhtml')/."/>
          <div id="divider-sb"></div>
        </div>
        <div id="branding-row">          
          <div id="title" class="layoutHeadline t1sw">{{langBranding}}</div>
          <div id="divider-br"></div>
        </div>
        <div id="navbar">
          <div id="btnBack" class="btnBack">
            <div class="btnBackSprite sprites {{{{btnBack_inactive}}}}"></div>
          </div>  
          <div id="btnHome" class="btnHome">
            <div class="btnHomeSprite sprites {{{{btnHome}}}}"></div>
          </div>
          <div id="btnInfo" class="btnInfo">
            <div class="btnInfoSprite sprites {{{{btnInfo}}}}"></div>
          </div>
          <div id="btnSettings" class="btnSettings">
            <div class="btnSettingsSprite sprites {{{{btnSettings}}}}"></div>
          </div>
          <div id="btnGridMode" class="btnGridMode">
            <div class="btnGridModeSprite sprites {{{{btnGridMode}}}}"></div>
          </div>
          <div id="divider-nb"></div>
        </div>
        <div id="content"></div>
        </div>
        <div id="hidden-content" style="display:none;">
        </div>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>
