﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:template match="/">
/*info overlay*/
#info-overlay {
    position: absolute;
    width: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.overlay']/width" />px;
    height: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.overlay']/height" />px;
    margin: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.overlay']/margin" />;   
    z-index: 90000;
    top: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.overlay']/top2" />px;
}

#info-view-element-box {
    position: absolute;
    top: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view.element.box.buttonbar']/top" />px;
    z-index: 90001;
    height: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view.element.box.buttonbar']/height" />px;
    width: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view.element.box.buttonbar']/width" />px;
    margin-left: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view.element.box.buttonbar']/margin-left" />px;
}

#info-overlay #animatedHelpContent
{
    position: absolute;
    bottom: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.animated']/bottom" />px;
    height: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.animated']/height" />px;
}

#info-overlay #info-description-row {
    position: relative;
    height: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.description.row']/height" />px;
    background-color: white;    
}

#info-overlay #info-description-row .info-caption {
    position: absolute;
    top: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.caption']/top" />px;
    left: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.caption']/left" />px;
    width: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.caption']/width" />px;
    text-overflow: ellipsis;
    overflow: hidden;
    white-space: nowrap;
}

#info-overlay #info-description-row .info-subcaption {
    position: absolute;
    top: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.subcaption']/top" />px;
    left: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.subcaption']/left" />px;
    width: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.subcaption']/width" />px;
    text-overflow: ellipsis;
    overflow: hidden;
    white-space: nowrap;
}

#info-overlay #info-view {
    width: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view']/width" />px;
    height: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view']/height" />px;
    overflow-y: hidden;
    overflow-x: hidden;
}

#info-overlay #info-view:hover {
    overflow-y: scroll;
    overflow-x: hidden;
}

#info-overlay #info-view .container{
    width: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view.container']/width" />px;
    min-height: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view.container']/min-height" />px;
    margin-left: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view.container']/margin-left" />px;
    background-color: #F5F5F5;
}

#info-overlay #info-view  .container .info-view-container-spacer {
    height: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view.container.spacer']/height" />px;
}
#info-overlay #info-view  .container .info-view-container-end-spacer {
    height: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view.container.end-spacer']/height" />px;
}
#info-overlay #info-view  .container .info-view-container-spacer-small {
    height: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view.container.spacer-small']/height" />px;
}
#info-overlay #info-view  .container .info-view-container-spacer-small-end {
    height: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view.container.spacer-small-end']/height" />px;
}
#info-overlay #info-view  .container .info-view-container-spacer-large {
    height: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view.container.spacer-large']/height" />px;
}
#info-overlay #info-view  .container .info-view-container-spacer-large-end {
    height: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view.container.spacer-large-end']/height" />px;
}
#info-overlay #info-view .container .text {
    margin-left: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view.container.text']/margin-left" />px;
    margin-right: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view.container.text']/margin-right" />px;
}

#info-overlay #info-view .container .introduction {
    line-height: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view.container.introduction']/line-height" />px;
}

#info-overlay #info-view .container .paragraph-title {
    margin-top: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view.container.paragraph-title']/margin-top" />px;
    height: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view.container.paragraph-title']/height" />px;
}

#info-overlay #info-view .container .paragraph-text {
    white-space: pre-line;
    line-height: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view.container.paragraph-text']/line-height" />px;
}

#info-overlay #info-view .container .paragraph-icon {
    display:inline-block;
    vertical-align: top;
    margin-left: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view.container.paragraph-icon']/margin-left" />px;
    margin-right: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view.container.paragraph-icon']/margin-right" />px;
    line-height: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view.container.paragraph-icon']/line-height" />px;
    }

#info-overlay #info-view .container .info-grid-line {
    height: <xsl:value-of select="/metrics/info/metric[@key = 'info.grid.line']/height" />px;
    margin-left: <xsl:value-of select="/metrics/info/metric[@key = 'info.grid.line']/margin-left" />px;
}

#info-overlay #info-view .container .info-grid-line-large {
    width: <xsl:value-of select="/metrics/info/metric[@key = 'info.grid.line.large']/width" />px;
}

    #info-overlay .info-view-element-box-buttonbar {
    position: absolute;
    height: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view.element.box.buttonbar']/height" />px;
    width: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view.element.box.buttonbar']/width" />px;    
    border: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view.element.box.buttonbar']/border" />px;
    border-bottom: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view.element.box.buttonbar']/border-bottom" />px solid #c8c8c8;    
    z-index: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view.element.box.buttonbar']/z-index" />;
}

#info-overlay .info-fade-out{
    position: absolute;
    top: <xsl:value-of select="/metrics/info/metric[@key = 'info.info-fade-out']/top" />px;
    height: <xsl:value-of select="/metrics/info/metric[@key = 'info.info-fade-out']/height" />px;
    width: <xsl:value-of select="/metrics/info/metric[@key = 'info.info-fade-out']/width" />px; 
}

#info-overlay .info-view-element-box-white-line {
    position: absolute;
    border-bottom: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view.element.box.white.line']/border-bottom" />px solid #FFFFFF;
    width: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view.element.box.white.line']/width" />px;
    top: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view.element.box.white.line']/top" />px;
}


#info-overlay .btnLeft{
    position: relative;
    top: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.btn-left']/top" />px;
    left: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.btn-left']/left" />px;
    float: left;
}

#info-overlay .btnRight{
    position: relative;
    top: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.btn-left']/top" />px;
    right: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.btn-left']/left" />px;
    float: right;
}

#info-overlay .btnText{
    max-width: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.btn-text']/max-width" />px;
    margin-left: auto;
    margin-right: auto;
}

#info-overlay .info-swiper-scrollbar{
    z-index: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view.scrollbar']/z-index" />;
    right: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view.scrollbar']/right" />;px;
}

#info-view::-webkit-scrollbar {
    width: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view.scrollbar']/width" />px;
    -webkit-appearance: none;
}

#info-view::-webkit-scrollbar-track {

}

#info-view::-webkit-scrollbar-thumb {
    background: #C2C2C2;
    height: <xsl:value-of select="/metrics/info/metric[@key = 'info.info.view.scrollbar.thumb']/height" />px;
}

#info-view::-webkit-scrollbar-thumb:window-inactive {
    background: #C2C2C2; 
}
  </xsl:template>
</xsl:stylesheet>
