﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output indent="yes" />
  <xsl:output method="html"/>
  <xsl:template match="/">
    .detail-folder-register {
    background: url(../img/gc4_folder_register.png) no-repeat left top;
    width: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-folder-register']/width" />px;
    height: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-folder-register']/height" />px;
    position: absolute;
    left: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-folder-register']/left" />px;
    }

    .detail-folder-body {
    background: url(../img/gc4_folder_body.png) no-repeat left top;
    width: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-folder-body']/width" />px;
    height: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-folder-body']/height" />px;
    position: absolute;
    top: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-folder-body']/top" />px;
    }

    .detail-folder-body .numcontent {
    position: absolute;
    top: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-folder-body-numcontent']/top" />px;
    left: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-folder-body-numcontent']/left" />px;
    font-size: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-folder-body-numcontent']/font-size" />px;
    line-height: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-folder-body-numcontent']/line-height" />px;
    }

    .detail-folder-body .methodsstring {
    position: absolute;
    top: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-folder-body-methodsstring']/top" />px;
    left: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-folder-body-methodsstring']/left" />px;
    }

    .detail-folder-body .listcontent {
    position: absolute;
    top: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-folder-body-listcontent']/top" />px;
    left: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-folder-body-listcontent']/left" />px;
    height: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-folder-body-listcontent']/height" />px;
    width: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-folder-body-listcontent']/width" />px;
    border-radius: 6px;
    border: 1px solid #b4b4b4;
    box-shadow:0px 1px 0px 0px #ffffff, 0px 1px 0px 0px #ffffff inset;
    overflow: hidden;
    }

    .detail-folder-body .listcontent span {
    height: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-folder-body-listcontent.span']/height" />px;
    width: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-folder-body-listcontent.span']/width" />px;
    display: inline;
    }

    .detail-folder-body .listcontent .textline {
    padding-left: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-folder-body-listcontent.textline']/padding-left" />px;
    display: block !important;
    }

    .detail-folder-body .listcontent .textline .title {
    position: relative;
    top: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-folder-body-listcontent.textline.title']/top" />px;
    text-overflow: ellipsis;
    overflow: hidden;
    white-space: nowrap;
    max-width: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-folder-body-listcontent.textline.title']/width" />px;
    display: inline-block;
    padding-top: 4px;
    }

    .detail-folder-body .listcontent .gridline {
    height: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-folder-body-listcontent.gridline']/height" />px;
    background: url(../img/<xsl:value-of select="/metrics/tile/metric[@key = 'tile.grid.line']/width" />x<xsl:value-of select="/metrics/tile/metric[@key = 'tile.grid.line']/height" />_repeating_gc4_grid_line.png) repeat-x top;
    display: block;
    }

    .detail-folder-body .swiper-wrapper {
    width: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-folder-body-listcontent.swiper-wrapper']/width" />px !important;
    }
    
    .detail-folder-body .swiper-slide {
    width: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-folder-body-listcontent.swiper-slide']/width" />px !important;
    }

    .detail-folder-body .info-swiper-scrollbar-vertical {
    position: absolute;
    width: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-folder-body-listcontent.info-swiper-scrollbar-vertical']/width" />px;
    height: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-folder-body-listcontent.info-swiper-scrollbar-vertical']/height" />px;
    top: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-folder-body-listcontent.info-swiper-scrollbar-vertical']/top" />px;
    background: transparent;
    z-index: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-folder-body-listcontent.info-swiper-scrollbar-vertical']/z-index" />;
    right: <xsl:value-of select="/metrics/detail/metric[@key = 'detail-folder-body-listcontent.info-swiper-scrollbar-vertical']/right" />px;
    display: block !important;
    overflow: hidden;
    }

    .detail-folder-body .info-swiper-scrollbar-vertical .swiper-scrollbar-drag {
    min-height: 60px;
    }

    .detail-folder-down{
    position:absolute;
    z-index: 10000;
    display: none;
    }

  </xsl:template>
</xsl:stylesheet>