﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:import href="xsltemplates.xsl"/>
    <xsl:output indent="yes" />
    <xsl:output method="html"/>
    <xsl:template match="/">
      <div>
      <xsl:variable name="detailId">detail-<xsl:value-of select="Channel/@ContainerIndex" />-<xsl:value-of select="Channel/@Index" /></xsl:variable>
        <xsl:call-template name="channel_detail_description_row"></xsl:call-template>
      <div class="detail detailflip">
        <xsl:attribute name="id"><xsl:copy-of select="$detailId" /></xsl:attribute>
        <xsl:attribute name="data-height-position-id">
          <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='HeightPosition']/@Id"/>
        </xsl:attribute>
        <xsl:attribute name="data-slat-position-id">
          <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='SlatPosition']/@Id"/>
        </xsl:attribute>
        <xsl:attribute name="data-height-position-state-id">
          <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='HeightPositionState']/@Id"/>
        </xsl:attribute>
        <xsl:attribute name="data-slat-position-state-id">
          <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='SlatPositionState']/@Id"/>
        </xsl:attribute>
        <xsl:attribute name="data-movement-id">
          <xsl:value-of select="Channel/DataPoints/DataPoint[@TypeURN='de.gira.schema.datapoints.Movement']/@Id"/>
        </xsl:attribute>
        <xsl:attribute name="data-stop-id">
          <xsl:value-of select="Channel/DataPoints/DataPoint[@Name='Stop']/@Id"/>
        </xsl:attribute>
        <xsl:attribute name="data-height-status-value-enabled">
          <xsl:value-of select="Channel/StatusValueHeightPosition/@Enable"/>
        </xsl:attribute>
        <xsl:attribute name="data-slat-status-value-enabled">
          <xsl:value-of select="Channel/StatusValueSlatPosition/@Enable"/>
        </xsl:attribute>
        <xsl:attribute name="data-container-index">
          <xsl:value-of select="Channel/@ContainerIndex"/>
        </xsl:attribute>
        <xsl:attribute name="data-count">
          <xsl:value-of select="Channel/@count"/>
        </xsl:attribute> 
        
        <xsl:call-template name="shutterBlindAbsolutLayout">
          <xsl:with-param name="valueLeft" select="Channel/StatusValueHeightPosition/@Enable"/>
          <xsl:with-param name="valueRight" select="Channel/StatusValueSlatPosition/@Enable"/>
          <xsl:with-param name="sliders">
            <div class="blind-up sprites {{{{gc4_blind_up}}}}"></div>
            <div class="blind-down sprites {{{{gc4_blind_down}}}}"></div>
            <div id="slider1" class="slider_left"></div>
            <div class="scala-double sprites {{{{gc4_dim_skala_double}}}}"> </div>
            <div id="slider2" class="slider_right"> </div>
            <div class="lamination-up sprites {{{{gc4_lamination_up}}}}"></div>
            <div class="lamination-down sprites {{{{gc4_lamination_down}}}}"></div>
          </xsl:with-param>
        </xsl:call-template>
        <script type="text/javascript">
          (function(){
          var detailId = '<xsl:value-of select="$detailId" />';
          var dataset = document.getElementById(detailId).dataset;
          var valueTextLeft = dataset.heightStatusValueEnabled === 'true';
          var valueTextRight = dataset.slatStatusValueEnabled === 'true';
         

          <xsl:if test="Channel/DataPoints/DataPoint/@TypeURN = 'de.gira.schema.datapoints.StepUpDown'">
            tsx.BlindAbsolute.eventsOnStop('#'+detailId, dataset.stopId);
          </xsl:if>

            initSlider('sliderOne', 'left','left', dataset.heightPositionId, dataset.heightPositionStateId, dataset.movementId, globals.blind.animationSpeed, globals.blind.inUseTimer, valueTextLeft, '#'+detailId);
            initSlider('sliderTwo', 'right','right', dataset.slatPositionId, dataset.slatPositionStateId, dataset.movementId, globals.blind.animationSpeed, globals.blind.inUseTimer, valueTextRight, '#'+detailId);
            
          <xsl:if test="Channel/TimeSwitches/@Enable ='true'">
            var timerFunctions = [{name: "heightPos", datapoint: dataset.heightPositionId, values: [0, 10, 20, 30, 40, 50, 60, 70, 80, 90, 100]}];
            tsx.timer.registerTimer(detailId, 'blindShutter', dataset.count, timerFunctions);
          </xsl:if>

            })();
        </script>
        </div>
        </div>
      </xsl:template>
</xsl:stylesheet>

